# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2020-04-15 19:28
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


def initialize_antenna_types(apps, schema_editor):
    AntennaType = apps.get_model("base", "AntennaType")
    AntennaType.objects.bulk_create(
        [
            AntennaType(name="Dipole"),
            AntennaType(name="V-Dipole"),
            AntennaType(name="Discone"),
            AntennaType(name="Ground Plane"),
            AntennaType(name="Yagi"),
            AntennaType(name="Cross Yagi"),
            AntennaType(name="Helical"),
            AntennaType(name="Parabolic"),
            AntennaType(name="Vertical"),
            AntennaType(name="Turnstile"),
            AntennaType(name="Quadrafilar"),
            AntennaType(name="Eggbeater"),
            AntennaType(name="Lindenblad"),
            AntennaType(name="Parasitic Lindenblad"),
            AntennaType(name="Patch"),
            AntennaType(name="Other Directional"),
            AntennaType(name="Other Omni-Directional"),
        ]
    )


def revert_initialize_antenna_types(apps, schema_editor):
    AntennaType = apps.get_model("base", "AntennaType")
    AntennaType.objects.filter(
        name__in=[
            "Dipole", "V-Dipole", "Discone", "Ground Plane", "Yagi", "Cross Yagi", "Helical",
            "Parabolic", "Vertical", "Turnstile", "Quadrafilar", "Eggbeater", "Lindenblad",
            "Parasitic Lindenblad", "Patch", "Other Directional", "Other Omni-Directional"
        ]
    ).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('base', '0064_increase_mode_name_char_limit'),
    ]

    operations = [
        migrations.CreateModel(
            name='AntennaType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=25, unique=True)),
            ],
        ),
        migrations.RunPython(initialize_antenna_types, revert_initialize_antenna_types),
        migrations.CreateModel(
            name='FrequencyRange',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('min_frequency', models.PositiveIntegerField()),
                ('max_frequency', models.PositiveIntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='StationAntenna',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('antenna_type', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='station_antennas', to='base.AntennaType')),
                ('station', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='antennas', to='base.Station')),
            ],
        ),
        migrations.AddField(
            model_name='frequencyrange',
            name='antenna',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='frequency_ranges', to='base.StationAntenna'),
        ),
    ]
