/**********************************************************************/
/* File generated by src/simix/simcalls.py from src/simix/simcalls.in */
/*                                                                    */
/*                    DO NOT EVER CHANGE THIS FILE                    */
/*                                                                    */
/* change simcalls specification in src/simix/simcalls.in             */
/* Copyright (c) 2014-2021. The SimGrid Team. All rights reserved.    */
/**********************************************************************/

/*
 * Note that the name comes from http://en.wikipedia.org/wiki/Popping
 * Indeed, the control flow is doing a strange dance in there.
 *
 * That's not about http://en.wikipedia.org/wiki/Poop, despite the odor :)
 */

#include <simgrid/config.h>
#include <simgrid/host.h>
#include <xbt/base.h>
#if SIMGRID_HAVE_MC
#include "src/mc/mc_forward.hpp"
#endif
#include "src/kernel/activity/ConditionVariableImpl.hpp"
#include "src/kernel/actor/SimcallObserver.hpp"
#include "src/kernel/context/Context.hpp"

XBT_LOG_EXTERNAL_DEFAULT_CATEGORY(simix_popping);

using simgrid::simix::Simcall;
/** @brief Simcalls' names (generated from src/simix/simcalls.in) */
constexpr std::array<const char*, simgrid::simix::NUM_SIMCALLS> simcall_names{{
    "Simcall::NONE",
    "Simcall::COMM_RECV",
    "Simcall::COMM_IRECV",
    "Simcall::COMM_SEND",
    "Simcall::COMM_ISEND",
    "Simcall::COMM_TEST",
    "Simcall::COMM_TESTANY",
    "Simcall::COMM_WAITANY",
    "Simcall::COMM_WAIT",
    "Simcall::RUN_KERNEL",
    "Simcall::RUN_BLOCKING",
}};

/** @private
 * @brief (in kernel mode) unpack the simcall and activate the handler
 *
 * This function is generated from src/simix/simcalls.in
 */
void simgrid::kernel::actor::ActorImpl::simcall_handle(int times_considered)
{
  XBT_DEBUG("Handling simcall %p: %s", &simcall_, SIMIX_simcall_name(simcall_));
  simcall_.mc_value_ = times_considered;
  if (simcall_.observer_ != nullptr)
    simcall_.observer_->prepare(times_considered);
  if (context_->wannadie())
    return;
  switch (simcall_.call_) {
    case Simcall::COMM_RECV:
      simcall_HANDLER_comm_recv(&simcall_, simgrid::simix::unmarshal<smx_actor_t>(simcall_.args_[0]), simgrid::simix::unmarshal<smx_mailbox_t>(simcall_.args_[1]), simgrid::simix::unmarshal<unsigned char*>(simcall_.args_[2]), simgrid::simix::unmarshal<size_t*>(simcall_.args_[3]), simgrid::simix::unmarshal<simix_match_func_t>(simcall_.args_[4]), simgrid::simix::unmarshal<simix_copy_data_func_t>(simcall_.args_[5]), simgrid::simix::unmarshal<void*>(simcall_.args_[6]), simgrid::simix::unmarshal<double>(simcall_.args_[7]), simgrid::simix::unmarshal<double>(simcall_.args_[8]));
      break;

    case Simcall::COMM_IRECV:
      simgrid::simix::marshal<boost::intrusive_ptr<simgrid::kernel::activity::ActivityImpl>>(simcall_.result_, simcall_HANDLER_comm_irecv(&simcall_, simgrid::simix::unmarshal<smx_actor_t>(simcall_.args_[0]), simgrid::simix::unmarshal<smx_mailbox_t>(simcall_.args_[1]), simgrid::simix::unmarshal<unsigned char*>(simcall_.args_[2]), simgrid::simix::unmarshal<size_t*>(simcall_.args_[3]), simgrid::simix::unmarshal<simix_match_func_t>(simcall_.args_[4]), simgrid::simix::unmarshal<simix_copy_data_func_t>(simcall_.args_[5]), simgrid::simix::unmarshal<void*>(simcall_.args_[6]), simgrid::simix::unmarshal<double>(simcall_.args_[7])));
      simcall_answer();
      break;

    case Simcall::COMM_SEND:
      simcall_HANDLER_comm_send(&simcall_, simgrid::simix::unmarshal<smx_actor_t>(simcall_.args_[0]), simgrid::simix::unmarshal<smx_mailbox_t>(simcall_.args_[1]), simgrid::simix::unmarshal<double>(simcall_.args_[2]), simgrid::simix::unmarshal<double>(simcall_.args_[3]), simgrid::simix::unmarshal<unsigned char*>(simcall_.args_[4]), simgrid::simix::unmarshal<size_t>(simcall_.args_[5]), simgrid::simix::unmarshal<simix_match_func_t>(simcall_.args_[6]), simgrid::simix::unmarshal<simix_copy_data_func_t>(simcall_.args_[7]), simgrid::simix::unmarshal<void*>(simcall_.args_[8]), simgrid::simix::unmarshal<double>(simcall_.args_[9]));
      break;

    case Simcall::COMM_ISEND:
      simgrid::simix::marshal<boost::intrusive_ptr<simgrid::kernel::activity::ActivityImpl>>(simcall_.result_, simcall_HANDLER_comm_isend(&simcall_, simgrid::simix::unmarshal<smx_actor_t>(simcall_.args_[0]), simgrid::simix::unmarshal<smx_mailbox_t>(simcall_.args_[1]), simgrid::simix::unmarshal<double>(simcall_.args_[2]), simgrid::simix::unmarshal<double>(simcall_.args_[3]), simgrid::simix::unmarshal<unsigned char*>(simcall_.args_[4]), simgrid::simix::unmarshal<size_t>(simcall_.args_[5]), simgrid::simix::unmarshal<simix_match_func_t>(simcall_.args_[6]), simgrid::simix::unmarshal<simix_clean_func_t>(simcall_.args_[7]), simgrid::simix::unmarshal<simix_copy_data_func_t>(simcall_.args_[8]), simgrid::simix::unmarshal<void*>(simcall_.args_[9]), simgrid::simix::unmarshal<bool>(simcall_.args_[10])));
      simcall_answer();
      break;

    case Simcall::COMM_TEST:
      simgrid::simix::marshal<bool>(simcall_.result_, simcall_HANDLER_comm_test(&simcall_, simgrid::simix::unmarshal<simgrid::kernel::activity::CommImpl*>(simcall_.args_[0])));
      simcall_answer();
      break;

    case Simcall::COMM_TESTANY:
      simgrid::simix::marshal<ssize_t>(simcall_.result_, simcall_HANDLER_comm_testany(&simcall_, simgrid::simix::unmarshal<simgrid::kernel::activity::CommImpl**>(simcall_.args_[0]), simgrid::simix::unmarshal<size_t>(simcall_.args_[1])));
      simcall_answer();
      break;

    case Simcall::COMM_WAITANY:
      simcall_HANDLER_comm_waitany(&simcall_, simgrid::simix::unmarshal<simgrid::kernel::activity::CommImpl**>(simcall_.args_[0]), simgrid::simix::unmarshal<size_t>(simcall_.args_[1]), simgrid::simix::unmarshal<double>(simcall_.args_[2]));
      break;

    case Simcall::COMM_WAIT:
      simcall_HANDLER_comm_wait(&simcall_, simgrid::simix::unmarshal<simgrid::kernel::activity::CommImpl*>(simcall_.args_[0]), simgrid::simix::unmarshal<double>(simcall_.args_[1]));
      break;

    case Simcall::RUN_KERNEL:
      SIMIX_run_kernel(simgrid::simix::unmarshal<std::function<void()> const*>(simcall_.args_[0]));
      simcall_answer();
      break;

    case Simcall::RUN_BLOCKING:
      SIMIX_run_blocking(simgrid::simix::unmarshal<std::function<void()> const*>(simcall_.args_[0]));
      break;

    case Simcall::NONE:
      throw std::invalid_argument(simgrid::xbt::string_printf("Asked to do the noop syscall on %s@%s",
                                                              get_cname(),
                                                              sg_host_get_name(get_host())));
    default:
      THROW_IMPOSSIBLE;
  }
}
