/**********************************************************************/
/* File generated by src/simix/simcalls.py from src/simix/simcalls.in */
/*                                                                    */
/*                    DO NOT EVER CHANGE THIS FILE                    */
/*                                                                    */
/* change simcalls specification in src/simix/simcalls.in             */
/* Copyright (c) 2014-2021. The SimGrid Team. All rights reserved.    */
/**********************************************************************/

/*
 * Note that the name comes from http://en.wikipedia.org/wiki/Popping
 * Indeed, the control flow is doing a strange dance in there.
 *
 * That's not about http://en.wikipedia.org/wiki/Poop, despite the odor :)
 */

#include "src/kernel/EngineImpl.hpp"
#include "src/kernel/actor/ActorImpl.hpp"
#include "src/mc/mc_forward.hpp"
#include "xbt/ex.h"
#include <functional>
#include <simgrid/simix.hpp>
#include <xbt/log.h>
/** @cond */ // Please Doxygen, don't look at this

XBT_LOG_EXTERNAL_DEFAULT_CATEGORY(simix);

using simgrid::simix::Simcall;

template<class R, class... T>
inline static R simcall(Simcall call, T const&... t)
{
  auto self = simgrid::kernel::actor::ActorImpl::self();
  simgrid::simix::marshal(&self->simcall_, call, t...);
  if (not simgrid::kernel::EngineImpl::get_instance()->is_maestro(self)) {
    XBT_DEBUG("Yield process '%s' on simcall %s", self->get_cname(), SIMIX_simcall_name(self->simcall_));
    self->yield();
  } else {
    self->simcall_handle(0);
  }
  return simgrid::simix::unmarshal<R>(self->simcall_.result_);
}

inline static void simcall_BODY_comm_recv(smx_actor_t receiver, smx_mailbox_t mbox, unsigned char* dst_buff, size_t* dst_buff_size, simix_match_func_t match_fun, simix_copy_data_func_t copy_data_fun, void* data, double timeout, double rate)
{
  if (false) /* Go to that function to follow the code flow through the simcall barrier */
    simcall_HANDLER_comm_recv(&simgrid::kernel::actor::ActorImpl::self()->simcall_, receiver, mbox, dst_buff, dst_buff_size, match_fun, copy_data_fun, data, timeout, rate);
  return simcall<void, smx_actor_t, smx_mailbox_t, unsigned char*, size_t*, simix_match_func_t, simix_copy_data_func_t, void*, double, double>(Simcall::COMM_RECV, receiver, mbox, dst_buff, dst_buff_size, match_fun, copy_data_fun, data, timeout, rate);
}

inline static boost::intrusive_ptr<simgrid::kernel::activity::ActivityImpl> simcall_BODY_comm_irecv(smx_actor_t receiver, smx_mailbox_t mbox, unsigned char* dst_buff, size_t* dst_buff_size, simix_match_func_t match_fun, simix_copy_data_func_t copy_data_fun, void* data, double rate)
{
  if (false) /* Go to that function to follow the code flow through the simcall barrier */
    simcall_HANDLER_comm_irecv(&simgrid::kernel::actor::ActorImpl::self()->simcall_, receiver, mbox, dst_buff, dst_buff_size, match_fun, copy_data_fun, data, rate);
  return simcall<boost::intrusive_ptr<simgrid::kernel::activity::ActivityImpl>, smx_actor_t, smx_mailbox_t, unsigned char*, size_t*, simix_match_func_t, simix_copy_data_func_t, void*, double>(Simcall::COMM_IRECV, receiver, mbox, dst_buff, dst_buff_size, match_fun, copy_data_fun, data, rate);
}

inline static void simcall_BODY_comm_send(smx_actor_t sender, smx_mailbox_t mbox, double task_size, double rate, unsigned char* src_buff, size_t src_buff_size, simix_match_func_t match_fun, simix_copy_data_func_t copy_data_fun, void* data, double timeout)
{
  if (false) /* Go to that function to follow the code flow through the simcall barrier */
    simcall_HANDLER_comm_send(&simgrid::kernel::actor::ActorImpl::self()->simcall_, sender, mbox, task_size, rate, src_buff, src_buff_size, match_fun, copy_data_fun, data, timeout);
  return simcall<void, smx_actor_t, smx_mailbox_t, double, double, unsigned char*, size_t, simix_match_func_t, simix_copy_data_func_t, void*, double>(Simcall::COMM_SEND, sender, mbox, task_size, rate, src_buff, src_buff_size, match_fun, copy_data_fun, data, timeout);
}

inline static boost::intrusive_ptr<simgrid::kernel::activity::ActivityImpl> simcall_BODY_comm_isend(smx_actor_t sender, smx_mailbox_t mbox, double task_size, double rate, unsigned char* src_buff, size_t src_buff_size, simix_match_func_t match_fun, simix_clean_func_t clean_fun, simix_copy_data_func_t copy_data_fun, void* data, bool detached)
{
  if (false) /* Go to that function to follow the code flow through the simcall barrier */
    simcall_HANDLER_comm_isend(&simgrid::kernel::actor::ActorImpl::self()->simcall_, sender, mbox, task_size, rate, src_buff, src_buff_size, match_fun, clean_fun, copy_data_fun, data, detached);
  return simcall<boost::intrusive_ptr<simgrid::kernel::activity::ActivityImpl>, smx_actor_t, smx_mailbox_t, double, double, unsigned char*, size_t, simix_match_func_t, simix_clean_func_t, simix_copy_data_func_t, void*, bool>(Simcall::COMM_ISEND, sender, mbox, task_size, rate, src_buff, src_buff_size, match_fun, clean_fun, copy_data_fun, data, detached);
}

inline static bool simcall_BODY_comm_test(simgrid::kernel::activity::CommImpl* comm)
{
  if (false) /* Go to that function to follow the code flow through the simcall barrier */
    simcall_HANDLER_comm_test(&simgrid::kernel::actor::ActorImpl::self()->simcall_, comm);
  return simcall<bool, simgrid::kernel::activity::CommImpl*>(Simcall::COMM_TEST, comm);
}

inline static ssize_t simcall_BODY_comm_testany(simgrid::kernel::activity::CommImpl** comms, size_t count)
{
  if (false) /* Go to that function to follow the code flow through the simcall barrier */
    simcall_HANDLER_comm_testany(&simgrid::kernel::actor::ActorImpl::self()->simcall_, comms, count);
  return simcall<ssize_t, simgrid::kernel::activity::CommImpl**, size_t>(Simcall::COMM_TESTANY, comms, count);
}

inline static ssize_t simcall_BODY_comm_waitany(simgrid::kernel::activity::CommImpl** comms, size_t count, double timeout)
{
  if (false) /* Go to that function to follow the code flow through the simcall barrier */
    simcall_HANDLER_comm_waitany(&simgrid::kernel::actor::ActorImpl::self()->simcall_, comms, count, timeout);
  return simcall<ssize_t, simgrid::kernel::activity::CommImpl**, size_t, double>(Simcall::COMM_WAITANY, comms, count, timeout);
}

inline static void simcall_BODY_comm_wait(simgrid::kernel::activity::CommImpl* comm, double timeout)
{
  if (false) /* Go to that function to follow the code flow through the simcall barrier */
    simcall_HANDLER_comm_wait(&simgrid::kernel::actor::ActorImpl::self()->simcall_, comm, timeout);
  return simcall<void, simgrid::kernel::activity::CommImpl*, double>(Simcall::COMM_WAIT, comm, timeout);
}

inline static void simcall_BODY_run_kernel(std::function<void()> const* code)
{
  if (false) /* Go to that function to follow the code flow through the simcall barrier */
    SIMIX_run_kernel(code);
  return simcall<void, std::function<void()> const*>(Simcall::RUN_KERNEL, code);
}

inline static void simcall_BODY_run_blocking(std::function<void()> const* code)
{
  if (false) /* Go to that function to follow the code flow through the simcall barrier */
    SIMIX_run_blocking(code);
  return simcall<void, std::function<void()> const*>(Simcall::RUN_BLOCKING, code);
}
/** @endcond */
