import * as iam from '@aws-cdk/aws-iam';
import * as cr from '@aws-cdk/custom-resources';
import { Construct } from '@aws-cdk/core';
/**
 * Construction properties for OpenSearchAccessPolicy
 */
export interface OpenSearchAccessPolicyProps {
    /**
     * The OpenSearch Domain name
     */
    readonly domainName: string;
    /**
     * The OpenSearch Domain ARN
     */
    readonly domainArn: string;
    /**
     * The access policy statements for the OpenSearch cluster
     */
    readonly accessPolicies: iam.PolicyStatement[];
}
/**
 * Creates LogGroup resource policies.
 */
export declare class OpenSearchAccessPolicy extends cr.AwsCustomResource {
    constructor(scope: Construct, id: string, props: OpenSearchAccessPolicyProps);
}
