"""initial migration

Revision ID: 26934c96ec80
Revises:
Create Date: 2021-09-22 04:12:38.479740

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "26934c96ec80"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "data_categories",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("fides_key", sa.String(), nullable=False),
        sa.Column("organization_fides_key", sa.Text(), nullable=True),
        sa.Column("name", sa.Text(), nullable=True),
        sa.Column("description", sa.Text(), nullable=True),
        sa.Column("parent_key", sa.Text(), nullable=True),
        sa.PrimaryKeyConstraint("id", "fides_key"),
    )
    op.create_index(
        op.f("ix_data_categories_fides_key"),
        "data_categories",
        ["fides_key"],
        unique=True,
    )
    op.create_index(
        op.f("ix_data_categories_id"), "data_categories", ["id"], unique=True
    )
    op.create_table(
        "data_qualifiers",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("fides_key", sa.String(), nullable=False),
        sa.Column("organization_fides_key", sa.Text(), nullable=True),
        sa.Column("name", sa.Text(), nullable=True),
        sa.Column("description", sa.Text(), nullable=True),
        sa.PrimaryKeyConstraint("id", "fides_key"),
    )
    op.create_index(
        op.f("ix_data_qualifiers_fides_key"),
        "data_qualifiers",
        ["fides_key"],
        unique=True,
    )
    op.create_index(
        op.f("ix_data_qualifiers_id"), "data_qualifiers", ["id"], unique=True
    )
    op.create_table(
        "data_subjects",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("fides_key", sa.String(), nullable=False),
        sa.Column("organization_fides_key", sa.Text(), nullable=True),
        sa.Column("name", sa.Text(), nullable=True),
        sa.Column("description", sa.Text(), nullable=True),
        sa.PrimaryKeyConstraint("id", "fides_key"),
    )
    op.create_index(
        op.f("ix_data_subjects_fides_key"), "data_subjects", ["fides_key"], unique=True
    )
    op.create_index(op.f("ix_data_subjects_id"), "data_subjects", ["id"], unique=True)
    op.create_table(
        "data_uses",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("fides_key", sa.String(), nullable=False),
        sa.Column("organization_fides_key", sa.Text(), nullable=True),
        sa.Column("name", sa.Text(), nullable=True),
        sa.Column("description", sa.Text(), nullable=True),
        sa.Column("parent_key", sa.Text(), nullable=True),
        sa.PrimaryKeyConstraint("id", "fides_key"),
    )
    op.create_index(
        op.f("ix_data_uses_fides_key"), "data_uses", ["fides_key"], unique=True
    )
    op.create_index(op.f("ix_data_uses_id"), "data_uses", ["id"], unique=True)
    op.create_table(
        "datasets",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("fides_key", sa.String(), nullable=False),
        sa.Column("organization_fides_key", sa.Text(), nullable=True),
        sa.Column("name", sa.Text(), nullable=True),
        sa.Column("description", sa.Text(), nullable=True),
        sa.Column("meta", sa.JSON(), nullable=True),
        sa.Column("data_categories", sa.ARRAY(sa.String()), nullable=True),
        sa.Column("data_qualifier", sa.ARRAY(sa.String()), nullable=True),
        sa.Column("location", sa.String(), nullable=True),
        sa.Column("dataset_type", sa.String(), nullable=True),
        sa.Column("fields", sa.JSON(), nullable=True),
        sa.PrimaryKeyConstraint("id", "fides_key"),
    )
    op.create_index(
        op.f("ix_datasets_fides_key"), "datasets", ["fides_key"], unique=True
    )
    op.create_index(op.f("ix_datasets_id"), "datasets", ["id"], unique=True)
    op.create_table(
        "evaluations",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("fides_key", sa.String(), nullable=False),
        sa.Column("status", sa.String(), nullable=True),
        sa.Column("details", sa.ARRAY(sa.String()), nullable=True),
        sa.Column("message", sa.String(), nullable=True),
        sa.PrimaryKeyConstraint("id", "fides_key"),
    )
    op.create_index(
        op.f("ix_evaluations_fides_key"), "evaluations", ["fides_key"], unique=True
    )
    op.create_index(op.f("ix_evaluations_id"), "evaluations", ["id"], unique=True)
    op.create_table(
        "organizations",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("fides_key", sa.String(), nullable=False),
        sa.Column("organization_fides_key", sa.Text(), nullable=True),
        sa.Column("name", sa.Text(), nullable=True),
        sa.Column("description", sa.Text(), nullable=True),
        sa.Column("organization_parent_key", sa.String(), nullable=True),
        sa.PrimaryKeyConstraint("id", "fides_key"),
    )
    op.create_index(
        op.f("ix_organizations_fides_key"), "organizations", ["fides_key"], unique=True
    )
    op.create_index(op.f("ix_organizations_id"), "organizations", ["id"], unique=True)
    op.create_table(
        "policies",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("fides_key", sa.String(), nullable=False),
        sa.Column("organization_fides_key", sa.Text(), nullable=True),
        sa.Column("name", sa.Text(), nullable=True),
        sa.Column("description", sa.Text(), nullable=True),
        sa.Column("rules", sa.JSON(), nullable=True),
        sa.PrimaryKeyConstraint("id", "fides_key"),
    )
    op.create_index(
        op.f("ix_policies_fides_key"), "policies", ["fides_key"], unique=True
    )
    op.create_index(op.f("ix_policies_id"), "policies", ["id"], unique=True)
    op.create_table(
        "registries",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("fides_key", sa.String(), nullable=False),
        sa.Column("organization_fides_key", sa.Text(), nullable=True),
        sa.Column("name", sa.Text(), nullable=True),
        sa.Column("description", sa.Text(), nullable=True),
        sa.PrimaryKeyConstraint("id", "fides_key"),
    )
    op.create_index(
        op.f("ix_registries_fides_key"), "registries", ["fides_key"], unique=True
    )
    op.create_index(op.f("ix_registries_id"), "registries", ["id"], unique=True)
    op.create_table(
        "systems",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("fides_key", sa.String(), nullable=False),
        sa.Column("organization_fides_key", sa.Text(), nullable=True),
        sa.Column("name", sa.Text(), nullable=True),
        sa.Column("description", sa.Text(), nullable=True),
        sa.Column("registry_id", sa.String(), nullable=True),
        sa.Column("meta", sa.JSON(), nullable=True),
        sa.Column("system_type", sa.String(), nullable=True),
        sa.Column("system_dependencies", sa.ARRAY(sa.String()), nullable=True),
        sa.Column("privacy_declarations", sa.JSON(), nullable=True),
        sa.PrimaryKeyConstraint("id", "fides_key"),
    )
    op.create_index(op.f("ix_systems_fides_key"), "systems", ["fides_key"], unique=True)
    op.create_index(op.f("ix_systems_id"), "systems", ["id"], unique=True)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_systems_id"), table_name="systems")
    op.drop_index(op.f("ix_systems_fides_key"), table_name="systems")
    op.drop_table("systems")
    op.drop_index(op.f("ix_registries_id"), table_name="registries")
    op.drop_index(op.f("ix_registries_fides_key"), table_name="registries")
    op.drop_table("registries")
    op.drop_index(op.f("ix_policies_id"), table_name="policies")
    op.drop_index(op.f("ix_policies_fides_key"), table_name="policies")
    op.drop_table("policies")
    op.drop_index(op.f("ix_organizations_id"), table_name="organizations")
    op.drop_index(op.f("ix_organizations_fides_key"), table_name="organizations")
    op.drop_table("organizations")
    op.drop_index(op.f("ix_evaluations_id"), table_name="evaluations")
    op.drop_index(op.f("ix_evaluations_fides_key"), table_name="evaluations")
    op.drop_table("evaluations")
    op.drop_index(op.f("ix_datasets_id"), table_name="datasets")
    op.drop_index(op.f("ix_datasets_fides_key"), table_name="datasets")
    op.drop_table("datasets")
    op.drop_index(op.f("ix_data_uses_id"), table_name="data_uses")
    op.drop_index(op.f("ix_data_uses_fides_key"), table_name="data_uses")
    op.drop_table("data_uses")
    op.drop_index(op.f("ix_data_subjects_id"), table_name="data_subjects")
    op.drop_index(op.f("ix_data_subjects_fides_key"), table_name="data_subjects")
    op.drop_table("data_subjects")
    op.drop_index(op.f("ix_data_qualifiers_id"), table_name="data_qualifiers")
    op.drop_index(op.f("ix_data_qualifiers_fides_key"), table_name="data_qualifiers")
    op.drop_table("data_qualifiers")
    op.drop_index(op.f("ix_data_categories_id"), table_name="data_categories")
    op.drop_index(op.f("ix_data_categories_fides_key"), table_name="data_categories")
    op.drop_table("data_categories")
    # ### end Alembic commands ###
