from natsort import natsorted
import cv2
import os
import numpy as np

def lip_reading_image_processing(image):
    image = cv2.cvtColor(image,cv2.COLOR_BGR2GRAY)
    image = image/255
    #image = transform_image(image,20,3,20)

    return image

def lip_reading_data_solver(ID):
    images = []
    for data in natsorted(os.listdir(ID)):
        data_path = os.path.join(ID, data)
        if (data.endswith('.png')):
            image = cv2.imread(data_path)
            image = lip_reading_image_processing(image)
            images.append(image)

    big_window = []
    for i in range(len(images)-4):
        small_window = []
        for j in range(5):
            small_window.append((images[i+j]))
        big_window.append(small_window)

    return big_window

def lip_reading_shape():
    return (30,111,111)



def augment_brightness_camera_images(image):
    image1 = cv2.cvtColor(image, cv2.COLOR_RGB2HSV)
    random_bright = .25 + np.random.uniform()
    # print(random_bright)
    image1[:, :, 2] = image1[:, :, 2] * random_bright
    image1 = cv2.cvtColor(image1, cv2.COLOR_HSV2RGB)
    return image1


def transform_image(img, ang_range, shear_range, trans_range, brightness=0):

    # Rotation

    ang_rot = np.random.uniform(ang_range) - ang_range / 2

    rows, cols = img.shape
    Rot_M = cv2.getRotationMatrix2D((cols / 2, rows / 2), ang_rot, 1)

    # Translation
    tr_x = trans_range * np.random.uniform() - trans_range / 2
    tr_y = trans_range * np.random.uniform() - trans_range / 2
    Trans_M = np.float32([[1, 0, tr_x], [0, 1, tr_y]])

    # Shear
    pts1 = np.float32([[5, 5], [20, 5], [5, 20]])

    pt1 = 5 + shear_range * np.random.uniform() - shear_range / 2
    pt2 = 20 + shear_range * np.random.uniform() - shear_range / 2

    # Brightness

    pts2 = np.float32([[pt1, 5], [pt2, pt1], [5, pt2]])

    shear_M = cv2.getAffineTransform(pts1, pts2)

    img = cv2.warpAffine(img, Rot_M, (cols, rows))
    img = cv2.warpAffine(img, Trans_M, (cols, rows))
    img = cv2.warpAffine(img, shear_M, (cols, rows))

    if brightness == 1:
        img = augment_brightness_camera_images(img)

    return img