# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/02_validations.ipynb (unless otherwise specified).

__all__ = ['log_status', 'average_scores', 'KFoldPipe']

# Cell
from unittest.mock import Mock

import logging
from random import randint,random
from itertools import product

from .pipeline_classifier import Pipeline
import tensorflow as tf

# Cell
def log_status(k, evaluation, *args):
    '''Log current fold accuracy and F1 scores
    '''
    for key in ('accuracy', 'f1_score'):
        logging.info(
            'The %s score for the test set in fold %s is %s' %
            (key, k, evaluation['test'][key]) + 5 * ' '
        )
    if args:
        logging.info('\n'.join(args))
    logging.info(f'fold {k} has finished...')

# Cell
def average_scores(**scores):
    ''' For each dataset and score, calculates the average over folds \n
    '''
    sc_vals = next(iter(scores.values()))
    average = lambda sv: {
        sc: sum(scores[k][sv][sc] for k in scores) / len(scores)
        for sc in next(iter(sc_vals.values()))
    }
    return {sv: average(sv) for sv in sc_vals}

# Cell
class KFoldPipe(Pipeline):
    ''' Inherents [`Pipeline`](job_offer_classfier/pipeline_classifier)
    and incorporates the k fold validation
    '''
    def __init__(self, n_splits, **args):
        super().__init__(**args)
        self.n_splits = n_splits
        self.best_score = -1.0
        self.best_seed = None
        self.history = {}
        self.frac = 1 - (1 / n_splits)
        self.get_seeds()

    def get_seeds(self):
        ''' Array of random seeds
        '''
        self.seeds = {
            str(k + 1): randint(0, 2**32 - 1)
            for k in range(self.n_splits)
        }

    def update_best_score(self):
        '''Update the folds and seeds that correspond to
           the best score
        '''
        f1_score = self.evaluation['test']['f1_score']
        if self.best_score < f1_score:
            self.best_score = f1_score
            self.best_fold = self.current_fold
            self.best_seed = self.random_state

    def update_history(self, fold):
        ''' Update history records
        '''
        log_status(fold, self.evaluation)
        self.history[fold] = self.evaluation

    def average_evaluations(self):
        '''Average over evaluation results
        '''
        self.averages = average_scores(**self.history)

    def k_fold_validation(self):
        ''' Runs the pipeline over all the seeds.
        Stores the best seed, keeps evaluations history and averages over the scores. \n
        On each iteration: \n
           -splits the data over the seed of the current iteration \n
           -runs the pipeline \n
           -updates history and best scores \n

        '''

        for k, seed in self.seeds.items():
            self.random_state = seed
            self.current_fold = k
            self.split_dataset()
            self.pipeline()
            self.update_history(fold=k)
            self.update_best_score()
        self.average_evaluations()