# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/00_merge_datasets.ipynb (unless otherwise specified).

__all__ = ['load_datasets', 'merge_datasets']

# Cell
import pandas as pd

# Cell
def load_datasets(webpage_file, sibatel_file):

    webpages = pd.read_csv(webpage_file)
    webpages.columns = ['payload', 'type']

    sibatel = pd.read_csv(sibatel_file)[['payload']]
    sibatel['type'] = 'accept'
    sibatel.payload = sibatel.payload.apply(lambda x: x.lower())

    return webpages, sibatel

# Cell
def merge_datasets(webpages, sibatel, dst_file):
    merged_df = pd.concat([webpages, sibatel])
    merged_df['sentiment'] = merged_df.type.apply(
        lambda t: 'positive' if t == 'accept' else 'negative'
    )
    _ = merged_df.pop('type')
    merged_df.to_csv(dst_file, index=False)
    return merged_df