# coding: utf-8

"""
    Laserfiche API

    Welcome to the Laserfiche API Swagger Playground. You can try out any of our API calls against your live Laserfiche Cloud account. Visit the developer center for more details: <a href=\"https://developer.laserfiche.com\">https://developer.laserfiche.com</a><p><strong>Build# : </strong>561590</p>  # noqa: E501

    OpenAPI spec version: 1-alpha
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six
from laserfiche_api.models.entry import Entry  # noqa: F401,E501

class Document(Entry):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'elec_document_size': 'int',
        'extension': 'str',
        'is_electronic_document': 'bool',
        'is_record': 'bool',
        'mime_type': 'str',
        'page_count': 'int',
        'is_checked_out': 'bool',
        'is_under_version_control': 'bool',
        'edoc': 'Object'
    }
    if hasattr(Entry, "swagger_types"):
        swagger_types.update(Entry.swagger_types)

    attribute_map = {
        'elec_document_size': 'elecDocumentSize',
        'extension': 'extension',
        'is_electronic_document': 'isElectronicDocument',
        'is_record': 'isRecord',
        'mime_type': 'mimeType',
        'page_count': 'pageCount',
        'is_checked_out': 'isCheckedOut',
        'is_under_version_control': 'isUnderVersionControl',
        'edoc': 'edoc'
    }
    if hasattr(Entry, "attribute_map"):
        attribute_map.update(Entry.attribute_map)

    def __init__(self, elec_document_size=None, extension=None, is_electronic_document=None, is_record=None, mime_type=None, page_count=None, is_checked_out=None, is_under_version_control=None, edoc=None, *args, **kwargs):  # noqa: E501
        """Document - a model defined in Swagger"""  # noqa: E501
        self._elec_document_size = None
        self._extension = None
        self._is_electronic_document = None
        self._is_record = None
        self._mime_type = None
        self._page_count = None
        self._is_checked_out = None
        self._is_under_version_control = None
        self._edoc = None
        self.discriminator = None
        if elec_document_size is not None:
            self.elec_document_size = elec_document_size
        if extension is not None:
            self.extension = extension
        if is_electronic_document is not None:
            self.is_electronic_document = is_electronic_document
        if is_record is not None:
            self.is_record = is_record
        if mime_type is not None:
            self.mime_type = mime_type
        if page_count is not None:
            self.page_count = page_count
        if is_checked_out is not None:
            self.is_checked_out = is_checked_out
        if is_under_version_control is not None:
            self.is_under_version_control = is_under_version_control
        if edoc is not None:
            self.edoc = edoc
        Entry.__init__(self, *args, **kwargs)

    @property
    def elec_document_size(self):
        """Gets the elec_document_size of this Document.  # noqa: E501

        The size of the electronic document attached to the represented document, if there is one, in bytes.  # noqa: E501

        :return: The elec_document_size of this Document.  # noqa: E501
        :rtype: int
        """
        return self._elec_document_size

    @elec_document_size.setter
    def elec_document_size(self, elec_document_size):
        """Sets the elec_document_size of this Document.

        The size of the electronic document attached to the represented document, if there is one, in bytes.  # noqa: E501

        :param elec_document_size: The elec_document_size of this Document.  # noqa: E501
        :type: int
        """

        self._elec_document_size = elec_document_size

    @property
    def extension(self):
        """Gets the extension of this Document.  # noqa: E501

        The extension for the document.  # noqa: E501

        :return: The extension of this Document.  # noqa: E501
        :rtype: str
        """
        return self._extension

    @extension.setter
    def extension(self, extension):
        """Sets the extension of this Document.

        The extension for the document.  # noqa: E501

        :param extension: The extension of this Document.  # noqa: E501
        :type: str
        """

        self._extension = extension

    @property
    def is_electronic_document(self):
        """Gets the is_electronic_document of this Document.  # noqa: E501

        A boolean indicating if there is an electronic document attached to the represented document.  # noqa: E501

        :return: The is_electronic_document of this Document.  # noqa: E501
        :rtype: bool
        """
        return self._is_electronic_document

    @is_electronic_document.setter
    def is_electronic_document(self, is_electronic_document):
        """Sets the is_electronic_document of this Document.

        A boolean indicating if there is an electronic document attached to the represented document.  # noqa: E501

        :param is_electronic_document: The is_electronic_document of this Document.  # noqa: E501
        :type: bool
        """

        self._is_electronic_document = is_electronic_document

    @property
    def is_record(self):
        """Gets the is_record of this Document.  # noqa: E501

        A boolean indicating if the represented document is a record.  # noqa: E501

        :return: The is_record of this Document.  # noqa: E501
        :rtype: bool
        """
        return self._is_record

    @is_record.setter
    def is_record(self, is_record):
        """Sets the is_record of this Document.

        A boolean indicating if the represented document is a record.  # noqa: E501

        :param is_record: The is_record of this Document.  # noqa: E501
        :type: bool
        """

        self._is_record = is_record

    @property
    def mime_type(self):
        """Gets the mime_type of this Document.  # noqa: E501

        The MIME type of the electronic document.  # noqa: E501

        :return: The mime_type of this Document.  # noqa: E501
        :rtype: str
        """
        return self._mime_type

    @mime_type.setter
    def mime_type(self, mime_type):
        """Sets the mime_type of this Document.

        The MIME type of the electronic document.  # noqa: E501

        :param mime_type: The mime_type of this Document.  # noqa: E501
        :type: str
        """

        self._mime_type = mime_type

    @property
    def page_count(self):
        """Gets the page_count of this Document.  # noqa: E501

        The page count of the represented document.  # noqa: E501

        :return: The page_count of this Document.  # noqa: E501
        :rtype: int
        """
        return self._page_count

    @page_count.setter
    def page_count(self, page_count):
        """Sets the page_count of this Document.

        The page count of the represented document.  # noqa: E501

        :param page_count: The page_count of this Document.  # noqa: E501
        :type: int
        """

        self._page_count = page_count

    @property
    def is_checked_out(self):
        """Gets the is_checked_out of this Document.  # noqa: E501

        A boolean indicating if the represented document is checked out.  # noqa: E501

        :return: The is_checked_out of this Document.  # noqa: E501
        :rtype: bool
        """
        return self._is_checked_out

    @is_checked_out.setter
    def is_checked_out(self, is_checked_out):
        """Sets the is_checked_out of this Document.

        A boolean indicating if the represented document is checked out.  # noqa: E501

        :param is_checked_out: The is_checked_out of this Document.  # noqa: E501
        :type: bool
        """

        self._is_checked_out = is_checked_out

    @property
    def is_under_version_control(self):
        """Gets the is_under_version_control of this Document.  # noqa: E501

        A boolean indicating if the represented document is under version control.  # noqa: E501

        :return: The is_under_version_control of this Document.  # noqa: E501
        :rtype: bool
        """
        return self._is_under_version_control

    @is_under_version_control.setter
    def is_under_version_control(self, is_under_version_control):
        """Sets the is_under_version_control of this Document.

        A boolean indicating if the represented document is under version control.  # noqa: E501

        :param is_under_version_control: The is_under_version_control of this Document.  # noqa: E501
        :type: bool
        """

        self._is_under_version_control = is_under_version_control

    @property
    def edoc(self):
        """Gets the edoc of this Document.  # noqa: E501

        The electronic document attached to the represented document.  # noqa: E501

        :return: The edoc of this Document.  # noqa: E501
        :rtype: Object
        """
        return self._edoc

    @edoc.setter
    def edoc(self, edoc):
        """Sets the edoc of this Document.

        The electronic document attached to the represented document.  # noqa: E501

        :param edoc: The edoc of this Document.  # noqa: E501
        :type: Object
        """

        self._edoc = edoc

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Document, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Document):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
