# image_intensities
Python implementation of the great [derpibooru/image_intensities](https://github.com/derpibooru/image_intensities/tree/8aa43674f61f77cfc756c23556b6ae45e1b210b1).

> The algorithmic overview is to convert the image into the yuv colorspace, drop the u and v components, 
> and then average the y component over 4 evenly-spaced rectangles on the image dimensions.

# Usage

```python
from image_intensities import png_intensities, jpeg_intensities
luma = png_intensities('/absolute/path/to/954482.png')  # image can ge found in the tests folder.
luma = jpeg_intensities('/absolute/path/to/2544057.jpg')  # image can ge found in the tests folder.

# returns something like
luma == Luma(nw=0.42, ne=0.44, sw=0.58, se=0.69) 
```

```python
from image_intensities import rgb_luma_from_filename, Luma

luma = rgb_luma_from_filename('/path/to/image.png')

# returns something like
luma == Luma(nw=0.42, ne=0.44, sw=0.58, se=0.69)
```


# Dependencies
### C-Extension
#### libpng
- MacOS: `brew install libpng` (tested to work with 1.6.37)
- Ubuntu: `sudo apt-get update && sudo apt-get install libpng-dev`
- Dockerfile, Ubuntu based: `apt-get update -y && apt-get install -y libpng-dev && apt-get clean && rm -rfv /var/lib/apt/lists/*`
    - > ⚠️ Make sure you pull a recent release of the python docker image (even if it's an older python version!).
      > Especially if you're getting errors complaining about a `png_set_longjmp_fn` function when you try to use it.
      > As time of writing the 2-month old version did not work, but the newest releases (`python:3.6`: `6ac87e65b6d0`, `pythong:3.9`: `1b33974176a3`) ones have that fixed.  

# Installation
See dependencies above, and make sure those are installed.
### Install via pip
```bash
pip install image_intensities
```

##### Mac OS:
```bash
CPPFLAGS='-I/usr/local/include/' LDFLAGS='-L/usr/local/lib/' pip install image_intensities
```

### From source
E.g. you checked out this repository:
```bash
python setup.py install
```

##### Mac OS:
```bash
CPPFLAGS='-I/usr/local/include/' LDFLAGS='-L/usr/local/lib/' python setup.py install
```


### Minimal installation example

Using docker as it already has a working `libpng-dev`:

```sh
docker pull python:3.9
docker run -it --rm python:3.9 bash
pip install image_intensities

# test import
python -c"import image_intensities as it; print(it._intensities.ffi)"

# test with a png
wget https://derpicdn.net/img/download/2015/8/9/954482.png -O /tmp/954482.png
python -c"from image_intensities import png_intensities; print(png_intensities('/tmp/954482.png'))"

# test with a jpg
wget https://derpicdn.net/img/download/2021/2/4/2544057.jpg -O /tmp/2544057.jpg  # we need to use an absolute path!
python -c"from image_intensities import jpeg_intensities; print(jpeg_intensities('/tmp/2544057.jpg'))"
```
