# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/18_bbox_trajectory.ipynb (unless otherwise specified).

__all__ = []

# Internal Cell
from ipycanvas import Canvas
from typing import List
from ..mltypes import BboxCoordinate

# Internal Cell

class BBoxTrajectory:
    @staticmethod
    def draw_trajectory(canvas: Canvas, coords: List[BboxCoordinate], scale: float = 1.0):
        # iterate the coords two by two
        i, k = None, None
        c = iter(coords)
        lines = []
        while True:
            if i is None:
                i = next(c, None)
            k = next(c, None)
            if k and i:
                lines.append([(i.x * scale, (i.y + i.height) * scale),
                              (k.x * scale, (k.y + k.height) * scale)])
            else:
                break
            i = k

        canvas.stroke_styled_line_segments(lines, color=[50, 205, 50])