# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/00b_mltypes.ipynb (unless otherwise specified).

__all__ = ['Coordinate', 'BboxCoordinate', 'BboxVideoCoordinate', 'Input', 'Output', 'InputImage', 'OutputImageLabel',
           'OutputImageBbox', 'OutputVideoBbox', 'OutputGridBox', 'NoOutput']

# Internal Cell
import random
import uuid
import attr
from typing import List

# Cell
@attr.define(slots=False)
class Coordinate:
    x: int
    y: int


@attr.define(slots=False)
class BboxCoordinate(Coordinate):
    width: int
    height: int


@attr.define(slots=False)
class BboxVideoCoordinate(BboxCoordinate):
    id: str

    def bbox_coord(self) -> BboxCoordinate:
        return BboxCoordinate(*list(attr.asdict(self).values())[:4])

# Cell

# todo: use pydantic
class Input():
    """
    Abstract class to represent input
    """

    def __repr__(self):
        return f"Annotator Input type: {self.__class__.__name__}"


class Output():
    """
    Abstract class to represent input
    """

    def __repr__(self):
        return f"Annotator Output type: {self.__class__.__name__}"

# Cell
class InputImage(Input):
    """
    image_dir: string
        Directory of the image

    image_width: int
        Width of the image

    image_height: int
        Height of the image
    """

    def __init__(self, image_dir='pics', image_width=100, image_height=100):
        self.width = image_width
        self.height = image_height
        self.dir = image_dir

# Cell
class OutputImageLabel(Output):
    """
     Will handle the image output.
     If no `label_dir` is specified, it should generate randomized one.

    """

    def __init__(self, label_dir=None, label_width=50, label_height=50):
        self.width = label_width
        self.height = label_height

        if label_dir is None:
            self.dir = 'class_autogenerated_' + ''.join(random.sample(str(uuid.uuid4()), 5))
        else:
            self.dir = label_dir

# Cell
class OutputImageBbox(Output):
    def __init__(self, classes: List[str] = None):
        self.classes = classes or []

# Cell
class OutputVideoBbox(OutputImageBbox):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.drawing_enabled = True
        self.drawing_trajectory_enabled = True

# Cell
class OutputGridBox(Output):
    pass

# Cell
class NoOutput(Output):
    pass