"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaFunctionAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
/**
 * (experimental) The action to invoke an AWS Lambda function, passing in an MQTT message.
 *
 * @experimental
 */
class LambdaFunctionAction {
    /**
     * @param func The lambda function to be invoked by this action.
     * @experimental
     */
    constructor(func) {
        this.func = func;
    }
    /**
     * (experimental) (experimental) Returns the topic rule action specification.
     *
     * @experimental
     */
    bind(topicRule) {
        this.func.addPermission(`${core_1.Names.nodeUniqueId(topicRule.node)}:IotLambdaFunctionAction`, {
            action: 'lambda:InvokeFunction',
            principal: new iam.ServicePrincipal('iot.amazonaws.com'),
            sourceAccount: topicRule.env.account,
            sourceArn: topicRule.topicRuleArn,
        });
        return {
            configuration: {
                lambda: {
                    functionArn: this.func.functionArn,
                },
            },
        };
    }
}
exports.LambdaFunctionAction = LambdaFunctionAction;
_a = JSII_RTTI_SYMBOL_1;
LambdaFunctionAction[_a] = { fqn: "@aws-cdk/aws-iot-actions.LambdaFunctionAction", version: "1.142.0" };
//# sourceMappingURL=data:application/json;base64,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