"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManualApprovalAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const iam = require("@aws-cdk/aws-iam");
const sns = require("@aws-cdk/aws-sns");
const subs = require("@aws-cdk/aws-sns-subscriptions");
const action_1 = require("./action");
/**
 * Manual approval action.
 */
class ManualApprovalAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            category: codepipeline.ActionCategory.APPROVAL,
            provider: 'Manual',
            artifactBounds: { minInputs: 0, maxInputs: 0, minOutputs: 0, maxOutputs: 0 },
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codepipeline_actions_ManualApprovalActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.props = props;
    }
    get notificationTopic() {
        return this._notificationTopic;
    }
    /**
     * grant the provided principal the permissions to approve or reject this manual approval action
     *
     * For more info see:
     * https://docs.aws.amazon.com/codepipeline/latest/userguide/approvals-iam-permissions.html
     *
     * @param grantable the grantable to attach the permissions to
     */
    grantManualApproval(grantable) {
        if (!this.stage) {
            throw new Error('Cannot grant permissions before binding action to a stage');
        }
        grantable.grantPrincipal.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['codepipeline:ListPipelines'],
            resources: ['*'],
        }));
        grantable.grantPrincipal.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['codepipeline:GetPipeline', 'codepipeline:GetPipelineState', 'codepipeline:GetPipelineExecution'],
            resources: [this.stage.pipeline.pipelineArn],
        }));
        grantable.grantPrincipal.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['codepipeline:PutApprovalResult'],
            resources: [`${this.stage.pipeline.pipelineArn}/${this.stage.stageName}/${this.props.actionName}`],
        }));
    }
    bound(scope, stage, options) {
        var _b;
        if (this.props.notificationTopic) {
            this._notificationTopic = this.props.notificationTopic;
        }
        else if ((this.props.notifyEmails || []).length > 0) {
            this._notificationTopic = new sns.Topic(scope, 'TopicResource');
        }
        if (this._notificationTopic) {
            this._notificationTopic.grantPublish(options.role);
            for (const notifyEmail of this.props.notifyEmails || []) {
                this._notificationTopic.addSubscription(new subs.EmailSubscription(notifyEmail));
            }
        }
        this.stage = stage;
        return {
            configuration: undefinedIfAllValuesAreEmpty({
                NotificationArn: (_b = this._notificationTopic) === null || _b === void 0 ? void 0 : _b.topicArn,
                CustomData: this.props.additionalInformation,
                ExternalEntityLink: this.props.externalEntityLink,
            }),
        };
    }
}
exports.ManualApprovalAction = ManualApprovalAction;
_a = JSII_RTTI_SYMBOL_1;
ManualApprovalAction[_a] = { fqn: "@aws-cdk/aws-codepipeline-actions.ManualApprovalAction", version: "1.157.0" };
function undefinedIfAllValuesAreEmpty(object) {
    return Object.values(object).some(v => v !== undefined) ? object : undefined;
}
//# sourceMappingURL=data:application/json;base64,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