/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.frame;

import ai.h2o.mojos.runtime.api.MojoColumnMeta;
import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoColumnFactory;
import ai.h2o.mojos.runtime.frame.MojoColumnFactoryService;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.frame.MojoRow;
import ai.h2o.mojos.runtime.frame.MojoRowBuilder;
import ai.h2o.mojos.runtime.frame.StringConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MojoFrameBuilder {
    public static final StringConverter DEFAULT_CONVERTER = new StringConverter(){

        @Override
        public Object convert(String s2, MojoColumn.Type outputType) {
            return outputType.parse(s2);
        }
    };
    private final MojoFrameMeta _meta;
    private final Set<String> _missingValues;
    private final MojoColumnBuilder[] _columnBuilders;
    private final StringConverter[] _stringConverters;

    public MojoFrameBuilder(MojoFrameMeta frameMeta) {
        this(frameMeta, Collections.emptyList(), Collections.emptyMap());
    }

    public MojoFrameBuilder(MojoFrameMeta frameMeta, Set<String> missingValues) {
        this(frameMeta, missingValues, Collections.emptyMap());
    }

    public MojoFrameBuilder(MojoFrameMeta frameMeta, Collection<String> missingValues, Map<String, StringConverter> stringConverters) {
        this._meta = frameMeta;
        this._missingValues = missingValues != null ? new HashSet<String>(missingValues) : new HashSet<String>(0);
        this._columnBuilders = new MojoColumnBuilder[frameMeta.size()];
        this._stringConverters = new StringConverter[frameMeta.size()];
        int i2 = 0;
        for (MojoColumnMeta column : frameMeta.getColumns()) {
            this._columnBuilders[i2] = new MojoColumnBuilder(column.getColumnType());
            String name = column.getColumnName();
            this._stringConverters[i2] = stringConverters.containsKey(name) ? stringConverters.get(name) : DEFAULT_CONVERTER;
            ++i2;
        }
    }

    public static MojoFrame getEmpty(MojoFrameMeta meta, int nrows) {
        MojoColumnFactory mojoColumnFactory = MojoColumnFactoryService.getInstance().getMojoColumnFactory();
        MojoColumn[] columnsWithData = new MojoColumn[meta.size()];
        for (int i2 = 0; i2 < meta.size(); ++i2) {
            MojoColumn.Type colType = meta.getColumnType(i2);
            columnsWithData[i2] = mojoColumnFactory.create(colType, nrows);
        }
        return new MojoFrame(meta, columnsWithData, nrows);
    }

    public static MojoFrame fromColumns(MojoFrameMeta meta, MojoColumn[] columns) {
        int nrows;
        if (columns.length != meta.size()) {
            throw new IllegalArgumentException(String.format("Number of columns(%d) does not match size of frame meta (%d)", columns.length, meta.size()));
        }
        int n2 = nrows = columns.length == 0 ? 0 : columns[0].size();
        if (columns.length > 0) {
            String firstColumnName = meta.getColumnName(0);
            int i2 = 0;
            for (MojoColumnMeta column : meta.getColumns()) {
                MojoColumn c2 = columns[i2];
                if (c2.size() != nrows) {
                    throw new IllegalArgumentException(String.format("Number of rows in columns %d ('%s') and 0 ('%s') do not match (%d != %d)", i2, column.getColumnName(), firstColumnName, c2.size(), nrows));
                }
                if (c2.getType() != column.getColumnType()) {
                    throw new IllegalArgumentException(String.format("Type of column %d ('%s') does not match frame meta: %s != %s", new Object[]{i2, column.getColumnName(), c2.getType(), column.getColumnType()}));
                }
                ++i2;
            }
        }
        return new MojoFrame(meta, columns, nrows);
    }

    public MojoRowBuilder addRow(MojoRowBuilder rowBuilder) {
        this.addRow(rowBuilder.toMojoRow());
        rowBuilder.clear();
        return rowBuilder;
    }

    void addRow(MojoRow row) {
        Object[] values = row.getValues();
        if (values.length != this._columnBuilders.length) {
            throw new IllegalArgumentException("Row argument does not have the same column count as frame");
        }
        for (int i2 = 0; i2 < this._columnBuilders.length; ++i2) {
            this._columnBuilders[i2].pushValue(values[i2]);
        }
    }

    public MojoRowBuilder getMojoRowBuilder() {
        return this.getMojoRowBuilder(false);
    }

    public MojoRowBuilder getMojoRowBuilder(boolean strictMode) {
        return new MojoRowBuilder(this._meta.getColumnNamesMap(), this._meta.getColumnTypes(), this._missingValues, this._stringConverters, strictMode);
    }

    public MojoFrame toMojoFrame() {
        int nrows = this._columnBuilders.length == 0 ? 0 : this._columnBuilders[0].size();
        return this.toMojoFrame(nrows);
    }

    public MojoFrame toMojoFrame(int nrows) {
        MojoColumn[] columns = new MojoColumn[this._columnBuilders.length];
        for (int i2 = 0; i2 < columns.length; ++i2) {
            columns[i2] = this._columnBuilders[i2].toMojoColumn();
            columns[i2].resize(nrows);
        }
        return new MojoFrame(this._meta, columns, nrows);
    }

    private static class MojoColumnBuilder {
        private final MojoColumn.Type colType;
        private final List<Object> values = new ArrayList<Object>();

        MojoColumnBuilder(MojoColumn.Type type) {
            this.colType = type;
        }

        void pushValue(Object value) {
            this.values.add(value == null ? this.colType.NULL : value);
        }

        MojoColumn toMojoColumn() {
            MojoColumn col = MojoColumnFactoryService.getInstance().getMojoColumnFactory().create(this.colType, this.values.size());
            col.fillFromParsedListData(this.values);
            return col;
        }

        int size() {
            return this.values.size();
        }
    }
}

