
# https://en.wikipedia.org/wiki/Ligature_(writing)
KNOWN_LIGATURES = {
    # Latin
    "ﬀ": "ff",
    "ﬁ": "fi",
    "ﬂ": "fl",
    "ﬃ": "ffi",
    "ﬄ": "ffl",
    "ﬅ": "ft",
    "ﬆ": "st",
    "Ǳ": "DZ",
    "ǲ": "Dz",
    "ǳ": "dz",
    "Ǆ": "DŽ",
    "ǅ": "Dž",
    "ǆ": "dž",
    "Ꜩ": "Tz",
    "ꜩ": "tz",
    "🙰": "et",
    "℔": "lb",
    "ᵫ": "ue",
    "Ĳ": "IJ",
    "ĳ": "ij",  # They are both capitalized together, so the "Ij" ligature doesn't exist
    "ꝏ": "oo",  # Not the infinite sign but a double-o ligature: https://en.wikipedia.org/wiki/Ligature_(writing)#Massachusett_%EA%9D%8F
    # Armenian
    "ﬓ": "մն",
    "ﬔ": "մե",
    "ﬕ": "մի",
    "ﬖ": "վն",
    "ﬗ": "մխ",
}
