"use strict";
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.DAXMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class DAXMetrics {
    static cpuUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'CPUUtilization',
            dimensions,
            statistic: 'Average',
        };
    }
    static itemCacheHitsSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'ItemCacheHits',
            dimensions,
            statistic: 'Sum',
        };
    }
    static itemCacheMissesSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'ItemCacheMisses',
            dimensions,
            statistic: 'Sum',
        };
    }
    static batchGetItemRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'BatchGetItemRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static batchWriteItemRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'BatchWriteItemRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static cacheMemoryUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'CacheMemoryUtilization',
            dimensions,
            statistic: 'Average',
        };
    }
    static clientConnectionsSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'ClientConnections',
            dimensions,
            statistic: 'Sum',
        };
    }
    static deleteItemRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'DeleteItemRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static errorRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'ErrorRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static estimatedDbSizeAverage(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'EstimatedDbSize',
            dimensions,
            statistic: 'Average',
        };
    }
    static evictedSizeSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'EvictedSize',
            dimensions,
            statistic: 'Sum',
        };
    }
    static failedRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'FailedRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static faultRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'FaultRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static getItemRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'GetItemRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static networkBytesInSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'NetworkBytesIn',
            dimensions,
            statistic: 'Sum',
        };
    }
    static networkBytesOutSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'NetworkBytesOut',
            dimensions,
            statistic: 'Sum',
        };
    }
    static networkPacketsInSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'NetworkPacketsIn',
            dimensions,
            statistic: 'Sum',
        };
    }
    static networkPacketsOutSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'NetworkPacketsOut',
            dimensions,
            statistic: 'Sum',
        };
    }
    static putItemRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'PutItemRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static queryCacheHitsSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'QueryCacheHits',
            dimensions,
            statistic: 'Sum',
        };
    }
    static queryCacheMissesSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'QueryCacheMisses',
            dimensions,
            statistic: 'Sum',
        };
    }
    static queryRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'QueryRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static scanCacheHitsSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'ScanCacheHits',
            dimensions,
            statistic: 'Sum',
        };
    }
    static scanCacheMissesSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'ScanCacheMisses',
            dimensions,
            statistic: 'Sum',
        };
    }
    static scanRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'ScanRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static throttledRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'ThrottledRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static totalRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'TotalRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static transactGetItemsCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'TransactGetItemsCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static transactWriteItemsCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'TransactWriteItemsCount',
            dimensions,
            statistic: 'Sum',
        };
    }
    static updateItemRequestCountSum(dimensions) {
        return {
            namespace: 'AWS/DAX',
            metricName: 'UpdateItemRequestCount',
            dimensions,
            statistic: 'Sum',
        };
    }
}
exports.DAXMetrics = DAXMetrics;
//# sourceMappingURL=data:application/json;base64,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