"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const aws_kinesisstreams_lambda_1 = require("@aws-solutions-constructs/aws-kinesisstreams-lambda");
const lambda = require("aws-cdk-lib/aws-lambda");
const core_1 = require("@aws-solutions-constructs/core");
const defaults = require("@aws-solutions-constructs/core");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, core_1.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-kinesisstreams-kinesisfirehose-s3';
const construct = new aws_kinesisstreams_lambda_1.KinesisStreamsToLambda(stack, 'test-kinesis-lambda', {
    lambdaFunctionProps: {
        runtime: lambda.Runtime.NODEJS_14_X,
        handler: 'index.handler',
        code: lambda.Code.fromAsset(`${__dirname}/lambda`)
    },
});
const streamFirehoseS3 = new lib_1.KinesisStreamsToKinesisFirehoseToS3(stack, 'test-existing-stream-firehose-s3-stack', {
    existingStreamObj: construct.kinesisStream,
    createCloudWatchAlarms: false,
    bucketProps: {
        removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
    },
    logGroupProps: {
        removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY
    },
    logS3AccessLogs: false
});
const s3Bucket = streamFirehoseS3.s3Bucket;
defaults.addCfnSuppressRules(s3Bucket, [
    { id: 'W35',
        reason: 'This S3 bucket is created for unit/ integration testing purposes only.' },
]);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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