import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Construct } from 'constructs';
/**
 * (experimental) Properties for EmrSetClusterTerminationProtection.
 *
 * @experimental
 */
export interface EmrSetClusterTerminationProtectionProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) The ClusterId to update.
     *
     * @experimental
     */
    readonly clusterId: string;
    /**
     * (experimental) Termination protection indicator.
     *
     * @experimental
     */
    readonly terminationProtected: boolean;
}
/**
 * (experimental) A Step Functions Task to to set Termination Protection on an EMR Cluster.
 *
 * @experimental
 */
export declare class EmrSetClusterTerminationProtection extends sfn.TaskStateBase {
    private readonly props;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: EmrSetClusterTerminationProtectionProps);
    /**
     * @internal
     */
    protected _renderTask(): any;
}
