import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Construct } from 'constructs';
/**
 * (experimental) Properties for stoping a Query Execution.
 *
 * @experimental
 */
export interface AthenaStopQueryExecutionProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) Query that will be stopped.
     *
     * @experimental
     */
    readonly queryExecutionId: string;
}
/**
 * (experimental) Stop an Athena Query Execution as a Task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-athena.html
 * @experimental
 */
export declare class AthenaStopQueryExecution extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: AthenaStopQueryExecutionProps);
    /**
     * Provides the Athena stop query execution service integration task configuration
     */
    /**
     * @internal
     */
    protected _renderTask(): any;
}
