"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EncryptionOption = exports.AthenaStartQueryExecution = void 0;
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const task_utils_1 = require("../private/task-utils");
/**
 * (experimental) Start an Athena Query as a Task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-athena.html
 * @experimental
 */
class AthenaStartQueryExecution extends sfn.TaskStateBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a;
        super(scope, id, props);
        this.props = props;
        this.integrationPattern = (_a = props.integrationPattern) !== null && _a !== void 0 ? _a : sfn.IntegrationPattern.REQUEST_RESPONSE;
        task_utils_1.validatePatternSupported(this.integrationPattern, AthenaStartQueryExecution.SUPPORTED_INTEGRATION_PATTERNS);
        this.taskPolicies = this.createPolicyStatements();
    }
    createPolicyStatements() {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q;
        const policyStatements = [
            new iam.PolicyStatement({
                resources: [
                    cdk.Stack.of(this).formatArn({
                        service: 'athena',
                        resource: 'datacatalog',
                        resourceName: (_b = (_a = this.props.queryExecutionContext) === null || _a === void 0 ? void 0 : _a.catalogName) !== null && _b !== void 0 ? _b : 'AwsDataCatalog',
                    }),
                    cdk.Stack.of(this).formatArn({
                        service: 'athena',
                        resource: 'workgroup',
                        resourceName: (_c = this.props.workGroup) !== null && _c !== void 0 ? _c : 'primary',
                    }),
                ],
                actions: ['athena:getDataCatalog', 'athena:startQueryExecution', 'athena:getQueryExecution'],
            }),
        ];
        policyStatements.push(new iam.PolicyStatement({
            actions: ['s3:CreateBucket',
                's3:ListBucket',
                's3:GetBucketLocation',
                's3:GetObject'],
            resources: ['*'],
        }));
        policyStatements.push(new iam.PolicyStatement({
            actions: ['s3:AbortMultipartUpload',
                's3:ListBucketMultipartUploads',
                's3:ListMultipartUploadParts',
                's3:PutObject'],
            resources: [((_e = (_d = this.props.resultConfiguration) === null || _d === void 0 ? void 0 : _d.outputLocation) === null || _e === void 0 ? void 0 : _e.bucketName) ? `arn:aws:s3:::${(_g = (_f = this.props.resultConfiguration) === null || _f === void 0 ? void 0 : _f.outputLocation) === null || _g === void 0 ? void 0 : _g.bucketName}/${(_j = (_h = this.props.resultConfiguration) === null || _h === void 0 ? void 0 : _h.outputLocation) === null || _j === void 0 ? void 0 : _j.objectKey}/*` : '*'],
        }));
        policyStatements.push(new iam.PolicyStatement({
            actions: ['lakeformation:GetDataAccess'],
            resources: ['*'],
        }));
        policyStatements.push(new iam.PolicyStatement({
            actions: ['glue:BatchCreatePartition',
                'glue:BatchDeletePartition',
                'glue:BatchDeleteTable',
                'glue:BatchGetPartition',
                'glue:CreateDatabase',
                'glue:CreatePartition',
                'glue:CreateTable',
                'glue:DeleteDatabase',
                'glue:DeletePartition',
                'glue:DeleteTable',
                'glue:GetDatabase',
                'glue:GetDatabases',
                'glue:GetPartition',
                'glue:GetPartitions',
                'glue:GetTable',
                'glue:GetTables',
                'glue:UpdateDatabase',
                'glue:UpdatePartition',
                'glue:UpdateTable'],
            resources: [
                cdk.Stack.of(this).formatArn({
                    service: 'glue',
                    resource: 'catalog',
                }),
                cdk.Stack.of(this).formatArn({
                    service: 'glue',
                    resource: 'database',
                    resourceName: (_l = (_k = this.props.queryExecutionContext) === null || _k === void 0 ? void 0 : _k.databaseName) !== null && _l !== void 0 ? _l : 'default',
                }),
                cdk.Stack.of(this).formatArn({
                    service: 'glue',
                    resource: 'table',
                    resourceName: ((_o = (_m = this.props.queryExecutionContext) === null || _m === void 0 ? void 0 : _m.databaseName) !== null && _o !== void 0 ? _o : 'default') + '/*',
                }),
                cdk.Stack.of(this).formatArn({
                    service: 'glue',
                    resource: 'userdefinedfunction',
                    resourceName: ((_q = (_p = this.props.queryExecutionContext) === null || _p === void 0 ? void 0 : _p.databaseName) !== null && _q !== void 0 ? _q : 'default') + '/*',
                }),
            ],
        }));
        return policyStatements;
    }
    /**
     * Provides the Athena start query execution service integration task configuration
     */
    /**
     * @internal
     */
    _renderTask() {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s;
        if ((_a = this.props.resultConfiguration) === null || _a === void 0 ? void 0 : _a.outputLocation) {
            return {
                Resource: task_utils_1.integrationResourceArn('athena', 'startQueryExecution', this.integrationPattern),
                Parameters: sfn.FieldUtils.renderObject({
                    QueryString: this.props.queryString,
                    ClientRequestToken: this.props.clientRequestToken,
                    QueryExecutionContext: {
                        Catalog: (_b = this.props.queryExecutionContext) === null || _b === void 0 ? void 0 : _b.catalogName,
                        Database: (_c = this.props.queryExecutionContext) === null || _c === void 0 ? void 0 : _c.databaseName,
                    },
                    ResultConfiguration: {
                        EncryptionConfiguration: {
                            EncryptionOption: (_e = (_d = this.props.resultConfiguration) === null || _d === void 0 ? void 0 : _d.encryptionConfiguration) === null || _e === void 0 ? void 0 : _e.encryptionOption,
                            KmsKey: (_g = (_f = this.props.resultConfiguration) === null || _f === void 0 ? void 0 : _f.encryptionConfiguration) === null || _g === void 0 ? void 0 : _g.encryptionKey,
                        },
                        OutputLocation: `s3://${(_j = (_h = this.props.resultConfiguration) === null || _h === void 0 ? void 0 : _h.outputLocation) === null || _j === void 0 ? void 0 : _j.bucketName}/${(_l = (_k = this.props.resultConfiguration) === null || _k === void 0 ? void 0 : _k.outputLocation) === null || _l === void 0 ? void 0 : _l.objectKey}/`,
                    },
                    WorkGroup: this.props.workGroup,
                }),
            };
        }
        else {
            return {
                Resource: task_utils_1.integrationResourceArn('athena', 'startQueryExecution', this.integrationPattern),
                Parameters: sfn.FieldUtils.renderObject({
                    QueryString: this.props.queryString,
                    ClientRequestToken: this.props.clientRequestToken,
                    QueryExecutionContext: {
                        Catalog: (_m = this.props.queryExecutionContext) === null || _m === void 0 ? void 0 : _m.catalogName,
                        Database: (_o = this.props.queryExecutionContext) === null || _o === void 0 ? void 0 : _o.databaseName,
                    },
                    ResultConfiguration: {
                        EncryptionConfiguration: {
                            EncryptionOption: (_q = (_p = this.props.resultConfiguration) === null || _p === void 0 ? void 0 : _p.encryptionConfiguration) === null || _q === void 0 ? void 0 : _q.encryptionOption,
                            KmsKey: (_s = (_r = this.props.resultConfiguration) === null || _r === void 0 ? void 0 : _r.encryptionConfiguration) === null || _s === void 0 ? void 0 : _s.encryptionKey,
                        },
                    },
                    WorkGroup: this.props.workGroup,
                }),
            };
        }
    }
}
exports.AthenaStartQueryExecution = AthenaStartQueryExecution;
AthenaStartQueryExecution.SUPPORTED_INTEGRATION_PATTERNS = [
    sfn.IntegrationPattern.REQUEST_RESPONSE,
    sfn.IntegrationPattern.RUN_JOB,
];
/**
 * (experimental) Encryption Options of the S3 bucket.
 *
 * @see https://docs.aws.amazon.com/athena/latest/APIReference/API_EncryptionConfiguration.html#athena-Type-EncryptionConfiguration-EncryptionOption
 * @experimental
 */
var EncryptionOption;
(function (EncryptionOption) {
    EncryptionOption["S3_MANAGED"] = "SSE_S3";
    EncryptionOption["KMS"] = "SSE_KMS";
    EncryptionOption["CLIENT_SIDE_KMS"] = "CSE_KMS";
})(EncryptionOption = exports.EncryptionOption || (exports.EncryptionOption = {}));
//# sourceMappingURL=data:application/json;base64,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