import * as iam from '@aws-cdk/aws-iam';
import * as kms from '@aws-cdk/aws-kms';
import * as s3 from '@aws-cdk/aws-s3';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Construct } from 'constructs';
/**
 * (experimental) Properties for starting a Query Execution.
 *
 * @experimental
 */
export interface AthenaStartQueryExecutionProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) Query that will be started.
     *
     * @experimental
     */
    readonly queryString: string;
    /**
     * (experimental) Unique string string to ensure idempotence.
     *
     * @default - No client request token
     * @experimental
     */
    readonly clientRequestToken?: string;
    /**
     * (experimental) Database within which query executes.
     *
     * @default - No query execution context
     * @experimental
     */
    readonly queryExecutionContext?: QueryExecutionContext;
    /**
     * (experimental) Configuration on how and where to save query.
     *
     * @default - No result configuration
     * @experimental
     */
    readonly resultConfiguration?: ResultConfiguration;
    /**
     * (experimental) Configuration on how and where to save query.
     *
     * @default - No work group
     * @experimental
     */
    readonly workGroup?: string;
}
/**
 * (experimental) Start an Athena Query as a Task.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-athena.html
 * @experimental
 */
export declare class AthenaStartQueryExecution extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: AthenaStartQueryExecutionProps);
    private createPolicyStatements;
    /**
     * Provides the Athena start query execution service integration task configuration
     */
    /**
     * @internal
     */
    protected _renderTask(): any;
}
/**
 * (experimental) Location of query result along with S3 bucket configuration.
 *
 * @see https://docs.aws.amazon.com/athena/latest/APIReference/API_ResultConfiguration.html
 * @experimental
 */
export interface ResultConfiguration {
    /**
     * (experimental) S3 path of query results.
     *
     * @default - Query Result Location set in Athena settings for this workgroup
     * @experimental
     * @example
     *
     * s3://query-results-bucket/folder/
     */
    readonly outputLocation?: s3.Location;
    /**
     * (experimental) Encryption option used if enabled in S3.
     *
     * @default - SSE_S3 encrpytion is enabled with default encryption key
     * @experimental
     */
    readonly encryptionConfiguration?: EncryptionConfiguration;
}
/**
 * (experimental) Encryption Configuration of the S3 bucket.
 *
 * @see https://docs.aws.amazon.com/athena/latest/APIReference/API_EncryptionConfiguration.html
 * @experimental
 */
export interface EncryptionConfiguration {
    /**
     * (experimental) Type of S3 server-side encryption enabled.
     *
     * @default EncryptionOption.S3_MANAGED
     * @experimental
     */
    readonly encryptionOption: EncryptionOption;
    /**
     * (experimental) KMS key ARN or ID.
     *
     * @default - No KMS key for Encryption Option SSE_S3 and default master key for Encryption Option SSE_KMS and CSE_KMS
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
}
/**
 * (experimental) Encryption Options of the S3 bucket.
 *
 * @see https://docs.aws.amazon.com/athena/latest/APIReference/API_EncryptionConfiguration.html#athena-Type-EncryptionConfiguration-EncryptionOption
 * @experimental
 */
export declare enum EncryptionOption {
    /**
     * (experimental) Server side encryption (SSE) with an Amazon S3-managed key.
     *
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html
     * @experimental
     */
    S3_MANAGED = "SSE_S3",
    /**
     * (experimental) Server-side encryption (SSE) with an AWS KMS key managed by the account owner.
     *
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html
     * @experimental
     */
    KMS = "SSE_KMS",
    /**
     * (experimental) Client-side encryption (CSE) with an AWS KMS key managed by the account owner.
     *
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html
     * @experimental
     */
    CLIENT_SIDE_KMS = "CSE_KMS"
}
/**
 * (experimental) Database and data catalog context in which the query execution occurs.
 *
 * @see https://docs.aws.amazon.com/athena/latest/APIReference/API_QueryExecutionContext.html
 * @experimental
 */
export interface QueryExecutionContext {
    /**
     * (experimental) Name of catalog used in query execution.
     *
     * @default - No catalog
     * @experimental
     */
    readonly catalogName?: string;
    /**
     * (experimental) Name of database used in query execution.
     *
     * @default - No database
     * @experimental
     */
    readonly databaseName?: string;
}
