from __future__ import annotations
import datetime
import typing
from . import geo
from . import polyline
__all__ = ['Bounds', 'Gpx', 'LatLong', 'Segment', 'TimeBounds', 'Track', 'geo', 'parse', 'polyline']
class Bounds:
    max: LatLong | None
    min: LatLong | None
    @typing.overload
    def __init__(self) -> None:
        ...
    @typing.overload
    def __init__(self, min: LatLong, max: LatLong) -> None:
        ...
    @typing.overload
    def __init__(self, min: tuple[float, float], max: tuple[float, float]) -> None:
        ...
    @typing.overload
    def add(self, location: LatLong) -> None:
        ...
    @typing.overload
    def add(self, bounds: Bounds) -> None:
        ...
    def is_empty(self) -> bool:
        ...
    def max_bounds(self, bounds: Bounds) -> Bounds:
        ...
    @property
    def max_latitude(self) -> float | None:
        ...
    @max_latitude.setter
    def max_latitude(self, arg1: float) -> None:
        ...
    @property
    def max_longitude(self) -> float | None:
        ...
    @max_longitude.setter
    def max_longitude(self, arg1: float) -> None:
        ...
    @property
    def min_latitude(self) -> float | None:
        ...
    @min_latitude.setter
    def min_latitude(self, arg1: float) -> None:
        ...
    @property
    def min_longitude(self) -> float | None:
        ...
    @min_longitude.setter
    def min_longitude(self, arg1: float) -> None:
        ...
class Gpx:
    name: str | None
    tracks: list[Track]
    def __init__(self) -> None:
        ...
    def bounds(self) -> Bounds:
        ...
    def get_bounds(self) -> Bounds:
        ...
    def get_time_bounds(self) -> TimeBounds:
        ...
    def length_2d(self) -> float:
        ...
    def length_3d(self) -> float:
        ...
    def time_bounds(self) -> TimeBounds:
        ...
class LatLong:
    elevation: float
    latitude: float
    longitude: float
    @typing.overload
    def __init__(self) -> None:
        ...
    @typing.overload
    def __init__(self, latitude: float, longitude: float, elevation: float = 0.0) -> None:
        ...
class Segment:
    points: list[LatLong]
    def __init__(self) -> None:
        ...
    def bounds(self) -> Bounds:
        ...
    def get_bounds(self) -> Bounds:
        ...
    def get_time_bounds(self) -> TimeBounds:
        ...
    def length_2d(self) -> float:
        ...
    def length_3d(self) -> float:
        ...
    def time_bounds(self) -> TimeBounds:
        ...
class TimeBounds:
    end_time: datetime.datetime | None
    start_time: datetime.datetime | None
    @typing.overload
    def __init__(self) -> None:
        ...
    @typing.overload
    def __init__(self, start_time: datetime.datetime | None, end_time: datetime.datetime | None) -> None:
        ...
    @typing.overload
    def add(self, datetime: datetime.datetime) -> None:
        ...
    @typing.overload
    def add(self, timebounds: TimeBounds) -> None:
        ...
    def is_empty(self) -> bool:
        ...
    def is_range(self) -> bool:
        ...
class Track:
    comment: str | None
    description: str | None
    name: str | None
    number: int | None
    segments: list[Segment]
    type: str | None
    def __init__(self) -> None:
        ...
    def bounds(self) -> Bounds:
        ...
    def get_bounds(self) -> Bounds:
        ...
    def get_time_bounds(self) -> TimeBounds:
        ...
    def length_2d(self) -> float:
        ...
    def length_3d(self) -> float:
        ...
    def time_bounds(self) -> TimeBounds:
        ...
def parse(path: str) -> Gpx:
    ...
