# -*- coding: utf-8 -*-

"""
    mundiapi

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

import mundiapi.models.recipient
import mundiapi.models.get_split_options_response

class GetSplitResponse(object):

    """Implementation of the 'GetSplitResponse' model.

    Split response

    Attributes:
        mtype (string): Type
        amount (int): Amount
        recipient (Recipient): TODO: type description here.
        gateway_id (string): The split rule gateway id
        options (GetSplitOptionsResponse): TODO: type description here.
        id (string): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "mtype":'type',
        "amount":'amount',
        "gateway_id":'gateway_id',
        "id":'id',
        "recipient":'recipient',
        "options":'options'
    }

    def __init__(self,
                 mtype=None,
                 amount=None,
                 gateway_id=None,
                 id=None,
                 recipient=None,
                 options=None):
        """Constructor for the GetSplitResponse class"""

        # Initialize members of the class
        self.mtype = mtype
        self.amount = amount
        self.recipient = recipient
        self.gateway_id = gateway_id
        self.options = options
        self.id = id


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        mtype = dictionary.get('type')
        amount = dictionary.get('amount')
        gateway_id = dictionary.get('gateway_id')
        id = dictionary.get('id')
        recipient = mundiapi.models.recipient.Recipient.from_dictionary(dictionary.get('recipient')) if dictionary.get('recipient') else None
        options = mundiapi.models.get_split_options_response.GetSplitOptionsResponse.from_dictionary(dictionary.get('options')) if dictionary.get('options') else None

        # Return an object of this model
        return cls(mtype,
                   amount,
                   gateway_id,
                   id,
                   recipient,
                   options)


