# -*- coding: utf-8 -*-

"""
    mundiapi

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

from mundiapi.api_helper import APIHelper
from mundiapi.configuration import Configuration
from mundiapi.controllers.base_controller import BaseController
from mundiapi.http.auth.basic_auth import BasicAuth
from mundiapi.models.recipients_metadata_response import RecipientsMetadataResponse
from mundiapi.models.recipients_transfer_settings_response import RecipientsTransferSettingsResponse
from mundiapi.models.recipients_response_1 import RecipientsResponse1
from mundiapi.models.list_withdrawals import ListWithdrawals
from mundiapi.models.recipients_automatic_anticipation_settings_response import RecipientsAutomaticAnticipationSettingsResponse
from mundiapi.models.recipients_code_response import RecipientsCodeResponse
from mundiapi.models.recipients_anticipations_response import RecipientsAnticipationsResponse
from mundiapi.models.recipients_transfers_response import RecipientsTransfersResponse
from mundiapi.models.recipients_anticipation_limits_response import RecipientsAnticipationLimitsResponse
from mundiapi.models.recipients_balance_response import RecipientsBalanceResponse
from mundiapi.models.recipients_transfers_response_1 import RecipientsTransfersResponse1
from mundiapi.models.recipients_response import RecipientsResponse
from mundiapi.models.recipients_anticipations_response_1 import RecipientsAnticipationsResponse1
from mundiapi.models.recipients_default_bank_account_response import RecipientsDefaultBankAccountResponse
from mundiapi.models.get_withdraw_response import GetWithdrawResponse
from mundiapi.exceptions.error_exception import ErrorException

class RecipientsController(BaseController):

    """A Controller to access Endpoints in the mundiapi API."""


    def update_recipient_metadata(self,
                                  recipient_id,
                                  body,
                                  idempotency_key=None):
        """Does a PATCH request to /recipients/{recipient_id}/metadata.

        Updates recipient metadata

        Args:
            recipient_id (string): Recipient id
            body (RecipientsMetadataRequest): Metadata
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            RecipientsMetadataResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/recipients/{recipient_id}/metadata'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'recipient_id': recipient_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'Content-Type': 'application/json',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.patch(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _context.response.status_code == 400:
            raise ErrorException('Invalid request', _context)
        elif _context.response.status_code == 401:
            raise ErrorException('Invalid API key', _context)
        elif _context.response.status_code == 404:
            raise ErrorException('An informed resource was not found', _context)
        elif _context.response.status_code == 412:
            raise ErrorException('Business validation error', _context)
        elif _context.response.status_code == 422:
            raise ErrorException('Contract validation error', _context)
        elif _context.response.status_code == 500:
            raise ErrorException('Internal server error', _context)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, RecipientsMetadataResponse.from_dictionary)

    def update_recipient_transfer_settings(self,
                                           recipient_id,
                                           body,
                                           idempotency_key=None):
        """Does a PATCH request to /recipients/{recipient_id}/transfer-settings.

        UpdateRecipientTransferSettings

        Args:
            recipient_id (string): Recipient Identificator
            body (UpdateTransferSettingsRequest): TODO: type description here.
                Example: 
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            RecipientsTransferSettingsResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/recipients/{recipient_id}/transfer-settings'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'recipient_id': recipient_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'Content-Type': 'application/json',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.patch(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _context.response.status_code == 400:
            raise ErrorException('Invalid request', _context)
        elif _context.response.status_code == 401:
            raise ErrorException('Invalid API key', _context)
        elif _context.response.status_code == 404:
            raise ErrorException('An informed resource was not found', _context)
        elif _context.response.status_code == 412:
            raise ErrorException('Business validation error', _context)
        elif _context.response.status_code == 422:
            raise ErrorException('Contract validation error', _context)
        elif _context.response.status_code == 500:
            raise ErrorException('Internal server error', _context)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, RecipientsTransferSettingsResponse.from_dictionary)

    def create_recipient(self,
                         body,
                         idempotency_key=None):
        """Does a POST request to /recipients.

        Creates a new recipient

        Args:
            body (RecipientsRequest): Recipient data
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            RecipientsResponse1: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/recipients'
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'Content-Type': 'application/json',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _context.response.status_code == 400:
            raise ErrorException('Invalid request', _context)
        elif _context.response.status_code == 401:
            raise ErrorException('Invalid API key', _context)
        elif _context.response.status_code == 404:
            raise ErrorException('An informed resource was not found', _context)
        elif _context.response.status_code == 412:
            raise ErrorException('Business validation error', _context)
        elif _context.response.status_code == 422:
            raise ErrorException('Contract validation error', _context)
        elif _context.response.status_code == 500:
            raise ErrorException('Internal server error', _context)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, RecipientsResponse1.from_dictionary)

    def get_withdrawals(self,
                        recipient_id,
                        page=None,
                        size=None,
                        status=None,
                        created_since=None,
                        created_until=None):
        """Does a GET request to /recipients/{recipient_id}/withdrawals.

        Gets a paginated list of transfers for the recipient

        Args:
            recipient_id (string): TODO: type description here. Example: 
            page (int, optional): TODO: type description here. Example: 
            size (int, optional): TODO: type description here. Example: 
            status (string, optional): TODO: type description here. Example: 
            created_since (datetime, optional): TODO: type description here.
                Example: 
            created_until (datetime, optional): TODO: type description here.
                Example: 

        Returns:
            ListWithdrawals: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/recipients/{recipient_id}/withdrawals'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'recipient_id': recipient_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_parameters = {
            'page': page,
            'size': size,
            'status': status,
            'created_since': APIHelper.when_defined(APIHelper.RFC3339DateTime, created_since),
            'created_until': APIHelper.when_defined(APIHelper.RFC3339DateTime, created_until)
        }
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder,
            _query_parameters, Configuration.array_serialization)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _context.response.status_code == 400:
            raise ErrorException('Invalid request', _context)
        elif _context.response.status_code == 401:
            raise ErrorException('Invalid API key', _context)
        elif _context.response.status_code == 404:
            raise ErrorException('An informed resource was not found', _context)
        elif _context.response.status_code == 412:
            raise ErrorException('Business validation error', _context)
        elif _context.response.status_code == 422:
            raise ErrorException('Contract validation error', _context)
        elif _context.response.status_code == 500:
            raise ErrorException('Internal server error', _context)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, ListWithdrawals.from_dictionary)

    def update_automatic_anticipation_settings(self,
                                               recipient_id,
                                               body,
                                               idempotency_key=None):
        """Does a PATCH request to /recipients/{recipient_id}/automatic-anticipation-settings.

        Updates recipient metadata

        Args:
            recipient_id (string): Recipient id
            body (UpdateAutomaticAnticipationSettingsRequest): Metadata
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            RecipientsAutomaticAnticipationSettingsResponse: Response from the
                API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/recipients/{recipient_id}/automatic-anticipation-settings'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'recipient_id': recipient_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'Content-Type': 'application/json',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.patch(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _context.response.status_code == 400:
            raise ErrorException('Invalid request', _context)
        elif _context.response.status_code == 401:
            raise ErrorException('Invalid API key', _context)
        elif _context.response.status_code == 404:
            raise ErrorException('An informed resource was not found', _context)
        elif _context.response.status_code == 412:
            raise ErrorException('Business validation error', _context)
        elif _context.response.status_code == 422:
            raise ErrorException('Contract validation error', _context)
        elif _context.response.status_code == 500:
            raise ErrorException('Internal server error', _context)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, RecipientsAutomaticAnticipationSettingsResponse.from_dictionary)

    def get_recipient_by_code(self,
                              code):
        """Does a GET request to /recipients/code/{code}.

        Retrieves recipient information

        Args:
            code (string): Recipient code

        Returns:
            RecipientsCodeResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/recipients/code/{code}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'code': code
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _context.response.status_code == 400:
            raise ErrorException('Invalid request', _context)
        elif _context.response.status_code == 401:
            raise ErrorException('Invalid API key', _context)
        elif _context.response.status_code == 404:
            raise ErrorException('An informed resource was not found', _context)
        elif _context.response.status_code == 412:
            raise ErrorException('Business validation error', _context)
        elif _context.response.status_code == 422:
            raise ErrorException('Contract validation error', _context)
        elif _context.response.status_code == 500:
            raise ErrorException('Internal server error', _context)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, RecipientsCodeResponse.from_dictionary)

    def get_anticipation(self,
                         recipient_id,
                         anticipation_id):
        """Does a GET request to /recipients/{recipient_id}/anticipations/{anticipation_id}.

        Gets an anticipation

        Args:
            recipient_id (string): Recipient id
            anticipation_id (string): Anticipation id

        Returns:
            RecipientsAnticipationsResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/recipients/{recipient_id}/anticipations/{anticipation_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'recipient_id': recipient_id,
            'anticipation_id': anticipation_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _context.response.status_code == 400:
            raise ErrorException('Invalid request', _context)
        elif _context.response.status_code == 401:
            raise ErrorException('Invalid API key', _context)
        elif _context.response.status_code == 404:
            raise ErrorException('An informed resource was not found', _context)
        elif _context.response.status_code == 412:
            raise ErrorException('Business validation error', _context)
        elif _context.response.status_code == 422:
            raise ErrorException('Contract validation error', _context)
        elif _context.response.status_code == 500:
            raise ErrorException('Internal server error', _context)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, RecipientsAnticipationsResponse.from_dictionary)

    def get_recipient(self,
                      recipient_id):
        """Does a GET request to /recipients/{recipient_id}.

        Retrieves recipient information

        Args:
            recipient_id (string): Recipiend id

        Returns:
            RecipientsResponse1: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/recipients/{recipient_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'recipient_id': recipient_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _context.response.status_code == 400:
            raise ErrorException('Invalid request', _context)
        elif _context.response.status_code == 401:
            raise ErrorException('Invalid API key', _context)
        elif _context.response.status_code == 404:
            raise ErrorException('An informed resource was not found', _context)
        elif _context.response.status_code == 412:
            raise ErrorException('Business validation error', _context)
        elif _context.response.status_code == 422:
            raise ErrorException('Contract validation error', _context)
        elif _context.response.status_code == 500:
            raise ErrorException('Internal server error', _context)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, RecipientsResponse1.from_dictionary)

    def update_recipient(self,
                         recipient_id,
                         body,
                         idempotency_key=None):
        """Does a PUT request to /recipients/{recipient_id}.

        Updates a recipient

        Args:
            recipient_id (string): Recipient id
            body (RecipientsRequest1): Recipient data
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            RecipientsResponse1: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/recipients/{recipient_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'recipient_id': recipient_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'Content-Type': 'application/json',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.put(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _context.response.status_code == 400:
            raise ErrorException('Invalid request', _context)
        elif _context.response.status_code == 401:
            raise ErrorException('Invalid API key', _context)
        elif _context.response.status_code == 404:
            raise ErrorException('An informed resource was not found', _context)
        elif _context.response.status_code == 412:
            raise ErrorException('Business validation error', _context)
        elif _context.response.status_code == 422:
            raise ErrorException('Contract validation error', _context)
        elif _context.response.status_code == 500:
            raise ErrorException('Internal server error', _context)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, RecipientsResponse1.from_dictionary)

    def get_transfer(self,
                     recipient_id,
                     transfer_id):
        """Does a GET request to /recipients/{recipient_id}/transfers/{transfer_id}.

        Gets a transfer

        Args:
            recipient_id (string): Recipient id
            transfer_id (string): Transfer id

        Returns:
            RecipientsTransfersResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/recipients/{recipient_id}/transfers/{transfer_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'recipient_id': recipient_id,
            'transfer_id': transfer_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _context.response.status_code == 400:
            raise ErrorException('Invalid request', _context)
        elif _context.response.status_code == 401:
            raise ErrorException('Invalid API key', _context)
        elif _context.response.status_code == 404:
            raise ErrorException('An informed resource was not found', _context)
        elif _context.response.status_code == 412:
            raise ErrorException('Business validation error', _context)
        elif _context.response.status_code == 422:
            raise ErrorException('Contract validation error', _context)
        elif _context.response.status_code == 500:
            raise ErrorException('Internal server error', _context)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, RecipientsTransfersResponse.from_dictionary)

    def get_anticipation_limits(self,
                                recipient_id,
                                timeframe,
                                payment_date):
        """Does a GET request to /recipients/{recipient_id}/anticipation_limits.

        Gets the anticipation limits for a recipient

        Args:
            recipient_id (string): Recipient id
            timeframe (string): Timeframe
            payment_date (datetime): Anticipation payment date

        Returns:
            RecipientsAnticipationLimitsResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/recipients/{recipient_id}/anticipation_limits'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'recipient_id': recipient_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_parameters = {
            'timeframe': timeframe,
            'payment_date': APIHelper.when_defined(APIHelper.RFC3339DateTime, payment_date)
        }
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder,
            _query_parameters, Configuration.array_serialization)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _context.response.status_code == 400:
            raise ErrorException('Invalid request', _context)
        elif _context.response.status_code == 401:
            raise ErrorException('Invalid API key', _context)
        elif _context.response.status_code == 404:
            raise ErrorException('An informed resource was not found', _context)
        elif _context.response.status_code == 412:
            raise ErrorException('Business validation error', _context)
        elif _context.response.status_code == 422:
            raise ErrorException('Contract validation error', _context)
        elif _context.response.status_code == 500:
            raise ErrorException('Internal server error', _context)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, RecipientsAnticipationLimitsResponse.from_dictionary)

    def get_balance(self,
                    recipient_id):
        """Does a GET request to /recipients/{recipient_id}/balance.

        Get balance information for a recipient

        Args:
            recipient_id (string): Recipient id

        Returns:
            RecipientsBalanceResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/recipients/{recipient_id}/balance'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'recipient_id': recipient_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _context.response.status_code == 400:
            raise ErrorException('Invalid request', _context)
        elif _context.response.status_code == 401:
            raise ErrorException('Invalid API key', _context)
        elif _context.response.status_code == 404:
            raise ErrorException('An informed resource was not found', _context)
        elif _context.response.status_code == 412:
            raise ErrorException('Business validation error', _context)
        elif _context.response.status_code == 422:
            raise ErrorException('Contract validation error', _context)
        elif _context.response.status_code == 500:
            raise ErrorException('Internal server error', _context)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, RecipientsBalanceResponse.from_dictionary)

    def create_anticipation(self,
                            recipient_id,
                            body,
                            idempotency_key=None):
        """Does a POST request to /recipients/{recipient_id}/anticipations.

        Creates an anticipation

        Args:
            recipient_id (string): Recipient id
            body (RecipientsAnticipationsRequest): Anticipation data
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            RecipientsAnticipationsResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/recipients/{recipient_id}/anticipations'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'recipient_id': recipient_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'Content-Type': 'application/json',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _context.response.status_code == 400:
            raise ErrorException('Invalid request', _context)
        elif _context.response.status_code == 401:
            raise ErrorException('Invalid API key', _context)
        elif _context.response.status_code == 404:
            raise ErrorException('An informed resource was not found', _context)
        elif _context.response.status_code == 412:
            raise ErrorException('Business validation error', _context)
        elif _context.response.status_code == 422:
            raise ErrorException('Contract validation error', _context)
        elif _context.response.status_code == 500:
            raise ErrorException('Internal server error', _context)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, RecipientsAnticipationsResponse.from_dictionary)

    def get_transfers(self,
                      recipient_id,
                      page=None,
                      size=None,
                      status=None,
                      created_since=None,
                      created_until=None):
        """Does a GET request to /recipients/{recipient_id}/transfers.

        Gets a paginated list of transfers for the recipient

        Args:
            recipient_id (string): Recipient id
            page (int, optional): Page number
            size (int, optional): Page size
            status (string, optional): Filter for transfer status
            created_since (datetime, optional): Filter for start range of
                transfer creation date
            created_until (datetime, optional): Filter for end range of
                transfer creation date

        Returns:
            RecipientsTransfersResponse1: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/recipients/{recipient_id}/transfers'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'recipient_id': recipient_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_parameters = {
            'page': page,
            'size': size,
            'status': status,
            'created_since': APIHelper.when_defined(APIHelper.RFC3339DateTime, created_since),
            'created_until': APIHelper.when_defined(APIHelper.RFC3339DateTime, created_until)
        }
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder,
            _query_parameters, Configuration.array_serialization)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _context.response.status_code == 400:
            raise ErrorException('Invalid request', _context)
        elif _context.response.status_code == 401:
            raise ErrorException('Invalid API key', _context)
        elif _context.response.status_code == 404:
            raise ErrorException('An informed resource was not found', _context)
        elif _context.response.status_code == 412:
            raise ErrorException('Business validation error', _context)
        elif _context.response.status_code == 422:
            raise ErrorException('Contract validation error', _context)
        elif _context.response.status_code == 500:
            raise ErrorException('Internal server error', _context)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, RecipientsTransfersResponse1.from_dictionary)

    def get_recipients(self,
                       page=None,
                       size=None):
        """Does a GET request to /recipients.

        Retrieves paginated recipients information

        Args:
            page (int, optional): Page number
            size (int, optional): Page size

        Returns:
            RecipientsResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/recipients'
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_parameters = {
            'page': page,
            'size': size
        }
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder,
            _query_parameters, Configuration.array_serialization)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _context.response.status_code == 400:
            raise ErrorException('Invalid request', _context)
        elif _context.response.status_code == 401:
            raise ErrorException('Invalid API key', _context)
        elif _context.response.status_code == 404:
            raise ErrorException('An informed resource was not found', _context)
        elif _context.response.status_code == 412:
            raise ErrorException('Business validation error', _context)
        elif _context.response.status_code == 422:
            raise ErrorException('Contract validation error', _context)
        elif _context.response.status_code == 500:
            raise ErrorException('Internal server error', _context)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, RecipientsResponse.from_dictionary)

    def get_anticipations(self,
                          recipient_id,
                          page=None,
                          size=None,
                          status=None,
                          timeframe=None,
                          payment_date_since=None,
                          payment_date_until=None,
                          created_since=None,
                          created_until=None):
        """Does a GET request to /recipients/{recipient_id}/anticipations.

        Retrieves a paginated list of anticipations from a recipient

        Args:
            recipient_id (string): Recipient id
            page (int, optional): Page number
            size (int, optional): Page size
            status (string, optional): Filter for anticipation status
            timeframe (string, optional): Filter for anticipation timeframe
            payment_date_since (datetime, optional): Filter for start range
                for anticipation payment date
            payment_date_until (datetime, optional): Filter for end range for
                anticipation payment date
            created_since (datetime, optional): Filter for start range for
                anticipation creation date
            created_until (datetime, optional): Filter for end range for
                anticipation creation date

        Returns:
            RecipientsAnticipationsResponse1: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/recipients/{recipient_id}/anticipations'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'recipient_id': recipient_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_parameters = {
            'page': page,
            'size': size,
            'status': status,
            'timeframe': timeframe,
            'payment_date_since': APIHelper.when_defined(APIHelper.RFC3339DateTime, payment_date_since),
            'payment_date_until': APIHelper.when_defined(APIHelper.RFC3339DateTime, payment_date_until),
            'created_since': APIHelper.when_defined(APIHelper.RFC3339DateTime, created_since),
            'created_until': APIHelper.when_defined(APIHelper.RFC3339DateTime, created_until)
        }
        _query_builder = APIHelper.append_url_with_query_parameters(_query_builder,
            _query_parameters, Configuration.array_serialization)
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _context.response.status_code == 400:
            raise ErrorException('Invalid request', _context)
        elif _context.response.status_code == 401:
            raise ErrorException('Invalid API key', _context)
        elif _context.response.status_code == 404:
            raise ErrorException('An informed resource was not found', _context)
        elif _context.response.status_code == 412:
            raise ErrorException('Business validation error', _context)
        elif _context.response.status_code == 422:
            raise ErrorException('Contract validation error', _context)
        elif _context.response.status_code == 500:
            raise ErrorException('Internal server error', _context)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, RecipientsAnticipationsResponse1.from_dictionary)

    def update_recipient_default_bank_account(self,
                                              recipient_id,
                                              body,
                                              idempotency_key=None):
        """Does a PATCH request to /recipients/{recipient_id}/default-bank-account.

        Updates the default bank account from a recipient

        Args:
            recipient_id (string): Recipient id
            body (RecipientsDefaultBankAccountRequest): Bank account data
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            RecipientsDefaultBankAccountResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/recipients/{recipient_id}/default-bank-account'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'recipient_id': recipient_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'Content-Type': 'application/json',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.patch(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _context.response.status_code == 400:
            raise ErrorException('Invalid request', _context)
        elif _context.response.status_code == 401:
            raise ErrorException('Invalid API key', _context)
        elif _context.response.status_code == 404:
            raise ErrorException('An informed resource was not found', _context)
        elif _context.response.status_code == 412:
            raise ErrorException('Business validation error', _context)
        elif _context.response.status_code == 422:
            raise ErrorException('Contract validation error', _context)
        elif _context.response.status_code == 500:
            raise ErrorException('Internal server error', _context)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, RecipientsDefaultBankAccountResponse.from_dictionary)

    def create_transfer(self,
                        recipient_id,
                        body,
                        idempotency_key=None):
        """Does a POST request to /recipients/{recipient_id}/transfers.

        Creates a transfer for a recipient

        Args:
            recipient_id (string): Recipient Id
            body (RecipientsTransfersRequest): Transfer data
            idempotency_key (string, optional): TODO: type description here.
                Example: 

        Returns:
            RecipientsTransfersResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/recipients/{recipient_id}/transfers'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'recipient_id': recipient_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'Content-Type': 'application/json',
            'idempotency-key': idempotency_key
        }

        # Prepare and execute request
        _request = self.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _context.response.status_code == 400:
            raise ErrorException('Invalid request', _context)
        elif _context.response.status_code == 401:
            raise ErrorException('Invalid API key', _context)
        elif _context.response.status_code == 404:
            raise ErrorException('An informed resource was not found', _context)
        elif _context.response.status_code == 412:
            raise ErrorException('Business validation error', _context)
        elif _context.response.status_code == 422:
            raise ErrorException('Contract validation error', _context)
        elif _context.response.status_code == 500:
            raise ErrorException('Internal server error', _context)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, RecipientsTransfersResponse.from_dictionary)

    def create_withdraw(self,
                        recipient_id,
                        body):
        """Does a POST request to /recipients/{recipient_id}/withdrawals.

        CreateWithdraw

        Args:
            recipient_id (string): TODO: type description here. Example: 
            body (CreateWithdrawRequest): TODO: type description here.
                Example: 

        Returns:
            GetWithdrawResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/recipients/{recipient_id}/withdrawals'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'recipient_id': recipient_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'Content-Type': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _context.response.status_code == 400:
            raise ErrorException('Invalid request', _context)
        elif _context.response.status_code == 401:
            raise ErrorException('Invalid API key', _context)
        elif _context.response.status_code == 404:
            raise ErrorException('An informed resource was not found', _context)
        elif _context.response.status_code == 412:
            raise ErrorException('Business validation error', _context)
        elif _context.response.status_code == 422:
            raise ErrorException('Contract validation error', _context)
        elif _context.response.status_code == 500:
            raise ErrorException('Internal server error', _context)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetWithdrawResponse.from_dictionary)

    def get_withdraw_by_id(self,
                           recipient_id,
                           withdrawal_id):
        """Does a GET request to /recipients/{recipient_id}/withdrawals/{withdrawal_id}.

        GetWithdrawById

        Args:
            recipient_id (string): TODO: type description here. Example: 
            withdrawal_id (string): TODO: type description here. Example: 

        Returns:
            GetWithdrawResponse: Response from the API. 

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/recipients/{recipient_id}/withdrawals/{withdrawal_id}'
        _url_path = APIHelper.append_url_with_template_parameters(_url_path, { 
            'recipient_id': recipient_id,
            'withdrawal_id': withdrawal_id
        })
        _query_builder = Configuration.base_uri
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json'
        }

        # Prepare and execute request
        _request = self.http_client.get(_query_url, headers=_headers)
        BasicAuth.apply(_request)
        _context = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _context.response.status_code == 400:
            raise ErrorException('Invalid request', _context)
        elif _context.response.status_code == 401:
            raise ErrorException('Invalid API key', _context)
        elif _context.response.status_code == 404:
            raise ErrorException('An informed resource was not found', _context)
        elif _context.response.status_code == 412:
            raise ErrorException('Business validation error', _context)
        elif _context.response.status_code == 422:
            raise ErrorException('Contract validation error', _context)
        elif _context.response.status_code == 500:
            raise ErrorException('Internal server error', _context)
        self.validate_response(_context)

        # Return appropriate type
        return APIHelper.json_deserialize(_context.response.raw_body, GetWithdrawResponse.from_dictionary)
