"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourceType = exports.ManagedRuleIdentifiers = exports.CustomRule = exports.ManagedRule = exports.MaximumExecutionFrequency = exports.RuleScope = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("@aws-cdk/aws-events");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const config_generated_1 = require("./config.generated");
/**
 * A new or imported rule.
 */
class RuleBase extends core_1.Resource {
    /**
     * Defines an EventBridge event rule which triggers for rule events.
     *
     * Use
     * `rule.addEventPattern(pattern)` to specify a filter.
     *
     * @stability stable
     */
    onEvent(id, options = {}) {
        const rule = new events.Rule(this, id, options);
        rule.addEventPattern({
            source: ['aws.config'],
            detail: {
                configRuleName: [this.configRuleName],
            },
        });
        rule.addTarget(options.target);
        return rule;
    }
    /**
     * Defines an EventBridge event rule which triggers for rule compliance events.
     *
     * @stability stable
     */
    onComplianceChange(id, options = {}) {
        const rule = this.onEvent(id, options);
        rule.addEventPattern({
            detailType: ['Config Rules Compliance Change'],
        });
        return rule;
    }
    /**
     * Defines an EventBridge event rule which triggers for rule re-evaluation status events.
     *
     * @stability stable
     */
    onReEvaluationStatus(id, options = {}) {
        const rule = this.onEvent(id, options);
        rule.addEventPattern({
            detailType: ['Config Rules Re-evaluation Status'],
        });
        return rule;
    }
}
/**
 * A new managed or custom rule.
 */
class RuleNew extends RuleBase {
    /**
     * Imports an existing rule.
     *
     * @param configRuleName the name of the rule.
     * @stability stable
     */
    static fromConfigRuleName(scope, id, configRuleName) {
        class Import extends RuleBase {
            constructor() {
                super(...arguments);
                this.configRuleName = configRuleName;
            }
        }
        return new Import(scope, id);
    }
}
/**
 * Determines which resources trigger an evaluation of an AWS Config rule.
 *
 * @stability stable
 */
class RuleScope {
    constructor(resourceId, resourceTypes, tagKey, tagValue) {
        this.resourceTypes = resourceTypes;
        this.resourceId = resourceId;
        this.key = tagKey;
        this.value = tagValue;
    }
    /**
     * restricts scope of changes to a specific resource type or resource identifier.
     *
     * @stability stable
     */
    static fromResource(resourceType, resourceId) {
        return new RuleScope(resourceId, [resourceType]);
    }
    /**
     * restricts scope of changes to specific resource types.
     *
     * @stability stable
     */
    static fromResources(resourceTypes) {
        return new RuleScope(undefined, resourceTypes);
    }
    /**
     * restricts scope of changes to a specific tag.
     *
     * @stability stable
     */
    static fromTag(key, value) {
        return new RuleScope(undefined, undefined, key, value);
    }
}
exports.RuleScope = RuleScope;
_a = JSII_RTTI_SYMBOL_1;
RuleScope[_a] = { fqn: "@aws-cdk/aws-config.RuleScope", version: "1.114.0" };
/**
 * The maximum frequency at which the AWS Config rule runs evaluations.
 *
 * @stability stable
 */
var MaximumExecutionFrequency;
(function (MaximumExecutionFrequency) {
    MaximumExecutionFrequency["ONE_HOUR"] = "One_Hour";
    MaximumExecutionFrequency["THREE_HOURS"] = "Three_Hours";
    MaximumExecutionFrequency["SIX_HOURS"] = "Six_Hours";
    MaximumExecutionFrequency["TWELVE_HOURS"] = "Twelve_Hours";
    MaximumExecutionFrequency["TWENTY_FOUR_HOURS"] = "TwentyFour_Hours";
})(MaximumExecutionFrequency = exports.MaximumExecutionFrequency || (exports.MaximumExecutionFrequency = {}));
/**
 * A new managed rule.
 *
 * @stability stable
 * @resource AWS::Config::ConfigRule
 */
class ManagedRule extends RuleNew {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.configRuleName,
        });
        this.ruleScope = props.ruleScope;
        const rule = new config_generated_1.CfnConfigRule(this, 'Resource', {
            configRuleName: this.physicalName,
            description: props.description,
            inputParameters: props.inputParameters,
            maximumExecutionFrequency: props.maximumExecutionFrequency,
            scope: core_1.Lazy.any({ produce: () => renderScope(this.ruleScope) }),
            source: {
                owner: 'AWS',
                sourceIdentifier: props.identifier,
            },
        });
        this.configRuleName = rule.ref;
        this.configRuleArn = rule.attrArn;
        this.configRuleId = rule.attrConfigRuleId;
        this.configRuleComplianceType = rule.attrComplianceType;
        this.isManaged = true;
    }
}
exports.ManagedRule = ManagedRule;
_b = JSII_RTTI_SYMBOL_1;
ManagedRule[_b] = { fqn: "@aws-cdk/aws-config.ManagedRule", version: "1.114.0" };
/**
 * A new custom rule.
 *
 * @stability stable
 * @resource AWS::Config::ConfigRule
 */
class CustomRule extends RuleNew {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.configRuleName,
        });
        if (!props.configurationChanges && !props.periodic) {
            throw new Error('At least one of `configurationChanges` or `periodic` must be set to true.');
        }
        const sourceDetails = [];
        this.ruleScope = props.ruleScope;
        if (props.configurationChanges) {
            sourceDetails.push({
                eventSource: 'aws.config',
                messageType: 'ConfigurationItemChangeNotification',
            });
            sourceDetails.push({
                eventSource: 'aws.config',
                messageType: 'OversizedConfigurationItemChangeNotification',
            });
        }
        if (props.periodic) {
            sourceDetails.push({
                eventSource: 'aws.config',
                maximumExecutionFrequency: props.maximumExecutionFrequency,
                messageType: 'ScheduledNotification',
            });
        }
        props.lambdaFunction.addPermission('Permission', {
            principal: new iam.ServicePrincipal('config.amazonaws.com'),
        });
        if (props.lambdaFunction.role) {
            props.lambdaFunction.role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSConfigRulesExecutionRole'));
        }
        // The lambda permission must be created before the rule
        this.node.addDependency(props.lambdaFunction);
        const rule = new config_generated_1.CfnConfigRule(this, 'Resource', {
            configRuleName: this.physicalName,
            description: props.description,
            inputParameters: props.inputParameters,
            maximumExecutionFrequency: props.maximumExecutionFrequency,
            scope: core_1.Lazy.any({ produce: () => renderScope(this.ruleScope) }),
            source: {
                owner: 'CUSTOM_LAMBDA',
                sourceDetails,
                sourceIdentifier: props.lambdaFunction.functionArn,
            },
        });
        this.configRuleName = rule.ref;
        this.configRuleArn = rule.attrArn;
        this.configRuleId = rule.attrConfigRuleId;
        this.configRuleComplianceType = rule.attrComplianceType;
        if (props.configurationChanges) {
            this.isCustomWithChanges = true;
        }
    }
}
exports.CustomRule = CustomRule;
_c = JSII_RTTI_SYMBOL_1;
CustomRule[_c] = { fqn: "@aws-cdk/aws-config.CustomRule", version: "1.114.0" };
/**
 * Managed rules that are supported by AWS Config.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html
 * @stability stable
 */
class ManagedRuleIdentifiers {
    // utility class
    constructor() { }
}
exports.ManagedRuleIdentifiers = ManagedRuleIdentifiers;
_d = JSII_RTTI_SYMBOL_1;
ManagedRuleIdentifiers[_d] = { fqn: "@aws-cdk/aws-config.ManagedRuleIdentifiers", version: "1.114.0" };
/**
 * Checks that the inline policies attached to your AWS Identity and Access Management users, roles, and groups do not allow blocked actions on all AWS Key Management Service keys.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-inline-policy-blocked-kms-actions.html
 * @stability stable
 */
ManagedRuleIdentifiers.IAM_INLINE_POLICY_BLOCKED_KMS_ACTIONS = 'IAM_INLINE_POLICY_BLOCKED_KMS_ACTIONS';
/**
 * Checks that the managed AWS Identity and Access Management policies that you create do not allow blocked actions on all AWS AWS KMS keys.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-customer-policy-blocked-kms-actions.html
 * @stability stable
 */
ManagedRuleIdentifiers.IAM_CUSTOMER_POLICY_BLOCKED_KMS_ACTIONS = 'IAM_CUSTOMER_POLICY_BLOCKED_KMS_ACTIONS';
/**
 * Checks whether the active access keys are rotated within the number of days specified in maxAccessKeyAge.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/access-keys-rotated.html
 * @stability stable
 */
ManagedRuleIdentifiers.ACCESS_KEYS_ROTATED = 'ACCESS_KEYS_ROTATED';
/**
 * Checks whether AWS account is part of AWS Organizations.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/account-part-of-organizations.html
 * @stability stable
 */
ManagedRuleIdentifiers.ACCOUNT_PART_OF_ORGANIZATIONS = 'ACCOUNT_PART_OF_ORGANIZATIONS';
/**
 * Checks whether ACM Certificates in your account are marked for expiration within the specified number of days.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/acm-certificate-expiration-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.ACM_CERTIFICATE_EXPIRATION_CHECK = 'ACM_CERTIFICATE_EXPIRATION_CHECK';
/**
 * Checks if rule evaluates Application Load Balancers (ALBs) to ensure they are configured to drop http headers.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/alb-http-drop-invalid-header-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.ALB_HTTP_DROP_INVALID_HEADER_ENABLED = 'ALB_HTTP_DROP_INVALID_HEADER_ENABLED';
/**
 * Checks whether HTTP to HTTPS redirection is configured on all HTTP listeners of Application Load Balancer.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/alb-http-to-https-redirection-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.ALB_HTTP_TO_HTTPS_REDIRECTION_CHECK = 'ALB_HTTP_TO_HTTPS_REDIRECTION_CHECK';
/**
 * Checks if Web Application Firewall (WAF) is enabled on Application Load Balancers (ALBs).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/alb-waf-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.ALB_WAF_ENABLED = 'ALB_WAF_ENABLED';
/**
 * Checks that all methods in Amazon API Gateway stages have caching enabled and encrypted.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/api-gw-cache-enabled-and-encrypted.html
 * @stability stable
 */
ManagedRuleIdentifiers.API_GW_CACHE_ENABLED_AND_ENCRYPTED = 'API_GW_CACHE_ENABLED_AND_ENCRYPTED';
/**
 * Checks that Amazon API Gateway APIs are of the type specified in the rule parameter endpointConfigurationType.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/api-gw-endpoint-type-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.API_GW_ENDPOINT_TYPE_CHECK = 'API_GW_ENDPOINT_TYPE_CHECK';
/**
 * Checks that all methods in Amazon API Gateway stage has logging enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/api-gw-execution-logging-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.API_GW_EXECUTION_LOGGING_ENABLED = 'API_GW_EXECUTION_LOGGING_ENABLED';
/**
 * Checks whether running instances are using specified AMIs.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/approved-amis-by-id.html
 * @stability stable
 */
ManagedRuleIdentifiers.APPROVED_AMIS_BY_ID = 'APPROVED_AMIS_BY_ID';
/**
 * Checks whether running instances are using specified AMIs.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/approved-amis-by-tag.html
 * @stability stable
 */
ManagedRuleIdentifiers.APPROVED_AMIS_BY_TAG = 'APPROVED_AMIS_BY_TAG';
/**
 * Checks whether your Auto Scaling groups that are associated with a load balancer are using Elastic Load Balancing health checks.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/autoscaling-group-elb-healthcheck-required.html
 * @stability stable
 */
ManagedRuleIdentifiers.AUTOSCALING_GROUP_ELB_HEALTHCHECK_REQUIRED = 'AUTOSCALING_GROUP_ELB_HEALTHCHECK_REQUIRED';
/**
 * Checks whether an AWS CloudFormation stack's actual configuration differs, or has drifted, from it's expected configuration.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudformation-stack-drift-detection-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.CLOUDFORMATION_STACK_DRIFT_DETECTION_CHECK = 'CLOUDFORMATION_STACK_DRIFT_DETECTION_CHECK';
/**
 * Checks whether your CloudFormation stacks are sending event notifications to an SNS topic.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudformation-stack-notification-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.CLOUDFORMATION_STACK_NOTIFICATION_CHECK = 'CLOUDFORMATION_STACK_NOTIFICATION_CHECK';
/**
 * Checks if an Amazon CloudFront distribution is configured to return a specific object that is the default root object.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-default-root-object-configured.html
 * @stability stable
 */
ManagedRuleIdentifiers.CLOUDFRONT_DEFAULT_ROOT_OBJECT_CONFIGURED = 'CLOUDFRONT_DEFAULT_ROOT_OBJECT_CONFIGURED';
/**
 * Checks that Amazon CloudFront distribution with Amazon S3 Origin type has Origin Access Identity (OAI) configured.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-origin-access-identity-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.CLOUDFRONT_ORIGIN_ACCESS_IDENTITY_ENABLED = 'CLOUDFRONT_ORIGIN_ACCESS_IDENTITY_ENABLED';
/**
 * Checks whether an origin group is configured for the distribution of at least 2 origins in the origin group for Amazon CloudFront.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-origin-failover-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.CLOUDFRONT_ORIGIN_FAILOVER_ENABLED = 'CLOUDFRONT_ORIGIN_FAILOVER_ENABLED';
/**
 * Checks if Amazon CloudFront distributions are using a custom SSL certificate and are configured to use SNI to serve HTTPS requests.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-sni-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.CLOUDFRONT_SNI_ENABLED = 'CLOUDFRONT_SNI_ENABLED';
/**
 * Checks whether your Amazon CloudFront distributions use HTTPS (directly or via a redirection).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-viewer-policy-https.html
 * @stability stable
 */
ManagedRuleIdentifiers.CLOUDFRONT_VIEWER_POLICY_HTTPS = 'CLOUDFRONT_VIEWER_POLICY_HTTPS';
/**
 * Checks whether AWS CloudTrail trails are configured to send logs to Amazon CloudWatch Logs.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloud-trail-cloud-watch-logs-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.CLOUD_TRAIL_CLOUD_WATCH_LOGS_ENABLED = 'CLOUD_TRAIL_CLOUD_WATCH_LOGS_ENABLED';
/**
 * Checks whether AWS CloudTrail is enabled in your AWS account.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudtrail-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.CLOUD_TRAIL_ENABLED = 'CLOUD_TRAIL_ENABLED';
/**
 * Checks whether AWS CloudTrail is configured to use the server side encryption (SSE) AWS Key Management Service (AWS KMS) customer master key (CMK) encryption.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloud-trail-encryption-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.CLOUD_TRAIL_ENCRYPTION_ENABLED = 'CLOUD_TRAIL_ENCRYPTION_ENABLED';
/**
 * Checks whether AWS CloudTrail creates a signed digest file with logs.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloud-trail-log-file-validation-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.CLOUD_TRAIL_LOG_FILE_VALIDATION_ENABLED = 'CLOUD_TRAIL_LOG_FILE_VALIDATION_ENABLED';
/**
 * Checks whether at least one AWS CloudTrail trail is logging Amazon S3 data events for all S3 buckets.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudtrail-s3-dataevents-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.CLOUDTRAIL_S3_DATAEVENTS_ENABLED = 'CLOUDTRAIL_S3_DATAEVENTS_ENABLED';
/**
 * Checks that there is at least one AWS CloudTrail trail defined with security best practices.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudtrail-security-trail-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.CLOUDTRAIL_SECURITY_TRAIL_ENABLED = 'CLOUDTRAIL_SECURITY_TRAIL_ENABLED';
/**
 * Checks whether CloudWatch alarms have at least one alarm action, one INSUFFICIENT_DATA action, or one OK action enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-alarm-action-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.CLOUDWATCH_ALARM_ACTION_CHECK = 'CLOUDWATCH_ALARM_ACTION_CHECK';
/**
 * Checks whether the specified resource type has a CloudWatch alarm for the specified metric.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-alarm-resource-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.CLOUDWATCH_ALARM_RESOURCE_CHECK = 'CLOUDWATCH_ALARM_RESOURCE_CHECK';
/**
 * Checks whether CloudWatch alarms with the given metric name have the specified settings.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-alarm-settings-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.CLOUDWATCH_ALARM_SETTINGS_CHECK = 'CLOUDWATCH_ALARM_SETTINGS_CHECK';
/**
 * Checks whether a log group in Amazon CloudWatch Logs is encrypted with a AWS Key Management Service (KMS) managed Customer Master Keys (CMK).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-log-group-encrypted.html
 * @stability stable
 */
ManagedRuleIdentifiers.CLOUDWATCH_LOG_GROUP_ENCRYPTED = 'CLOUDWATCH_LOG_GROUP_ENCRYPTED';
/**
 * Checks that key rotation is enabled for each key and matches to the key ID of the customer created customer master key (CMK).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cmk-backing-key-rotation-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.CMK_BACKING_KEY_ROTATION_ENABLED = 'CMK_BACKING_KEY_ROTATION_ENABLED';
/**
 * Checks whether the project contains environment variables AWS_ACCESS_KEY_ID and AWS_SECRET_ACCESS_KEY.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/codebuild-project-envvar-awscred-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.CODEBUILD_PROJECT_ENVVAR_AWSCRED_CHECK = 'CODEBUILD_PROJECT_ENVVAR_AWSCRED_CHECK';
/**
 * Checks whether the GitHub or Bitbucket source repository URL contains either personal access tokens or user name and password.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/codebuild-project-source-repo-url-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.CODEBUILD_PROJECT_SOURCE_REPO_URL_CHECK = 'CODEBUILD_PROJECT_SOURCE_REPO_URL_CHECK';
/**
 * Checks whether the first deployment stage of the AWS CodePipeline performs more than one deployment.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/codepipeline-deployment-count-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.CODEPIPELINE_DEPLOYMENT_COUNT_CHECK = 'CODEPIPELINE_DEPLOYMENT_COUNT_CHECK';
/**
 * Checks whether each stage in the AWS CodePipeline deploys to more than N times the number of the regions the AWS CodePipeline has deployed in all the previous combined stages, where N is the region fanout number.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/codepipeline-region-fanout-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.CODEPIPELINE_REGION_FANOUT_CHECK = 'CODEPIPELINE_REGION_FANOUT_CHECK';
/**
 * Checks whether Amazon CloudWatch LogGroup retention period is set to specific number of days.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cw-loggroup-retention-period-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.CW_LOGGROUP_RETENTION_PERIOD_CHECK = 'CW_LOGGROUP_RETENTION_PERIOD_CHECK';
/**
 * Checks that DynamoDB Accelerator (DAX) clusters are encrypted.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/dax-encryption-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.DAX_ENCRYPTION_ENABLED = 'DAX_ENCRYPTION_ENABLED';
/**
 * Checks whether RDS DB instances have backups enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/db-instance-backup-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.RDS_DB_INSTANCE_BACKUP_ENABLED = 'DB_INSTANCE_BACKUP_ENABLED';
/**
 * Checks instances for specified tenancy.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/desired-instance-tenancy.html
 * @stability stable
 */
ManagedRuleIdentifiers.EC2_DESIRED_INSTANCE_TENANCY = 'DESIRED_INSTANCE_TENANCY';
/**
 * Checks whether your EC2 instances are of the specified instance types.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/desired-instance-type.html
 * @stability stable
 */
ManagedRuleIdentifiers.EC2_DESIRED_INSTANCE_TYPE = 'DESIRED_INSTANCE_TYPE';
/**
 * Checks whether AWS Database Migration Service replication instances are public.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/dms-replication-not-public.html
 * @stability stable
 */
ManagedRuleIdentifiers.DMS_REPLICATION_NOT_PUBLIC = 'DMS_REPLICATION_NOT_PUBLIC';
/**
 * Checks whether Auto Scaling or On-Demand is enabled on your DynamoDB tables and/or global secondary indexes.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-autoscaling-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.DYNAMODB_AUTOSCALING_ENABLED = 'DYNAMODB_AUTOSCALING_ENABLED';
/**
 * Checks whether Amazon DynamoDB table is present in AWS Backup plans.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-in-backup-plan.html
 * @stability stable
 */
ManagedRuleIdentifiers.DYNAMODB_IN_BACKUP_PLAN = 'DYNAMODB_IN_BACKUP_PLAN';
/**
 * Checks that point in time recovery (PITR) is enabled for Amazon DynamoDB tables.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-pitr-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.DYNAMODB_PITR_ENABLED = 'DYNAMODB_PITR_ENABLED';
/**
 * Checks whether Amazon DynamoDB table is encrypted with AWS Key Management Service (KMS).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-table-encrypted-kms.html
 * @stability stable
 */
ManagedRuleIdentifiers.DYNAMODB_TABLE_ENCRYPTED_KMS = 'DYNAMODB_TABLE_ENCRYPTED_KMS';
/**
 * Checks whether the Amazon DynamoDB tables are encrypted and checks their status.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-table-encryption-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.DYNAMODB_TABLE_ENCRYPTION_ENABLED = 'DYNAMODB_TABLE_ENCRYPTION_ENABLED';
/**
 * Checks whether provisioned DynamoDB throughput is approaching the maximum limit for your account.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-throughput-limit-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.DYNAMODB_THROUGHPUT_LIMIT_CHECK = 'DYNAMODB_THROUGHPUT_LIMIT_CHECK';
/**
 * Checks if Amazon Elastic Block Store (Amazon EBS) volumes are added in backup plans of AWS Backup.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ebs-in-backup-plan.html
 * @stability stable
 */
ManagedRuleIdentifiers.EBS_IN_BACKUP_PLAN = 'EBS_IN_BACKUP_PLAN';
/**
 * Checks whether Amazon Elastic File System (Amazon EFS) file systems are added in the backup plans of AWS Backup.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/efs-in-backup-plan.html
 * @stability stable
 */
ManagedRuleIdentifiers.EFS_IN_BACKUP_PLAN = 'EFS_IN_BACKUP_PLAN';
/**
 * Check that Amazon Elastic Block Store (EBS) encryption is enabled by default.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-ebs-encryption-by-default.html
 * @stability stable
 */
ManagedRuleIdentifiers.EC2_EBS_ENCRYPTION_BY_DEFAULT = 'EC2_EBS_ENCRYPTION_BY_DEFAULT';
/**
 * Checks whether EBS optimization is enabled for your EC2 instances that can be EBS-optimized.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ebs-optimized-instance.html
 * @stability stable
 */
ManagedRuleIdentifiers.EBS_OPTIMIZED_INSTANCE = 'EBS_OPTIMIZED_INSTANCE';
/**
 * Checks whether Amazon Elastic Block Store snapshots are not publicly restorable.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ebs-snapshot-public-restorable-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.EBS_SNAPSHOT_PUBLIC_RESTORABLE_CHECK = 'EBS_SNAPSHOT_PUBLIC_RESTORABLE_CHECK';
/**
 * Checks whether detailed monitoring is enabled for EC2 instances.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-detailed-monitoring-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.EC2_INSTANCE_DETAILED_MONITORING_ENABLED = 'EC2_INSTANCE_DETAILED_MONITORING_ENABLED';
/**
 * Checks whether the Amazon EC2 instances in your account are managed by AWS Systems Manager.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-managed-by-systems-manager.html
 * @stability stable
 */
ManagedRuleIdentifiers.EC2_INSTANCE_MANAGED_BY_SSM = 'EC2_INSTANCE_MANAGED_BY_SSM';
/**
 * Checks whether Amazon Elastic Compute Cloud (Amazon EC2) instances have a public IP association.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-no-public-ip.html
 * @stability stable
 */
ManagedRuleIdentifiers.EC2_INSTANCE_NO_PUBLIC_IP = 'EC2_INSTANCE_NO_PUBLIC_IP';
/**
 * Checks whether your EC2 instances belong to a virtual private cloud (VPC).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-instances-in-vpc.html
 * @stability stable
 */
ManagedRuleIdentifiers.EC2_INSTANCES_IN_VPC = 'INSTANCES_IN_VPC';
/**
 * Checks that none of the specified applications are installed on the instance.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-applications-blacklisted.html
 * @stability stable
 */
ManagedRuleIdentifiers.EC2_MANAGED_INSTANCE_APPLICATIONS_BLOCKED = 'EC2_MANAGEDINSTANCE_APPLICATIONS_BLACKLISTED';
/**
 * Checks whether all of the specified applications are installed on the instance.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-applications-required.html
 * @stability stable
 */
ManagedRuleIdentifiers.EC2_MANAGED_INSTANCE_APPLICATIONS_REQUIRED = 'EC2_MANAGEDINSTANCE_APPLICATIONS_REQUIRED';
/**
 * Checks whether the compliance status of AWS Systems Manager association compliance is COMPLIANT or NON_COMPLIANT after the association execution on the instance.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-association-compliance-status-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.EC2_MANAGED_INSTANCE_ASSOCIATION_COMPLIANCE_STATUS_CHECK = 'EC2_MANAGEDINSTANCE_ASSOCIATION_COMPLIANCE_STATUS_CHECK';
/**
 * Checks whether instances managed by AWS Systems Manager are configured to collect blocked inventory types.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-inventory-blacklisted.html
 * @stability stable
 */
ManagedRuleIdentifiers.EC2_MANAGED_INSTANCE_INVENTORY_BLOCKED = 'EC2_MANAGEDINSTANCE_INVENTORY_BLACKLISTED';
/**
 * Checks whether the compliance status of the Amazon EC2 Systems Manager patch compliance is COMPLIANT or NON_COMPLIANT after the patch installation on the instance.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-patch-compliance-status-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.EC2_MANAGED_INSTANCE_PATCH_COMPLIANCE_STATUS_CHECK = 'EC2_MANAGEDINSTANCE_PATCH_COMPLIANCE_STATUS_CHECK';
/**
 * Checks whether EC2 managed instances have the desired configurations.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-platform-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.EC2_MANAGED_INSTANCE_PLATFORM_CHECK = 'EC2_MANAGEDINSTANCE_PLATFORM_CHECK';
/**
 * Checks that security groups are attached to Amazon Elastic Compute Cloud (Amazon EC2) instances or to an elastic network interface.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-security-group-attached-to-eni.html
 * @stability stable
 */
ManagedRuleIdentifiers.EC2_SECURITY_GROUP_ATTACHED_TO_ENI = 'EC2_SECURITY_GROUP_ATTACHED_TO_ENI';
/**
 * Checks whether there are instances stopped for more than the allowed number of days.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-stopped-instance.html
 * @stability stable
 */
ManagedRuleIdentifiers.EC2_STOPPED_INSTANCE = 'EC2_STOPPED_INSTANCE';
/**
 * Checks whether EBS volumes are attached to EC2 instances.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-volume-inuse-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.EC2_VOLUME_INUSE_CHECK = 'EC2_VOLUME_INUSE_CHECK';
/**
 * hecks whether Amazon Elastic File System (Amazon EFS) is configured to encrypt the file data using AWS Key Management Service (AWS KMS).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/efs-encrypted-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.EFS_ENCRYPTED_CHECK = 'EFS_ENCRYPTED_CHECK';
/**
 * Checks whether all Elastic IP addresses that are allocated to a VPC are attached to EC2 instances or in-use elastic network interfaces (ENIs).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/eip-attached.html
 * @stability stable
 */
ManagedRuleIdentifiers.EIP_ATTACHED = 'EIP_ATTACHED';
/**
 * Checks whether Amazon Elasticsearch Service (Amazon ES) domains have encryption at rest configuration enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elasticsearch-encrypted-at-rest.html
 * @stability stable
 */
ManagedRuleIdentifiers.ELASTICSEARCH_ENCRYPTED_AT_REST = 'ELASTICSEARCH_ENCRYPTED_AT_REST';
/**
 * Checks whether Amazon Elasticsearch Service (Amazon ES) domains are in Amazon Virtual Private Cloud (Amazon VPC).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elasticsearch-in-vpc-only.html
 * @stability stable
 */
ManagedRuleIdentifiers.ELASTICSEARCH_IN_VPC_ONLY = 'ELASTICSEARCH_IN_VPC_ONLY';
/**
 * Check if the Amazon ElastiCache Redis clusters have automatic backup turned on.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elasticache-redis-cluster-automatic-backup-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.ELASTICACHE_REDIS_CLUSTER_AUTOMATIC_BACKUP_CHECK = 'ELASTICACHE_REDIS_CLUSTER_AUTOMATIC_BACKUP_CHECK';
/**
 * Checks whether your Amazon Elastic Compute Cloud (Amazon EC2) instance metadata version is configured with Instance Metadata Service Version 2 (IMDSv2).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-imdsv2-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.EC2_IMDSV2_CHECK = 'EC2_IMDSV2_CHECK';
/**
 * Checks whether Amazon Elastic Kubernetes Service (Amazon EKS) endpoint is not publicly accessible.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/eks-endpoint-no-public-access.html
 * @stability stable
 */
ManagedRuleIdentifiers.EKS_ENDPOINT_NO_PUBLIC_ACCESS = 'EKS_ENDPOINT_NO_PUBLIC_ACCESS';
/**
 * Checks whether Amazon Elastic Kubernetes Service clusters are configured to have Kubernetes secrets encrypted using AWS Key Management Service (KMS) keys.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/eks-secrets-encrypted.html
 * @stability stable
 */
ManagedRuleIdentifiers.EKS_SECRETS_ENCRYPTED = 'EKS_SECRETS_ENCRYPTED';
/**
 * Check that Amazon ElasticSearch Service nodes are encrypted end to end.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elasticsearch-node-to-node-encryption-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.ELASTICSEARCH_NODE_TO_NODE_ENCRYPTION_CHECK = 'ELASTICSEARCH_NODE_TO_NODE_ENCRYPTION_CHECK';
/**
 * Checks if cross-zone load balancing is enabled for the Classic Load Balancers (CLBs).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elb-cross-zone-load-balancing-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.ELB_CROSS_ZONE_LOAD_BALANCING_ENABLED = 'ELB_CROSS_ZONE_LOAD_BALANCING_ENABLED';
/**
 * Checks whether your Classic Load Balancer is configured with SSL or HTTPS listeners.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elb-tls-https-listeners-only.html
 * @stability stable
 */
ManagedRuleIdentifiers.ELB_TLS_HTTPS_LISTENERS_ONLY = 'ELB_TLS_HTTPS_LISTENERS_ONLY';
/**
 * Checks whether the Classic Load Balancers use SSL certificates provided by AWS Certificate Manager.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elb-acm-certificate-required.html
 * @stability stable
 */
ManagedRuleIdentifiers.ELB_ACM_CERTIFICATE_REQUIRED = 'ELB_ACM_CERTIFICATE_REQUIRED';
/**
 * Checks whether your Classic Load Balancer SSL listeners are using a custom policy.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elb-custom-security-policy-ssl-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.ELB_CUSTOM_SECURITY_POLICY_SSL_CHECK = 'ELB_CUSTOM_SECURITY_POLICY_SSL_CHECK';
/**
 * Checks whether Elastic Load Balancing has deletion protection enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elb-deletion-protection-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.ELB_DELETION_PROTECTION_ENABLED = 'ELB_DELETION_PROTECTION_ENABLED';
/**
 * Checks whether the Application Load Balancer and the Classic Load Balancer have logging enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elb-logging-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.ELB_LOGGING_ENABLED = 'ELB_LOGGING_ENABLED';
/**
 * Checks whether your Classic Load Balancer SSL listeners are using a predefined policy.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elb-predefined-security-policy-ssl-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.ELB_PREDEFINED_SECURITY_POLICY_SSL_CHECK = 'ELB_PREDEFINED_SECURITY_POLICY_SSL_CHECK';
/**
 * Checks that Amazon EMR clusters have Kerberos enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/emr-kerberos-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.EMR_KERBEROS_ENABLED = 'EMR_KERBEROS_ENABLED';
/**
 * Checks whether Amazon Elastic MapReduce (EMR) clusters' master nodes have public IPs.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/emr-master-no-public-ip.html
 * @stability stable
 */
ManagedRuleIdentifiers.EMR_MASTER_NO_PUBLIC_IP = 'EMR_MASTER_NO_PUBLIC_IP';
/**
 * Checks whether the EBS volumes that are in an attached state are encrypted.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/encrypted-volumes.html
 * @stability stable
 */
ManagedRuleIdentifiers.EBS_ENCRYPTED_VOLUMES = 'ENCRYPTED_VOLUMES';
/**
 * Checks whether the security groups associated inScope resources are compliant with the master security groups at each rule level based on allowSecurityGroup and denySecurityGroup flag.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/fms-security-group-audit-policy-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.FMS_SECURITY_GROUP_AUDIT_POLICY_CHECK = 'FMS_SECURITY_GROUP_AUDIT_POLICY_CHECK';
/**
 * Checks whether AWS Firewall Manager created security groups content is the same as the master security groups.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/fms-security-group-content-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.FMS_SECURITY_GROUP_CONTENT_CHECK = 'FMS_SECURITY_GROUP_CONTENT_CHECK';
/**
 * Checks whether Amazon EC2 or an elastic network interface is associated with AWS Firewall Manager security groups.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/fms-security-group-resource-association-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.FMS_SECURITY_GROUP_RESOURCE_ASSOCIATION_CHECK = 'FMS_SECURITY_GROUP_RESOURCE_ASSOCIATION_CHECK';
/**
 * Checks whether an Application Load Balancer, Amazon CloudFront distributions, Elastic Load Balancer or Elastic IP has AWS Shield protection.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/fms-shield-resource-policy-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.FMS_SHIELD_RESOURCE_POLICY_CHECK = 'FMS_SHIELD_RESOURCE_POLICY_CHECK';
/**
 * Checks whether the web ACL is associated with an Application Load Balancer, API Gateway stage, or Amazon CloudFront distributions.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/fms-webacl-resource-policy-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.FMS_WEBACL_RESOURCE_POLICY_CHECK = 'FMS_WEBACL_RESOURCE_POLICY_CHECK';
/**
 * Checks that the rule groups associate with the web ACL at the correct priority.
 *
 * The correct priority is decided by the rank of the rule groups in the ruleGroups parameter.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/fms-webacl-rulegroup-association-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.FMS_WEBACL_RULEGROUP_ASSOCIATION_CHECK = 'FMS_WEBACL_RULEGROUP_ASSOCIATION_CHECK';
/**
 * Checks whether Amazon GuardDuty is enabled in your AWS account and region.
 *
 * If you provide an AWS account for centralization,
 * the rule evaluates the Amazon GuardDuty results in the centralized account.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/guardduty-enabled-centralized.html
 * @stability stable
 */
ManagedRuleIdentifiers.GUARDDUTY_ENABLED_CENTRALIZED = 'GUARDDUTY_ENABLED_CENTRALIZED';
/**
 * Checks whether the Amazon GuardDuty has findings that are non archived.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/guardduty-non-archived-findings.html
 * @stability stable
 */
ManagedRuleIdentifiers.GUARDDUTY_NON_ARCHIVED_FINDINGS = 'GUARDDUTY_NON_ARCHIVED_FINDINGS';
/**
 * Checks that inline policy feature is not in use.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-no-inline-policy-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.IAM_NO_INLINE_POLICY_CHECK = 'IAM_NO_INLINE_POLICY_CHECK';
/**
 * Checks whether IAM groups have at least one IAM user.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-group-has-users-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.IAM_GROUP_HAS_USERS_CHECK = 'IAM_GROUP_HAS_USERS_CHECK';
/**
 * Checks whether the account password policy for IAM users meets the specified requirements indicated in the parameters.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-password-policy.html
 * @stability stable
 */
ManagedRuleIdentifiers.IAM_PASSWORD_POLICY = 'IAM_PASSWORD_POLICY';
/**
 * Checks whether for each IAM resource, a policy ARN in the input parameter is attached to the IAM resource.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-policy-blacklisted-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.IAM_POLICY_BLOCKED_CHECK = 'IAM_POLICY_BLACKLISTED_CHECK';
/**
 * Checks whether the IAM policy ARN is attached to an IAM user, or an IAM group with one or more IAM users, or an IAM role with one or more trusted entity.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-policy-in-use.html
 * @stability stable
 */
ManagedRuleIdentifiers.IAM_POLICY_IN_USE = 'IAM_POLICY_IN_USE';
/**
 * Checks the IAM policies that you create for Allow statements that grant permissions to all actions on all resources.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-policy-no-statements-with-admin-access.html
 * @stability stable
 */
ManagedRuleIdentifiers.IAM_POLICY_NO_STATEMENTS_WITH_ADMIN_ACCESS = 'IAM_POLICY_NO_STATEMENTS_WITH_ADMIN_ACCESS';
/**
 * Checks that AWS Identity and Access Management (IAM) policies in a list of policies are attached to all AWS roles.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-role-managed-policy-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.IAM_ROLE_MANAGED_POLICY_CHECK = 'IAM_ROLE_MANAGED_POLICY_CHECK';
/**
 * Checks whether the root user access key is available.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-root-access-key-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.IAM_ROOT_ACCESS_KEY_CHECK = 'IAM_ROOT_ACCESS_KEY_CHECK';
/**
 * Checks whether IAM users are members of at least one IAM group.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-user-group-membership-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.IAM_USER_GROUP_MEMBERSHIP_CHECK = 'IAM_USER_GROUP_MEMBERSHIP_CHECK';
/**
 * Checks whether the AWS Identity and Access Management users have multi-factor authentication (MFA) enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-user-mfa-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.IAM_USER_MFA_ENABLED = 'IAM_USER_MFA_ENABLED';
/**
 * Checks that none of your IAM users have policies attached.
 *
 * IAM users must inherit permissions from IAM groups or roles.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-user-no-policies-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.IAM_USER_NO_POLICIES_CHECK = 'IAM_USER_NO_POLICIES_CHECK';
/**
 * Checks whether your AWS Identity and Access Management (IAM) users have passwords or active access keys that have not been used within the specified number of days you provided.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-user-unused-credentials-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.IAM_USER_UNUSED_CREDENTIALS_CHECK = 'IAM_USER_UNUSED_CREDENTIALS_CHECK';
/**
 * Checks that Internet gateways (IGWs) are only attached to an authorized Amazon Virtual Private Cloud (VPCs).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/internet-gateway-authorized-vpc-only.html
 * @stability stable
 */
ManagedRuleIdentifiers.INTERNET_GATEWAY_AUTHORIZED_VPC_ONLY = 'INTERNET_GATEWAY_AUTHORIZED_VPC_ONLY';
/**
 * Checks whether customer master keys (CMKs) are not scheduled for deletion in AWS Key Management Service (KMS).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/kms-cmk-not-scheduled-for-deletion.html
 * @stability stable
 */
ManagedRuleIdentifiers.KMS_CMK_NOT_SCHEDULED_FOR_DELETION = 'KMS_CMK_NOT_SCHEDULED_FOR_DELETION';
/**
 * Checks whether the AWS Lambda function is configured with function-level concurrent execution limit.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/lambda-concurrency-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.LAMBDA_CONCURRENCY_CHECK = 'LAMBDA_CONCURRENCY_CHECK';
/**
 * Checks whether an AWS Lambda function is configured with a dead-letter queue.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/lambda-dlq-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.LAMBDA_DLQ_CHECK = 'LAMBDA_DLQ_CHECK';
/**
 * Checks whether the AWS Lambda function policy attached to the Lambda resource prohibits public access.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/lambda-function-public-access-prohibited.html
 * @stability stable
 */
ManagedRuleIdentifiers.LAMBDA_FUNCTION_PUBLIC_ACCESS_PROHIBITED = 'LAMBDA_FUNCTION_PUBLIC_ACCESS_PROHIBITED';
/**
 * Checks that the lambda function settings for runtime, role, timeout, and memory size match the expected values.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/lambda-function-settings-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.LAMBDA_FUNCTION_SETTINGS_CHECK = 'LAMBDA_FUNCTION_SETTINGS_CHECK';
/**
 * Checks whether an AWS Lambda function is in an Amazon Virtual Private Cloud.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/lambda-inside-vpc.html
 * @stability stable
 */
ManagedRuleIdentifiers.LAMBDA_INSIDE_VPC = 'LAMBDA_INSIDE_VPC';
/**
 * Checks whether AWS Multi-Factor Authentication (MFA) is enabled for all IAM users that use a console password.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/mfa-enabled-for-iam-console-access.html
 * @stability stable
 */
ManagedRuleIdentifiers.MFA_ENABLED_FOR_IAM_CONSOLE_ACCESS = 'MFA_ENABLED_FOR_IAM_CONSOLE_ACCESS';
/**
 * Checks that there is at least one multi-region AWS CloudTrail.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/multi-region-cloudtrail-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.CLOUDTRAIL_MULTI_REGION_ENABLED = 'MULTI_REGION_CLOUD_TRAIL_ENABLED';
/**
 * Checks if an Amazon Relational Database Service (Amazon RDS) cluster has deletion protection enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-cluster-deletion-protection-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.RDS_CLUSTER_DELETION_PROTECTION_ENABLED = 'RDS_CLUSTER_DELETION_PROTECTION_ENABLED';
/**
 * Checks if an Amazon Relational Database Service (Amazon RDS) instance has deletion protection enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-instance-deletion-protection-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.RDS_INSTANCE_DELETION_PROTECTION_ENABLED = 'RDS_INSTANCE_DELETION_PROTECTION_ENABLED';
/**
 * Checks if an Amazon RDS instance has AWS Identity and Access Management (IAM) authentication enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-instance-iam-authentication-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.RDS_INSTANCE_IAM_AUTHENTICATION_ENABLED = 'RDS_INSTANCE_IAM_AUTHENTICATION_ENABLED';
/**
 * Checks that respective logs of Amazon Relational Database Service (Amazon RDS) are enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-logging-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.RDS_LOGGING_ENABLED = 'RDS_LOGGING_ENABLED';
/**
 * Checks that Amazon Redshift automated snapshots are enabled for clusters.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/redshift-backup-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.REDSHIFT_BACKUP_ENABLED = 'REDSHIFT_BACKUP_ENABLED';
/**
 * Checks whether enhanced monitoring is enabled for Amazon Relational Database Service (Amazon RDS) instances.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-enhanced-monitoring-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.RDS_ENHANCED_MONITORING_ENABLED = 'RDS_ENHANCED_MONITORING_ENABLED';
/**
 * Checks whether Amazon Relational Database Service (Amazon RDS) DB snapshots are encrypted.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-snapshot-encrypted.html
 * @stability stable
 */
ManagedRuleIdentifiers.RDS_SNAPSHOT_ENCRYPTED = 'RDS_SNAPSHOT_ENCRYPTED';
/**
 * Checks whether Amazon Redshift clusters require TLS/SSL encryption to connect to SQL clients.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/redshift-require-tls-ssl.html
 * @stability stable
 */
ManagedRuleIdentifiers.REDSHIFT_REQUIRE_TLS_SSL = 'REDSHIFT_REQUIRE_TLS_SSL';
/**
 * Checks whether Amazon RDS database is present in back plans of AWS Backup.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-in-backup-plan.html
 * @stability stable
 */
ManagedRuleIdentifiers.RDS_IN_BACKUP_PLAN = 'RDS_IN_BACKUP_PLAN';
/**
 * Check whether the Amazon Relational Database Service instances are not publicly accessible.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-instance-public-access-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.RDS_INSTANCE_PUBLIC_ACCESS_CHECK = 'RDS_INSTANCE_PUBLIC_ACCESS_CHECK';
/**
 * Checks whether high availability is enabled for your RDS DB instances.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-multi-az-support.html
 * @stability stable
 */
ManagedRuleIdentifiers.RDS_MULTI_AZ_SUPPORT = 'RDS_MULTI_AZ_SUPPORT';
/**
 * Checks if Amazon Relational Database Service (Amazon RDS) snapshots are public.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-snapshots-public-prohibited.html
 * @stability stable
 */
ManagedRuleIdentifiers.RDS_SNAPSHOTS_PUBLIC_PROHIBITED = 'RDS_SNAPSHOTS_PUBLIC_PROHIBITED';
/**
 * Checks whether storage encryption is enabled for your RDS DB instances.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-storage-encrypted.html
 * @stability stable
 */
ManagedRuleIdentifiers.RDS_STORAGE_ENCRYPTED = 'RDS_STORAGE_ENCRYPTED';
/**
 * Checks whether Amazon Redshift clusters have the specified settings.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/redshift-cluster-configuration-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.REDSHIFT_CLUSTER_CONFIGURATION_CHECK = 'REDSHIFT_CLUSTER_CONFIGURATION_CHECK';
/**
 * Checks whether Amazon Redshift clusters have the specified maintenance settings.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/redshift-cluster-maintenancesettings-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.REDSHIFT_CLUSTER_MAINTENANCE_SETTINGS_CHECK = 'REDSHIFT_CLUSTER_MAINTENANCESETTINGS_CHECK';
/**
 * Checks whether Amazon Redshift clusters are not publicly accessible.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/redshift-cluster-public-access-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.REDSHIFT_CLUSTER_PUBLIC_ACCESS_CHECK = 'REDSHIFT_CLUSTER_PUBLIC_ACCESS_CHECK';
/**
 * Checks whether your resources have the tags that you specify.
 *
 * For example, you can check whether your Amazon EC2 instances have the CostCenter tag.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/required-tags.html
 * @stability stable
 */
ManagedRuleIdentifiers.REQUIRED_TAGS = 'REQUIRED_TAGS';
/**
 * Checks whether the security groups in use do not allow unrestricted incoming TCP traffic to the specified ports.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/restricted-common-ports.html
 * @stability stable
 */
ManagedRuleIdentifiers.EC2_SECURITY_GROUPS_RESTRICTED_INCOMING_TRAFFIC = 'RESTRICTED_INCOMING_TRAFFIC';
/**
 * Checks whether the incoming SSH traffic for the security groups is accessible.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/restricted-ssh.html
 * @stability stable
 */
ManagedRuleIdentifiers.EC2_SECURITY_GROUPS_INCOMING_SSH_DISABLED = 'INCOMING_SSH_DISABLED';
/**
 * Checks whether your AWS account is enabled to use multi-factor authentication (MFA) hardware device to sign in with root credentials.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/root-account-hardware-mfa-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.ROOT_ACCOUNT_HARDWARE_MFA_ENABLED = 'ROOT_ACCOUNT_HARDWARE_MFA_ENABLED';
/**
 * Checks whether users of your AWS account require a multi-factor authentication (MFA) device to sign in with root credentials.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/root-account-mfa-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.ROOT_ACCOUNT_MFA_ENABLED = 'ROOT_ACCOUNT_MFA_ENABLED';
/**
 * Checks whether Amazon Simple Storage Service (Amazon S3) bucket has lock enabled, by default.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-default-lock-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.S3_BUCKET_DEFAULT_LOCK_ENABLED = 'S3_BUCKET_DEFAULT_LOCK_ENABLED';
/**
 * Checks whether the Amazon Simple Storage Service (Amazon S3) buckets are encrypted with AWS Key Management Service (AWS KMS).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-default-encryption-kms.html
 * @stability stable
 */
ManagedRuleIdentifiers.S3_DEFAULT_ENCRYPTION_KMS = 'S3_DEFAULT_ENCRYPTION_KMS';
/**
 * Checks that AWS Security Hub is enabled for an AWS account.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/securityhub-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.SECURITYHUB_ENABLED = 'SECURITYHUB_ENABLED';
/**
 * Checks whether Amazon SNS topic is encrypted with AWS Key Management Service (AWS KMS).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/sns-encrypted-kms.html
 * @stability stable
 */
ManagedRuleIdentifiers.SNS_ENCRYPTED_KMS = 'SNS_ENCRYPTED_KMS';
/**
 * Checks whether the required public access block settings are configured from account level.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-account-level-public-access-blocks.html
 * @stability stable
 */
ManagedRuleIdentifiers.S3_ACCOUNT_LEVEL_PUBLIC_ACCESS_BLOCKS = 'S3_ACCOUNT_LEVEL_PUBLIC_ACCESS_BLOCKS';
/**
 * Checks that the Amazon Simple Storage Service bucket policy does not allow blocked bucket-level and object-level actions on resources in the bucket for principals from other AWS accounts.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-blacklisted-actions-prohibited.html
 * @stability stable
 */
ManagedRuleIdentifiers.S3_BUCKET_BLOCKED_ACTIONS_PROHIBITED = 'S3_BUCKET_BLACKLISTED_ACTIONS_PROHIBITED';
/**
 * Verifies that your Amazon Simple Storage Service bucket policies do not allow other inter-account permissions than the control Amazon S3 bucket policy provided.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy-not-more-permissive.html
 * @stability stable
 */
ManagedRuleIdentifiers.S3_BUCKET_POLICY_NOT_MORE_PERMISSIVE = 'S3_BUCKET_POLICY_NOT_MORE_PERMISSIVE';
/**
 * Checks whether logging is enabled for your S3 buckets.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-logging-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.S3_BUCKET_LOGGING_ENABLED = 'S3_BUCKET_LOGGING_ENABLED';
/**
 * Checks that the access granted by the Amazon S3 bucket is restricted by any of the AWS principals, federated users, service principals, IP addresses, or VPCs that you provide.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy-grantee-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.S3_BUCKET_POLICY_GRANTEE_CHECK = 'S3_BUCKET_POLICY_GRANTEE_CHECK';
/**
 * Checks that your Amazon S3 buckets do not allow public read access.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-public-read-prohibited.html
 * @stability stable
 */
ManagedRuleIdentifiers.S3_BUCKET_PUBLIC_READ_PROHIBITED = 'S3_BUCKET_PUBLIC_READ_PROHIBITED';
/**
 * Checks that your Amazon S3 buckets do not allow public write access.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-public-write-prohibited.html
 * @stability stable
 */
ManagedRuleIdentifiers.S3_BUCKET_PUBLIC_WRITE_PROHIBITED = 'S3_BUCKET_PUBLIC_WRITE_PROHIBITED';
/**
 * Checks whether S3 buckets have cross-region replication enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-replication-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.S3_BUCKET_REPLICATION_ENABLED = 'S3_BUCKET_REPLICATION_ENABLED';
/**
 * Checks that your Amazon S3 bucket either has Amazon S3 default encryption enabled or that the S3 bucket policy explicitly denies put-object requests without server side encryption that uses AES-256 or AWS Key Management Service.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-server-side-encryption-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.S3_BUCKET_SERVER_SIDE_ENCRYPTION_ENABLED = 'S3_BUCKET_SERVER_SIDE_ENCRYPTION_ENABLED';
/**
 * Checks whether S3 buckets have policies that require requests to use Secure Socket Layer (SSL).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-ssl-requests-only.html
 * @stability stable
 */
ManagedRuleIdentifiers.S3_BUCKET_SSL_REQUESTS_ONLY = 'S3_BUCKET_SSL_REQUESTS_ONLY';
/**
 * Checks whether versioning is enabled for your S3 buckets.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-versioning-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.S3_BUCKET_VERSIONING_ENABLED = 'S3_BUCKET_VERSIONING_ENABLED';
/**
 * Checks whether AWS Key Management Service (KMS) key is configured for an Amazon SageMaker endpoint configuration.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/sagemaker-endpoint-configuration-kms-key-configured.html
 * @stability stable
 */
ManagedRuleIdentifiers.SAGEMAKER_ENDPOINT_CONFIGURATION_KMS_KEY_CONFIGURED = 'SAGEMAKER_ENDPOINT_CONFIGURATION_KMS_KEY_CONFIGURED';
/**
 * Check whether an AWS Key Management Service (KMS) key is configured for SageMaker notebook instance.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/sagemaker-notebook-instance-kms-key-configured.html
 * @stability stable
 */
ManagedRuleIdentifiers.SAGEMAKER_NOTEBOOK_INSTANCE_KMS_KEY_CONFIGURED = 'SAGEMAKER_NOTEBOOK_INSTANCE_KMS_KEY_CONFIGURED';
/**
 * Checks whether direct internet access is disabled for an Amazon SageMaker notebook instance.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/sagemaker-notebook-no-direct-internet-access.html
 * @stability stable
 */
ManagedRuleIdentifiers.SAGEMAKER_NOTEBOOK_NO_DIRECT_INTERNET_ACCESS = 'SAGEMAKER_NOTEBOOK_NO_DIRECT_INTERNET_ACCESS';
/**
 * Checks whether AWS Secrets Manager secret has rotation enabled.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/secretsmanager-rotation-enabled-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.SECRETSMANAGER_ROTATION_ENABLED_CHECK = 'SECRETSMANAGER_ROTATION_ENABLED_CHECK';
/**
 * Checks whether AWS Secrets Manager secret rotation has rotated successfully as per the rotation schedule.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/secretsmanager-scheduled-rotation-success-check.html
 * @stability stable
 */
ManagedRuleIdentifiers.SECRETSMANAGER_SCHEDULED_ROTATION_SUCCESS_CHECK = 'SECRETSMANAGER_SCHEDULED_ROTATION_SUCCESS_CHECK';
/**
 * Checks whether Service Endpoint for the service provided in rule parameter is created for each Amazon VPC.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/service-vpc-endpoint-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.SERVICE_VPC_ENDPOINT_ENABLED = 'SERVICE_VPC_ENDPOINT_ENABLED';
/**
 * Checks whether EBS volumes are attached to EC2 instances.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/shield-advanced-enabled-autorenew.html
 * @stability stable
 */
ManagedRuleIdentifiers.SHIELD_ADVANCED_ENABLED_AUTO_RENEW = 'SHIELD_ADVANCED_ENABLED_AUTORENEW';
/**
 * Verify that DDoS response team (DRT) can access AWS account.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/shield-drt-access.html
 * @stability stable
 */
ManagedRuleIdentifiers.SHIELD_DRT_ACCESS = 'SHIELD_DRT_ACCESS';
/**
 * Checks that the default security group of any Amazon Virtual Private Cloud (VPC) does not allow inbound or outbound traffic.
 *
 * The rule returns NOT_APPLICABLE if the security group
 * is not default.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/vpc-default-security-group-closed.html
 * @stability stable
 */
ManagedRuleIdentifiers.VPC_DEFAULT_SECURITY_GROUP_CLOSED = 'VPC_DEFAULT_SECURITY_GROUP_CLOSED';
/**
 * Checks whether Amazon Virtual Private Cloud flow logs are found and enabled for Amazon VPC.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/vpc-flow-logs-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.VPC_FLOW_LOGS_ENABLED = 'VPC_FLOW_LOGS_ENABLED';
/**
 * Checks whether the security group with 0.0.0.0/0 of any Amazon Virtual Private Cloud (Amazon VPC) allows only specific inbound TCP or UDP traffic.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/vpc-sg-open-only-to-authorized-ports.html
 * @stability stable
 */
ManagedRuleIdentifiers.VPC_SG_OPEN_ONLY_TO_AUTHORIZED_PORTS = 'VPC_SG_OPEN_ONLY_TO_AUTHORIZED_PORTS';
/**
 * Checks that both AWS Virtual Private Network tunnels provided by AWS Site-to-Site VPN are in UP status.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/vpc-vpn-2-tunnels-up.html
 * @stability stable
 */
ManagedRuleIdentifiers.VPC_VPN_2_TUNNELS_UP = 'VPC_VPN_2_TUNNELS_UP';
/**
 * Checks if logging is enabled on AWS Web Application Firewall (WAF) classic global web ACLs.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/waf-classic-logging-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.WAF_CLASSIC_LOGGING_ENABLED = 'WAF_CLASSIC_LOGGING_ENABLED';
/**
 * Checks whether logging is enabled on AWS Web Application Firewall (WAFV2) regional and global web access control list (ACLs).
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/wafv2-logging-enabled.html
 * @stability stable
 */
ManagedRuleIdentifiers.WAFV2_LOGGING_ENABLED = 'WAFV2_LOGGING_ENABLED';
/**
 * Resources types that are supported by AWS Config.
 *
 * @see https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html
 * @stability stable
 */
class ResourceType {
    constructor(type) {
        this.complianceResourceType = type;
    }
    /**
     * A custom resource type to support future cases.
     *
     * @stability stable
     */
    static of(type) {
        return new ResourceType(type);
    }
}
exports.ResourceType = ResourceType;
_e = JSII_RTTI_SYMBOL_1;
ResourceType[_e] = { fqn: "@aws-cdk/aws-config.ResourceType", version: "1.114.0" };
/**
 * API Gateway Stage.
 *
 * @stability stable
 */
ResourceType.APIGATEWAY_STAGE = new ResourceType('AWS::ApiGateway::Stage');
/**
 * API Gatewayv2 Stage.
 *
 * @stability stable
 */
ResourceType.APIGATEWAYV2_STAGE = new ResourceType('AWS::ApiGatewayV2::Stage');
/**
 * API Gateway REST API.
 *
 * @stability stable
 */
ResourceType.APIGATEWAY_REST_API = new ResourceType('AWS::ApiGateway::RestApi');
/**
 * API Gatewayv2 API.
 *
 * @stability stable
 */
ResourceType.APIGATEWAYV2_API = new ResourceType('AWS::ApiGatewayV2::Api');
/**
 * Amazon CloudFront Distribution.
 *
 * @stability stable
 */
ResourceType.CLOUDFRONT_DISTRIBUTION = new ResourceType('AWS::CloudFront::Distribution');
/**
 * Amazon CloudFront streaming distribution.
 *
 * @stability stable
 */
ResourceType.CLOUDFRONT_STREAMING_DISTRIBUTION = new ResourceType('AWS::CloudFront::StreamingDistribution');
/**
 * Amazon CloudWatch Alarm.
 *
 * @stability stable
 */
ResourceType.CLOUDWATCH_ALARM = new ResourceType('AWS::CloudWatch::Alarm');
/**
 * Amazon DynamoDB Table.
 *
 * @stability stable
 */
ResourceType.DYNAMODB_TABLE = new ResourceType('AWS::DynamoDB::Table');
/**
 * Elastic Block Store (EBS) volume.
 *
 * @stability stable
 */
ResourceType.EBS_VOLUME = new ResourceType('AWS::EC2::Volume');
/**
 * EC2 host.
 *
 * @stability stable
 */
ResourceType.EC2_HOST = new ResourceType('AWS::EC2::Host');
/**
 * EC2 Elastic IP.
 *
 * @stability stable
 */
ResourceType.EC2_EIP = new ResourceType('AWS::EC2::EIP');
/**
 * EC2 instance.
 *
 * @stability stable
 */
ResourceType.EC2_INSTANCE = new ResourceType('AWS::EC2::Instance');
/**
 * EC2 security group.
 *
 * @stability stable
 */
ResourceType.EC2_SECURITY_GROUP = new ResourceType('AWS::EC2::SecurityGroup');
/**
 * EC2 NAT gateway.
 *
 * @stability stable
 */
ResourceType.EC2_NAT_GATEWAY = new ResourceType('AWS::EC2::NatGateway');
/**
 * EC2 Egress only internet gateway.
 *
 * @stability stable
 */
ResourceType.EC2_EGRESS_ONLY_INTERNET_GATEWAY = new ResourceType('AWS::EC2::EgressOnlyInternetGateway');
/**
 * EC2 flow log.
 *
 * @stability stable
 */
ResourceType.EC2_FLOW_LOG = new ResourceType('AWS::EC2::FlowLog');
/**
 * EC2 VPC endpoint.
 *
 * @stability stable
 */
ResourceType.EC2_VPC_ENDPOINT = new ResourceType('AWS::EC2::VPCEndpoint');
/**
 * EC2 VPC endpoint service.
 *
 * @stability stable
 */
ResourceType.EC2_VPC_ENDPOINT_SERVICE = new ResourceType('AWS::EC2::VPCEndpointService');
/**
 * EC2 VPC peering connection.
 *
 * @stability stable
 */
ResourceType.EC2_VPC_PEERING_CONNECTION = new ResourceType('AWS::EC2::VPCPeeringConnection');
/**
 * Amazon ElasticSearch domain.
 *
 * @stability stable
 */
ResourceType.ELASTICSEARCH_DOMAIN = new ResourceType('AWS::Elasticsearch::Domain');
/**
 * Amazon QLDB ledger.
 *
 * @stability stable
 */
ResourceType.QLDB_LEDGER = new ResourceType('AWS::QLDB::Ledger');
/**
 * Amazon Redshift cluster.
 *
 * @stability stable
 */
ResourceType.REDSHIFT_CLUSTER = new ResourceType('AWS::Redshift::Cluster');
/**
 * Amazon Redshift cluster parameter group.
 *
 * @stability stable
 */
ResourceType.REDSHIFT_CLUSTER_PARAMETER_GROUP = new ResourceType('AWS::Redshift::ClusterParameterGroup');
/**
 * Amazon Redshift cluster security group.
 *
 * @stability stable
 */
ResourceType.REDSHIFT_CLUSTER_SECURITY_GROUP = new ResourceType('AWS::Redshift::ClusterSecurityGroup');
/**
 * Amazon Redshift cluster snapshot.
 *
 * @stability stable
 */
ResourceType.REDSHIFT_CLUSTER_SNAPSHOT = new ResourceType('AWS::Redshift::ClusterSnapshot');
/**
 * Amazon Redshift cluster subnet group.
 *
 * @stability stable
 */
ResourceType.REDSHIFT_CLUSTER_SUBNET_GROUP = new ResourceType('AWS::Redshift::ClusterSubnetGroup');
/**
 * Amazon Redshift event subscription.
 *
 * @stability stable
 */
ResourceType.REDSHIFT_EVENT_SUBSCRIPTION = new ResourceType('AWS::Redshift::EventSubscription');
/**
 * Amazon RDS database instance.
 *
 * @stability stable
 */
ResourceType.RDS_DB_INSTANCE = new ResourceType('AWS::RDS::DBInstance');
/**
 * Amazon RDS database security group.
 *
 * @stability stable
 */
ResourceType.RDS_DB_SECURITY_GROUP = new ResourceType('AWS::RDS::DBSecurityGroup');
/**
 * Amazon RDS database snapshot.
 *
 * @stability stable
 */
ResourceType.RDS_DB_SNAPSHOT = new ResourceType('AWS::RDS::DBSnapshot');
/**
 * Amazon RDS database subnet group.
 *
 * @stability stable
 */
ResourceType.RDS_DB_SUBNET_GROUP = new ResourceType('AWS::RDS::DBSubnetGroup');
/**
 * Amazon RDS event subscription.
 *
 * @stability stable
 */
ResourceType.RDS_EVENT_SUBSCRIPTION = new ResourceType('AWS::RDS::EventSubscription');
/**
 * Amazon RDS database cluster.
 *
 * @stability stable
 */
ResourceType.RDS_DB_CLUSTER = new ResourceType('AWS::RDS::DBCluster');
/**
 * Amazon RDS database cluster snapshot.
 *
 * @stability stable
 */
ResourceType.RDS_DB_CLUSTER_SNAPSHOT = new ResourceType('AWS::RDS::DBClusterSnapshot');
/**
 * Amazon SQS queue.
 *
 * @stability stable
 */
ResourceType.SQS_QUEUE = new ResourceType('AWS::SQS::Queue');
/**
 * Amazon SNS topic.
 *
 * @stability stable
 */
ResourceType.SNS_TOPIC = new ResourceType('AWS::SNS::Topic');
/**
 * Amazon S3 bucket.
 *
 * @stability stable
 */
ResourceType.S3_BUCKET = new ResourceType('AWS::S3::Bucket');
/**
 * Amazon S3 account public access block.
 *
 * @stability stable
 */
ResourceType.S3_ACCOUNT_PUBLIC_ACCESS_BLOCK = new ResourceType('AWS::S3::AccountPublicAccessBlock');
/**
 * Amazon EC2 customer gateway.
 *
 * @stability stable
 */
ResourceType.EC2_CUSTOMER_GATEWAY = new ResourceType('AWS::EC2::CustomerGateway');
/**
 * Amazon EC2 internet gateway.
 *
 * @stability stable
 */
ResourceType.EC2_INTERNET_GATEWAY = new ResourceType('AWS::EC2::CustomerGateway');
/**
 * Amazon EC2 network ACL.
 *
 * @stability stable
 */
ResourceType.EC2_NETWORK_ACL = new ResourceType('AWS::EC2::NetworkAcl');
/**
 * Amazon EC2 route table.
 *
 * @stability stable
 */
ResourceType.EC2_ROUTE_TABLE = new ResourceType('AWS::EC2::RouteTable');
/**
 * Amazon EC2 subnet table.
 *
 * @stability stable
 */
ResourceType.EC2_SUBNET = new ResourceType('AWS::EC2::Subnet');
/**
 * Amazon EC2 VPC.
 *
 * @stability stable
 */
ResourceType.EC2_VPC = new ResourceType('AWS::EC2::VPC');
/**
 * Amazon EC2 VPN connection.
 *
 * @stability stable
 */
ResourceType.EC2_VPN_CONNECTION = new ResourceType('AWS::EC2::VPNConnection');
/**
 * Amazon EC2 VPN gateway.
 *
 * @stability stable
 */
ResourceType.EC2_VPN_GATEWAY = new ResourceType('AWS::EC2::VPNGateway');
/**
 * AWS Auto Scaling group.
 *
 * @stability stable
 */
ResourceType.AUTO_SCALING_GROUP = new ResourceType('AWS::AutoScaling::AutoScalingGroup');
/**
 * AWS Auto Scaling launch configuration.
 *
 * @stability stable
 */
ResourceType.AUTO_SCALING_LAUNCH_CONFIGURATION = new ResourceType('AWS::AutoScaling::LaunchConfiguration');
/**
 * AWS Auto Scaling policy.
 *
 * @stability stable
 */
ResourceType.AUTO_SCALING_POLICY = new ResourceType('AWS::AutoScaling::ScalingPolicy');
/**
 * AWS Auto Scaling scheduled action.
 *
 * @stability stable
 */
ResourceType.AUTO_SCALING_SCHEDULED_ACTION = new ResourceType('AWS::AutoScaling::ScheduledAction');
/**
 * AWS Certificate manager certificate.
 *
 * @stability stable
 */
ResourceType.ACM_CERTIFICATE = new ResourceType('AWS::ACM::Certificate');
/**
 * AWS CloudFormation stack.
 *
 * @stability stable
 */
ResourceType.CLOUDFORMATION_STACK = new ResourceType('AWS::CloudFormation::Stack');
/**
 * AWS CloudTrail trail.
 *
 * @stability stable
 */
ResourceType.CLOUDTRAIL_TRAIL = new ResourceType('AWS::CloudTrail::Trail');
/**
 * AWS CodeBuild project.
 *
 * @stability stable
 */
ResourceType.CODEBUILD_PROJECT = new ResourceType('AWS::CodeBuild::Project');
/**
 * AWS CodePipeline pipeline.
 *
 * @stability stable
 */
ResourceType.CODEPIPELINE_PIPELINE = new ResourceType('AWS::CodePipeline::Pipeline');
/**
 * AWS Elastic Beanstalk (EB) application.
 *
 * @stability stable
 */
ResourceType.ELASTIC_BEANSTALK_APPLICATION = new ResourceType('AWS::ElasticBeanstalk::Application');
/**
 * AWS Elastic Beanstalk (EB) application version.
 *
 * @stability stable
 */
ResourceType.ELASTIC_BEANSTALK_APPLICATION_VERSION = new ResourceType('AWS::ElasticBeanstalk::ApplicationVersion');
/**
 * AWS Elastic Beanstalk (EB) environment.
 *
 * @stability stable
 */
ResourceType.ELASTIC_BEANSTALK_ENVIRONMENT = new ResourceType('AWS::ElasticBeanstalk::Environment');
/**
 * AWS IAM user.
 *
 * @stability stable
 */
ResourceType.IAM_USER = new ResourceType('AWS::IAM::User');
/**
 * AWS IAM group.
 *
 * @stability stable
 */
ResourceType.IAM_GROUP = new ResourceType('AWS::IAM::Group');
/**
 * AWS IAM role.
 *
 * @stability stable
 */
ResourceType.IAM_ROLE = new ResourceType('AWS::IAM::Role');
/**
 * AWS IAM policy.
 *
 * @stability stable
 */
ResourceType.IAM_POLICY = new ResourceType('AWS::IAM::Policy');
/**
 * AWS KMS Key.
 *
 * @stability stable
 */
ResourceType.KMS_KEY = new ResourceType('AWS::KMS::Key');
/**
 * AWS Lambda function.
 *
 * @stability stable
 */
ResourceType.LAMBDA_FUNCTION = new ResourceType('AWS::Lambda::Function');
/**
 * AWS Secrets Manager secret.
 *
 * @stability stable
 */
ResourceType.SECRETS_MANAGER_SECRET = new ResourceType('AWS::SecretsManager::Secret');
/**
 * AWS Service Catalog CloudFormation product.
 *
 * @stability stable
 */
ResourceType.SERVICE_CATALOG_CLOUDFORMATION_PRODUCT = new ResourceType('AWS::ServiceCatalog::CloudFormationProduct');
/**
 * AWS Service Catalog CloudFormation provisioned product.
 *
 * @stability stable
 */
ResourceType.SERVICE_CATALOG_CLOUDFORMATION_PROVISIONED_PRODUCT = new ResourceType('AWS::ServiceCatalog::CloudFormationProvisionedProduct');
/**
 * AWS Service Catalog portfolio.
 *
 * @stability stable
 */
ResourceType.SERVICE_CATALOG_PORTFOLIO = new ResourceType('AWS::ServiceCatalog::Portfolio');
/**
 * AWS Shield protection.
 *
 * @stability stable
 */
ResourceType.SHIELD_PROTECTION = new ResourceType('AWS::Shield::Protection');
/**
 * AWS Shield regional protection.
 *
 * @stability stable
 */
ResourceType.SHIELD_REGIONAL_PROTECTION = new ResourceType('AWS::ShieldRegional::Protection');
/**
 * AWS Systems Manager managed instance inventory.
 *
 * @stability stable
 */
ResourceType.SYSTEMS_MANAGER_MANAGED_INSTANCE_INVENTORY = new ResourceType('AWS::SSM::ManagedInstanceInventory');
/**
 * AWS Systems Manager patch compliance.
 *
 * @stability stable
 */
ResourceType.SYSTEMS_MANAGER_PATCH_COMPLIANCE = new ResourceType('AWS::SSM::PatchCompliance');
/**
 * AWS Systems Manager association compliance.
 *
 * @stability stable
 */
ResourceType.SYSTEMS_MANAGER_ASSOCIATION_COMPLIANCE = new ResourceType('AWS::SSM::AssociationCompliance');
/**
 * AWS Systems Manager file data.
 *
 * @stability stable
 */
ResourceType.SYSTEMS_MANAGER_FILE_DATA = new ResourceType('AWS::SSM::FileData');
/**
 * AWS WAF rate based rule.
 *
 * @stability stable
 */
ResourceType.WAF_RATE_BASED_RULE = new ResourceType('AWS::WAF::RateBasedRule');
/**
 * AWS WAF rule.
 *
 * @stability stable
 */
ResourceType.WAF_RULE = new ResourceType('AWS::WAF::Rule');
/**
 * AWS WAF web ACL.
 *
 * @stability stable
 */
ResourceType.WAF_WEB_ACL = new ResourceType('AWS::WAF::WebACL');
/**
 * AWS WAF rule group.
 *
 * @stability stable
 */
ResourceType.WAF_RULE_GROUP = new ResourceType('AWS::WAF::RuleGroup');
/**
 * AWS WAF regional rate based rule.
 *
 * @stability stable
 */
ResourceType.WAF_REGIONAL_RATE_BASED_RULE = new ResourceType('AWS::WAFRegional::RateBasedRule');
/**
 * AWS WAF regional rule.
 *
 * @stability stable
 */
ResourceType.WAF_REGIONAL_RULE = new ResourceType('AWS::WAFRegional::Rule');
/**
 * AWS WAF web ACL.
 *
 * @stability stable
 */
ResourceType.WAF_REGIONAL_WEB_ACL = new ResourceType('AWS::WAFRegional::WebACL');
/**
 * AWS WAF regional rule group.
 *
 * @stability stable
 */
ResourceType.WAF_REGIONAL_RULE_GROUP = new ResourceType('AWS::WAFRegional::RuleGroup');
/**
 * AWS WAFv2 web ACL.
 *
 * @stability stable
 */
ResourceType.WAFV2_WEB_ACL = new ResourceType('AWS::WAFv2::WebACL');
/**
 * AWS WAFv2 rule group.
 *
 * @stability stable
 */
ResourceType.WAFV2_RULE_GROUP = new ResourceType('AWS::WAFv2::RuleGroup');
/**
 * AWS WAFv2 managed rule set.
 *
 * @stability stable
 */
ResourceType.WAFV2_MANAGED_RULE_SET = new ResourceType('AWS::WAFv2::ManagedRuleSet');
/**
 * AWS X-Ray encryption configuration.
 *
 * @stability stable
 */
ResourceType.XRAY_ENCRYPTION_CONFIGURATION = new ResourceType('AWS::XRay::EncryptionConfig');
/**
 * AWS ELB classic load balancer.
 *
 * @stability stable
 */
ResourceType.ELB_LOAD_BALANCER = new ResourceType('AWS::ElasticLoadBalancing::LoadBalancer');
/**
 * AWS ELBv2 network load balancer or AWS ELBv2 application load balancer.
 *
 * @stability stable
 */
ResourceType.ELBV2_LOAD_BALANCER = new ResourceType('AWS::ElasticLoadBalancingV2::LoadBalancer');
function renderScope(ruleScope) {
    var _f;
    return ruleScope ? {
        complianceResourceId: ruleScope.resourceId,
        complianceResourceTypes: (_f = ruleScope.resourceTypes) === null || _f === void 0 ? void 0 : _f.map(resource => resource.complianceResourceType),
        tagKey: ruleScope.key,
        tagValue: ruleScope.value,
    } : undefined;
}
//# sourceMappingURL=data:application/json;base64,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