"""
    OpenAPI definition

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: v0
    Contact: support@gooddata.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from gooddata_api_client.api_client import ApiClient, Endpoint as _Endpoint
from gooddata_api_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from gooddata_api_client.model.declarative_automation import DeclarativeAutomation
from gooddata_api_client.model.json_api_automation_in_document import JsonApiAutomationInDocument
from gooddata_api_client.model.json_api_automation_out_document import JsonApiAutomationOutDocument
from gooddata_api_client.model.json_api_automation_out_list import JsonApiAutomationOutList
from gooddata_api_client.model.json_api_automation_patch_document import JsonApiAutomationPatchDocument
from gooddata_api_client.model.trigger_automation_request import TriggerAutomationRequest


class AutomationsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_entity_automations_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAutomationOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/automations',
                'operation_id': 'create_entity_automations',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'json_api_automation_in_document',
                    'include',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'json_api_automation_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "NOTIFICATIONCHANNELS": "notificationChannels",
                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "USERIDENTIFIERS": "userIdentifiers",
                        "EXPORTDEFINITIONS": "exportDefinitions",
                        "USERS": "users",
                        "AUTOMATIONRESULTS": "automationResults",
                        "NOTIFICATIONCHANNEL": "notificationChannel",
                        "ANALYTICALDASHBOARD": "analyticalDashboard",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "RECIPIENTS": "recipients",
                        "AUTOMATIONRESULT": "automationResult",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'json_api_automation_in_document':
                        (JsonApiAutomationInDocument,),
                    'include':
                        ([str],),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'include': 'include',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'json_api_automation_in_document': 'body',
                    'include': 'query',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.delete_entity_automations_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/automations/{objectId}',
                'operation_id': 'delete_entity_automations',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_all_entities_automations_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAutomationOutList,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/automations',
                'operation_id': 'get_all_entities_automations',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'origin',
                    'filter',
                    'include',
                    'page',
                    'size',
                    'sort',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'origin',
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('origin',): {

                        "ALL": "ALL",
                        "PARENTS": "PARENTS",
                        "NATIVE": "NATIVE"
                    },
                    ('include',): {

                        "NOTIFICATIONCHANNELS": "notificationChannels",
                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "USERIDENTIFIERS": "userIdentifiers",
                        "EXPORTDEFINITIONS": "exportDefinitions",
                        "USERS": "users",
                        "AUTOMATIONRESULTS": "automationResults",
                        "NOTIFICATIONCHANNEL": "notificationChannel",
                        "ANALYTICALDASHBOARD": "analyticalDashboard",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "RECIPIENTS": "recipients",
                        "AUTOMATIONRESULT": "automationResult",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "PAGE": "page",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'origin':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'page':
                        (int,),
                    'size':
                        (int,),
                    'sort':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'origin': 'origin',
                    'filter': 'filter',
                    'include': 'include',
                    'page': 'page',
                    'size': 'size',
                    'sort': 'sort',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'origin': 'query',
                    'filter': 'query',
                    'include': 'query',
                    'page': 'query',
                    'size': 'query',
                    'sort': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'sort': 'multi',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_automations_endpoint = _Endpoint(
            settings={
                'response_type': ([DeclarativeAutomation],),
                'auth': [],
                'endpoint_path': '/api/v1/layout/workspaces/{workspaceId}/automations',
                'operation_id': 'get_automations',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'exclude',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'exclude',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('exclude',): {

                        "ACTIVITY_INFO": "ACTIVITY_INFO"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'exclude':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'exclude': 'exclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'exclude': 'query',
                },
                'collection_format_map': {
                    'exclude': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_automations_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAutomationOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/automations/{objectId}',
                'operation_id': 'get_entity_automations',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'filter',
                    'include',
                    'x_gdc_validate_relations',
                    'meta_include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                    'meta_include',
                ],
                'validation': [
                    'meta_include',
                ]
            },
            root_map={
                'validations': {
                    ('meta_include',): {

                    },
                },
                'allowed_values': {
                    ('include',): {

                        "NOTIFICATIONCHANNELS": "notificationChannels",
                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "USERIDENTIFIERS": "userIdentifiers",
                        "EXPORTDEFINITIONS": "exportDefinitions",
                        "USERS": "users",
                        "AUTOMATIONRESULTS": "automationResults",
                        "NOTIFICATIONCHANNEL": "notificationChannel",
                        "ANALYTICALDASHBOARD": "analyticalDashboard",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "RECIPIENTS": "recipients",
                        "AUTOMATIONRESULT": "automationResult",
                        "ALL": "ALL"
                    },
                    ('meta_include',): {

                        "ORIGIN": "origin",
                        "ALL": "all",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                    'x_gdc_validate_relations':
                        (bool,),
                    'meta_include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                    'x_gdc_validate_relations': 'X-GDC-VALIDATE-RELATIONS',
                    'meta_include': 'metaInclude',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'filter': 'query',
                    'include': 'query',
                    'x_gdc_validate_relations': 'header',
                    'meta_include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                    'meta_include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.patch_entity_automations_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAutomationOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/automations/{objectId}',
                'operation_id': 'patch_entity_automations',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_automation_patch_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_automation_patch_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "NOTIFICATIONCHANNELS": "notificationChannels",
                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "USERIDENTIFIERS": "userIdentifiers",
                        "EXPORTDEFINITIONS": "exportDefinitions",
                        "USERS": "users",
                        "AUTOMATIONRESULTS": "automationResults",
                        "NOTIFICATIONCHANNEL": "notificationChannel",
                        "ANALYTICALDASHBOARD": "analyticalDashboard",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "RECIPIENTS": "recipients",
                        "AUTOMATIONRESULT": "automationResult",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_automation_patch_document':
                        (JsonApiAutomationPatchDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_automation_patch_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )
        self.set_automations_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/layout/workspaces/{workspaceId}/automations',
                'operation_id': 'set_automations',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'declarative_automation',
                ],
                'required': [
                    'workspace_id',
                    'declarative_automation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'declarative_automation':
                        ([DeclarativeAutomation],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'declarative_automation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.trigger_automation_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/actions/workspaces/{workspaceId}/automations/trigger',
                'operation_id': 'trigger_automation',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'trigger_automation_request',
                ],
                'required': [
                    'workspace_id',
                    'trigger_automation_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'trigger_automation_request':
                        (TriggerAutomationRequest,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'trigger_automation_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.trigger_existing_automation_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/actions/workspaces/{workspaceId}/automations/{automationId}/trigger',
                'operation_id': 'trigger_existing_automation',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'automation_id',
                ],
                'required': [
                    'workspace_id',
                    'automation_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'automation_id':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'automation_id': 'automationId',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'automation_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.unsubscribe_all_automations_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/actions/organization/automations/unsubscribe',
                'operation_id': 'unsubscribe_all_automations',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.unsubscribe_automation_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/actions/workspaces/{workspaceId}/automations/{automationId}/unsubscribe',
                'operation_id': 'unsubscribe_automation',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'automation_id',
                ],
                'required': [
                    'workspace_id',
                    'automation_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'automation_id':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'automation_id': 'automationId',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'automation_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.unsubscribe_workspace_automations_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/api/v1/actions/workspaces/{workspaceId}/automations/unsubscribe',
                'operation_id': 'unsubscribe_workspace_automations',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                ],
                'required': [
                    'workspace_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                },
                'location_map': {
                    'workspace_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_entity_automations_endpoint = _Endpoint(
            settings={
                'response_type': (JsonApiAutomationOutDocument,),
                'auth': [],
                'endpoint_path': '/api/v1/entities/workspaces/{workspaceId}/automations/{objectId}',
                'operation_id': 'update_entity_automations',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'workspace_id',
                    'object_id',
                    'json_api_automation_in_document',
                    'filter',
                    'include',
                ],
                'required': [
                    'workspace_id',
                    'object_id',
                    'json_api_automation_in_document',
                ],
                'nullable': [
                ],
                'enum': [
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('include',): {

                        "NOTIFICATIONCHANNELS": "notificationChannels",
                        "ANALYTICALDASHBOARDS": "analyticalDashboards",
                        "USERIDENTIFIERS": "userIdentifiers",
                        "EXPORTDEFINITIONS": "exportDefinitions",
                        "USERS": "users",
                        "AUTOMATIONRESULTS": "automationResults",
                        "NOTIFICATIONCHANNEL": "notificationChannel",
                        "ANALYTICALDASHBOARD": "analyticalDashboard",
                        "CREATEDBY": "createdBy",
                        "MODIFIEDBY": "modifiedBy",
                        "RECIPIENTS": "recipients",
                        "AUTOMATIONRESULT": "automationResult",
                        "ALL": "ALL"
                    },
                },
                'openapi_types': {
                    'workspace_id':
                        (str,),
                    'object_id':
                        (str,),
                    'json_api_automation_in_document':
                        (JsonApiAutomationInDocument,),
                    'filter':
                        (str,),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'workspace_id': 'workspaceId',
                    'object_id': 'objectId',
                    'filter': 'filter',
                    'include': 'include',
                },
                'location_map': {
                    'workspace_id': 'path',
                    'object_id': 'path',
                    'json_api_automation_in_document': 'body',
                    'filter': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.gooddata.api+json'
                ],
                'content_type': [
                    'application/vnd.gooddata.api+json'
                ]
            },
            api_client=api_client
        )

    def create_entity_automations(
        self,
        workspace_id,
        json_api_automation_in_document,
        **kwargs
    ):
        """Post Automations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_entity_automations(workspace_id, json_api_automation_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            json_api_automation_in_document (JsonApiAutomationInDocument):

        Keyword Args:
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAutomationOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['json_api_automation_in_document'] = \
            json_api_automation_in_document
        return self.create_entity_automations_endpoint.call_with_http_info(**kwargs)

    def delete_entity_automations(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Delete an Automation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_automations(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.delete_entity_automations_endpoint.call_with_http_info(**kwargs)

    def get_all_entities_automations(
        self,
        workspace_id,
        **kwargs
    ):
        """Get all Automations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_entities_automations(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            origin (str): [optional] if omitted the server will use the default value of "ALL"
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            page (int): Zero-based page index (0..N). [optional] if omitted the server will use the default value of 0
            size (int): The size of the page to be returned. [optional] if omitted the server will use the default value of 20
            sort ([str]): Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAutomationOutList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_all_entities_automations_endpoint.call_with_http_info(**kwargs)

    def get_automations(
        self,
        workspace_id,
        **kwargs
    ):
        """Get automations  # noqa: E501

        Retrieve automations for the specific workspace  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_automations(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            exclude ([str]): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [DeclarativeAutomation]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.get_automations_endpoint.call_with_http_info(**kwargs)

    def get_entity_automations(
        self,
        workspace_id,
        object_id,
        **kwargs
    ):
        """Get an Automation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_automations(workspace_id, object_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            x_gdc_validate_relations (bool): [optional] if omitted the server will use the default value of False
            meta_include ([str]): Include Meta objects.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAutomationOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        return self.get_entity_automations_endpoint.call_with_http_info(**kwargs)

    def patch_entity_automations(
        self,
        workspace_id,
        object_id,
        json_api_automation_patch_document,
        **kwargs
    ):
        """Patch an Automation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_entity_automations(workspace_id, object_id, json_api_automation_patch_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_automation_patch_document (JsonApiAutomationPatchDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAutomationOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_automation_patch_document'] = \
            json_api_automation_patch_document
        return self.patch_entity_automations_endpoint.call_with_http_info(**kwargs)

    def set_automations(
        self,
        workspace_id,
        declarative_automation,
        **kwargs
    ):
        """Set automations  # noqa: E501

        Set automations for the specific workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_automations(workspace_id, declarative_automation, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            declarative_automation ([DeclarativeAutomation]):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['declarative_automation'] = \
            declarative_automation
        return self.set_automations_endpoint.call_with_http_info(**kwargs)

    def trigger_automation(
        self,
        workspace_id,
        trigger_automation_request,
        **kwargs
    ):
        """Trigger automation.  # noqa: E501

        Trigger the automation in the request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.trigger_automation(workspace_id, trigger_automation_request, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            trigger_automation_request (TriggerAutomationRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['trigger_automation_request'] = \
            trigger_automation_request
        return self.trigger_automation_endpoint.call_with_http_info(**kwargs)

    def trigger_existing_automation(
        self,
        workspace_id,
        automation_id,
        **kwargs
    ):
        """Trigger existing automation.  # noqa: E501

        Trigger the existing automation to execute immediately.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.trigger_existing_automation(workspace_id, automation_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            automation_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['automation_id'] = \
            automation_id
        return self.trigger_existing_automation_endpoint.call_with_http_info(**kwargs)

    def unsubscribe_all_automations(
        self,
        **kwargs
    ):
        """Unsubscribe from all automations in all workspaces  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.unsubscribe_all_automations(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.unsubscribe_all_automations_endpoint.call_with_http_info(**kwargs)

    def unsubscribe_automation(
        self,
        workspace_id,
        automation_id,
        **kwargs
    ):
        """Unsubscribe from an automation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.unsubscribe_automation(workspace_id, automation_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            automation_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['automation_id'] = \
            automation_id
        return self.unsubscribe_automation_endpoint.call_with_http_info(**kwargs)

    def unsubscribe_workspace_automations(
        self,
        workspace_id,
        **kwargs
    ):
        """Unsubscribe from all automations in the workspace  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.unsubscribe_workspace_automations(workspace_id, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        return self.unsubscribe_workspace_automations_endpoint.call_with_http_info(**kwargs)

    def update_entity_automations(
        self,
        workspace_id,
        object_id,
        json_api_automation_in_document,
        **kwargs
    ):
        """Put an Automation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_entity_automations(workspace_id, object_id, json_api_automation_in_document, async_req=True)
        >>> result = thread.get()

        Args:
            workspace_id (str):
            object_id (str):
            json_api_automation_in_document (JsonApiAutomationInDocument):

        Keyword Args:
            filter (str): Filtering parameter in RSQL. See https://github.com/jirutka/rsql-parser. You can specify any object parameter and parameter of related entity (for example title=='Some Title';description=='desc'). Additionally, if the entity relationship represents a polymorphic entity type, it can be casted to its subtypes (for example relatedEntity::subtype.subtypeProperty=='Value 123').. [optional]
            include ([str]): Array of included collections or individual relationships. Includes are separated by commas (e.g. include=entity1s,entity2s). Collection include represents the inclusion of every relationship between this entity and the given collection. Relationship include represents the inclusion of the particular relationships only. If single parameter \"ALL\" is present, all possible includes are used (include=ALL).  __WARNING:__ Individual include types (collection, relationship or ALL) cannot be combined together.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            JsonApiAutomationOutDocument
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['workspace_id'] = \
            workspace_id
        kwargs['object_id'] = \
            object_id
        kwargs['json_api_automation_in_document'] = \
            json_api_automation_in_document
        return self.update_entity_automations_endpoint.call_with_http_info(**kwargs)

