"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontToMediaStore = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
const aws_cdk_lib_1 = require("aws-cdk-lib");
class CloudFrontToMediaStore extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of CloudFrontToMediaStore class.
     * @param {Construct} scope - represents the scope for all the resources.
     * @param {string} id - this is a scope-unique id.
     * @param {CloudFrontToMediaStoreProps} props - user provided props for the construct
     * @since 1.76.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.printWarning("******************");
        defaults.printWarning("AWS Elemental MediaStore will be discontinued on November 13, 2025");
        defaults.printWarning("Support for this construct will be removed for all subsequent releases.");
        defaults.printWarning("https://aws.amazon.com/blogs/media/support-for-aws-elemental-mediastore-ending-soon/");
        defaults.printWarning("******************");
        // All our tests are based upon this behavior being on, so we're setting
        // context here rather than assuming the client will set it
        this.node.setContext("@aws-cdk/aws-s3:serverAccessLogsUseBucketPolicy", true);
        defaults.CheckMediaStoreProps(props);
        defaults.CheckCloudFrontProps(props);
        let cloudFrontDistributionProps = props.cloudFrontDistributionProps;
        if (props.existingMediaStoreContainerObj) {
            this.mediaStoreContainer = props.existingMediaStoreContainerObj;
        }
        else {
            let mediaStoreProps;
            if (props.mediaStoreContainerProps) {
                mediaStoreProps = props.mediaStoreContainerProps;
            }
            else {
                this.cloudFrontOriginAccessIdentity = defaults.CloudFrontOriginAccessIdentity(this);
                mediaStoreProps = {
                    containerName: aws_cdk_lib_1.Aws.STACK_NAME,
                    policy: JSON.stringify({
                        Version: '2012-10-17',
                        Statement: [{
                                Sid: 'MediaStoreDefaultPolicy',
                                Effect: 'Allow',
                                Principal: '*',
                                Action: [
                                    'mediastore:GetObject',
                                    'mediastore:DescribeObject'
                                ],
                                Resource: `arn:${aws_cdk_lib_1.Aws.PARTITION}:mediastore:${aws_cdk_lib_1.Aws.REGION}:${aws_cdk_lib_1.Aws.ACCOUNT_ID}:container/${aws_cdk_lib_1.Aws.STACK_NAME}/*`,
                                Condition: {
                                    StringEquals: {
                                        'aws:UserAgent': this.cloudFrontOriginAccessIdentity.originAccessIdentityId
                                    },
                                    Bool: {
                                        'aws:SecureTransport': 'true'
                                    }
                                }
                            }]
                    })
                };
                const userAgentHeader = {
                    'User-Agent': this.cloudFrontOriginAccessIdentity.originAccessIdentityId
                };
                if (cloudFrontDistributionProps) {
                    cloudFrontDistributionProps.customHeaders = userAgentHeader;
                }
                else {
                    cloudFrontDistributionProps = {
                        customHeaders: userAgentHeader
                    };
                }
            }
            this.mediaStoreContainer = defaults.MediaStoreContainer(this, mediaStoreProps);
        }
        const distributionResponse = defaults.CloudFrontDistributionForMediaStore(this, this.mediaStoreContainer, cloudFrontDistributionProps, props.insertHttpSecurityHeaders, props.cloudFrontLoggingBucketProps, props.responseHeadersPolicyProps);
        this.cloudFrontWebDistribution = distributionResponse.distribution;
        this.cloudFrontLoggingBucket = distributionResponse.loggingBucket;
        this.cloudFrontOriginRequestPolicy = distributionResponse.requestPolicy;
        this.cloudFrontFunction = distributionResponse.cloudfrontFunction;
    }
}
exports.CloudFrontToMediaStore = CloudFrontToMediaStore;
_a = JSII_RTTI_SYMBOL_1;
CloudFrontToMediaStore[_a] = { fqn: "@aws-solutions-constructs/aws-cloudfront-mediastore.CloudFrontToMediaStore", version: "2.91.0" };
//# sourceMappingURL=data:application/json;base64,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