from enum import IntEnum, auto


class Call(IntEnum):
    NEAR_C = 0x00
    FAR_C = 0x01
    NEAR_PASCAL = 0x02
    FAR_PASCAL = 0x03
    NEAR_FAST = 0x04
    FAR_FAST = 0x05
    SKIPPED = 0x06
    NEAR_STD = 0x07
    FAR_STD = 0x08
    NEAR_SYS = 0x09
    FAR_SYS = 0x0a
    THISCALL = 0x0b
    MIPSCALL = 0x0c
    GENERIC = 0x0d
    ALPHACALL = 0x0e
    PPCCALL = 0x0f
    SHCALL = 0x10
    ARMCALL = 0x11
    AM33CALL = 0x12
    TRICALL = 0x13
    SH5CALL = 0x14
    M32RCALL = 0x15
    CLRCALL = 0x16
    INLINE = 0x17
    NEAR_VECTOR = 0x18
    SWIFT = 0x19
    RESERVED = 0x20


class Access(IntEnum):
    private = 1
    protected = 2
    public = 3


class THUNK_ORDINAL(IntEnum):
    NOTYPE = 0
    ADJUSTOR = auto()
    VCALL = auto()
    PCODE = auto()
    LOAD = auto()
    TRAMP_INCREMENTAL = auto()
    TRAMP_BRANCHISLAND = auto()
    TRAMP_STRICTICF = auto()


class SourceChksum(IntEnum):
    NONE = 0
    MD5 = auto()
    SHA1 = auto()
    SHA_256 = auto()


class SymTag(IntEnum):
    Null = 0
    Exe = auto()
    Compiland = auto()
    CompilandDetails = auto()
    CompilandEnv = auto()
    Function = auto()
    Block = auto()
    Data = auto()
    Annotation = auto()
    Label = auto()
    PublicSymbol = auto()
    UDT = auto()
    Enum = auto()
    FunctionType = auto()
    PointerType = auto()
    ArrayType = auto()
    BaseType = auto()
    Typedef = auto()
    BaseClass = auto()
    Friend = auto()
    FunctionArgType = auto()
    FuncDebugStart = auto()
    FuncDebugEnd = auto()
    UsingNamespace = auto()
    VTableShape = auto()
    VTable = auto()
    Custom = auto()
    Thunk = auto()
    CustomType = auto()
    ManagedType = auto()
    Dimension = auto()
    CallSite = auto()
    InlineSite = auto()
    BaseInterface = auto()
    VectorType = auto()
    MatrixType = auto()
    HLSLType = auto()
    Caller = auto()
    Callee = auto()
    Export = auto()
    HeapAllocationSite = auto()
    CoffGroup = auto()
    Inlinee = auto()
    Max = auto()


class LocationType(IntEnum):
    Null = 0
    Static = auto()
    TLS = auto()
    RegRel = auto()
    ThisRel = auto()
    Enregistered = auto()
    BitField = auto()
    Slot = auto()
    IlRel = auto()
    LocInMetaData = auto()
    Constant = auto()
    RegRelAliasIndir = auto()
    LocTypeMax = auto()


class DataKind(IntEnum):
    Unknown = 0
    Local = auto()
    StaticLocal = auto()
    Param = auto()
    ObjectPtr = auto()
    FileStatic = auto()
    Global = auto()
    Member = auto()
    StaticMember = auto()
    Constant = auto()


class UdtKind(IntEnum):
    Struct = 0
    Class = auto()
    Union = auto()
    Interface = auto()


class BasicType(IntEnum):
    NoType = 0
    Void = 1
    Char = 2
    WChar = 3
    Int = 6
    UInt = 7
    Float = 8
    BCD = 9
    Bool = 10
    Long = 13
    ULong = 14
    Currency = 25
    Date = 26
    Variant = 27
    Complex = 28
    Bit = 29
    BSTR = 30
    Hresult = 31
    Char16 = 32
    Char32 = 33
    Char8 = 34


class Modifier(IntEnum):
    INVALID = 0x0000
    CONST = 0x0001
    VOLATILE = 0x0002
    UNALIGNED = 0x0003
    HLSL_UNIFORM = 0x0200
    HLSL_LINE = 0x0201
    HLSL_TRIANGLE = 0x0202
    HLSL_LINEADJ = 0x0203
    HLSL_TRIANGLEADJ = 0x0204
    HLSL_LINEAR = 0x0205
    HLSL_CENTROID = 0x0206
    HLSL_CONSTINTERP = 0x0207
    HLSL_NOPERSPECTIVE = 0x0208
    HLSL_SAMPLE = 0x0209
    HLSL_CENTER = 0x020a
    HLSL_SNORM = 0x020b
    HLSL_UNORM = 0x020c
    HLSL_PRECISE = 0x020d
    HLSL_UAV_GLOBALLY_COHERENT = 0x020e


class Builtin(IntEnum):
    INVALID = 0x0000
    HLSL_INTERFACE_POINTER = 0x0200
    HLSL_TEXTURE1D = 0x0201
    HLSL_TEXTURE1D_ARRAY = 0x0202
    HLSL_TEXTURE2D = 0x0203
    HLSL_TEXTURE2D_ARRAY = 0x0204
    HLSL_TEXTURE3D = 0x0205
    HLSL_TEXTURECUBE = 0x0206
    HLSL_TEXTURECUBE_ARRAY = 0x0207
    HLSL_TEXTURE2DMS = 0x0208
    HLSL_TEXTURE2DMS_ARRAY = 0x0209
    HLSL_SAMPLER = 0x020a
    HLSL_SAMPLERCOMPARISON = 0x020b
    HLSL_BUFFER = 0x020c
    HLSL_POINTSTREAM = 0x020d
    HLSL_LINESTREAM = 0x020e
    HLSL_TRIANGLESTREAM = 0x020f
    HLSL_INPUTPATCH = 0x0210
    HLSL_OUTPUTPATCH = 0x0211
    HLSL_RWTEXTURE1D = 0x0212
    HLSL_RWTEXTURE1D_ARRAY = 0x0213
    HLSL_RWTEXTURE2D = 0x0214
    HLSL_RWTEXTURE2D_ARRAY = 0x0215
    HLSL_RWTEXTURE3D = 0x0216
    HLSL_RWBUFFER = 0x0217
    HLSL_BYTEADDRESS_BUFFER = 0x0218
    HLSL_RWBYTEADDRESS_BUFFER = 0x0219
    HLSL_STRUCTURED_BUFFER = 0x021a
    HLSL_RWSTRUCTURED_BUFFER = 0x021b
    HLSL_APPEND_STRUCTURED_BUFFER = 0x021c
    HLSL_CONSUME_STRUCTURED_BUFFER = 0x021d
    HLSL_MIN8FLOAT = 0x021e
    HLSL_MIN10FLOAT = 0x021f
    HLSL_MIN16FLOAT = 0x0220
    HLSL_MIN12INT = 0x0221
    HLSL_MIN16INT = 0x0222
    HLSL_MIN16UINT = 0x0223
    HLSL_CONSTANT_BUFFER = 0x0224


class CFL_LANG(IntEnum):
    C = 0x00
    CXX = 0x01
    FORTRAN = 0x02
    MASM = 0x03
    PASCAL = 0x04
    BASIC = 0x05
    COBOL = 0x06
    LINK = 0x07
    CVTRES = 0x08
    CVTPGD = 0x09
    CSHARP = 0x0A
    VB = 0x0B
    ILASM = 0x0C
    JAVA = 0x0D
    JSCRIPT = 0x0E
    MSIL = 0x0F
    HLSL = 0x10
    OBJC = 0x11
    OBJCXX = 0x12
    SWIFT = 0x13


class CPU_TYPE(IntEnum):
    CFL_8080 = 0x00
    CFL_8086 = 0x01
    CFL_80286 = 0x02
    CFL_80386 = 0x03
    CFL_80486 = 0x04
    CFL_PENTIUM = 0x05
    CFL_PENTIUMII = 0x06
    CFL_PENTIUMPRO = CFL_PENTIUMII
    CFL_PENTIUMIII = 0x07
    CFL_MIPS = 0x10
    CFL_MIPSR4000 = CFL_MIPS
    CFL_MIPS16 = 0x11
    CFL_MIPS32 = 0x12
    CFL_MIPS64 = 0x13
    CFL_MIPSI = 0x14
    CFL_MIPSII = 0x15
    CFL_MIPSIII = 0x16
    CFL_MIPSIV = 0x17
    CFL_MIPSV = 0x18
    CFL_M68000 = 0x20
    CFL_M68010 = 0x21
    CFL_M68020 = 0x22
    CFL_M68030 = 0x23
    CFL_M68040 = 0x24
    CFL_ALPHA = 0x30
    CFL_ALPHA_21064 = 0x30
    CFL_ALPHA_21164 = 0x31
    CFL_ALPHA_21164A = 0x32
    CFL_ALPHA_21264 = 0x33
    CFL_ALPHA_21364 = 0x34
    CFL_PPC601 = 0x40
    CFL_PPC603 = 0x41
    CFL_PPC604 = 0x42
    CFL_PPC620 = 0x43
    CFL_PPCFP = 0x44
    CFL_PPCBE = 0x45
    CFL_SH3 = 0x50
    CFL_SH3E = 0x51
    CFL_SH3DSP = 0x52
    CFL_SH4 = 0x53
    CFL_SHMEDIA = 0x54
    CFL_ARM3 = 0x60
    CFL_ARM4 = 0x61
    CFL_ARM4T = 0x62
    CFL_ARM5 = 0x63
    CFL_ARM5T = 0x64
    CFL_ARM6 = 0x65
    CFL_ARM_XMAC = 0x66
    CFL_ARM_WMMX = 0x67
    CFL_ARM7 = 0x68
    CFL_OMNI = 0x70
    CFL_IA64 = 0x80
    CFL_IA64_1 = 0x80
    CFL_IA64_2 = 0x81
    CFL_CEE = 0x90
    CFL_AM33 = 0xA0
    CFL_M32R = 0xB0
    CFL_TRICORE = 0xC0
    CFL_X64 = 0xD0
    CFL_AMD64 = CFL_X64
    CFL_EBC = 0xE0
    CFL_THUMB = 0xF0
    CFL_ARMNT = 0xF4
    CFL_ARM64 = 0xF6
    CFL_HYBRID_X86_ARM64 = 0xF7
    CFL_ARM64EC = 0xF8
    CFL_ARM64X = 0xF9
    CFL_D3D11_SHADER = 0x100


class HREG(IntEnum):
    ALLREG_ERR = 30000
    ALLREG_TEB = 30001
    ALLREG_TIMER = 30002
    ALLREG_EFAD1 = 30003
    ALLREG_EFAD2 = 30004
    ALLREG_EFAD3 = 30005
    ALLREG_VFRAME = 30006
    ALLREG_HANDLE = 30007
    ALLREG_PARAMS = 30008
    ALLREG_LOCALS = 30009
    ALLREG_TID = 30010
    ALLREG_ENV = 30011
    ALLREG_CMDLN = 30012
    REG_NONE = 0
    REG_AL = 1
    REG_CL = 2
    REG_DL = 3
    REG_BL = 4
    REG_AH = 5
    REG_CH = 6
    REG_DH = 7
    REG_BH = 8
    REG_AX = 9
    REG_CX = 10
    REG_DX = 11
    REG_BX = 12
    REG_SP = 13
    REG_BP = 14
    REG_SI = 15
    REG_DI = 16
    REG_EAX = 17
    REG_ECX = 18
    REG_EDX = 19
    REG_EBX = 20
    REG_ESP = 21
    REG_EBP = 22
    REG_ESI = 23
    REG_EDI = 24
    REG_ES = 25
    REG_CS = 26
    REG_SS = 27
    REG_DS = 28
    REG_FS = 29
    REG_GS = 30
    REG_IP = 31
    REG_FLAGS = 32
    REG_EIP = 33
    REG_EFLAGS = 34
    REG_TEMP = 40
    REG_TEMPH = 41
    REG_QUOTE = 42
    REG_PCDR3 = 43
    REG_PCDR4 = 44
    REG_PCDR5 = 45
    REG_PCDR6 = 46
    REG_PCDR7 = 47
    REG_CR0 = 80
    REG_CR1 = 81
    REG_CR2 = 82
    REG_CR3 = 83
    REG_CR4 = 84
    REG_DR0 = 90
    REG_DR1 = 91
    REG_DR2 = 92
    REG_DR3 = 93
    REG_DR4 = 94
    REG_DR5 = 95
    REG_DR6 = 96
    REG_DR7 = 97
    REG_GDTR = 110
    REG_GDTL = 111
    REG_IDTR = 112
    REG_IDTL = 113
    REG_LDTR = 114
    REG_TR = 115
    REG_PSEUDO1 = 116
    REG_PSEUDO2 = 117
    REG_PSEUDO3 = 118
    REG_PSEUDO4 = 119
    REG_PSEUDO5 = 120
    REG_PSEUDO6 = 121
    REG_PSEUDO7 = 122
    REG_PSEUDO8 = 123
    REG_PSEUDO9 = 124
    REG_ST0 = 128
    REG_ST1 = 129
    REG_ST2 = 130
    REG_ST3 = 131
    REG_ST4 = 132
    REG_ST5 = 133
    REG_ST6 = 134
    REG_ST7 = 135
    REG_CTRL = 136
    REG_STAT = 137
    REG_TAG = 138
    REG_FPIP = 139
    REG_FPCS = 140
    REG_FPDO = 141
    REG_FPDS = 142
    REG_ISEM = 143
    REG_FPEIP = 144
    REG_FPEDO = 145
    REG_MM0 = 146
    REG_MM1 = 147
    REG_MM2 = 148
    REG_MM3 = 149
    REG_MM4 = 150
    REG_MM5 = 151
    REG_MM6 = 152
    REG_MM7 = 153
    REG_XMM0 = 154
    REG_XMM1 = 155
    REG_XMM2 = 156
    REG_XMM3 = 157
    REG_XMM4 = 158
    REG_XMM5 = 159
    REG_XMM6 = 160
    REG_XMM7 = 161
    REG_XMM00 = 162
    REG_XMM01 = 163
    REG_XMM02 = 164
    REG_XMM03 = 165
    REG_XMM10 = 166
    REG_XMM11 = 167
    REG_XMM12 = 168
    REG_XMM13 = 169
    REG_XMM20 = 170
    REG_XMM21 = 171
    REG_XMM22 = 172
    REG_XMM23 = 173
    REG_XMM30 = 174
    REG_XMM31 = 175
    REG_XMM32 = 176
    REG_XMM33 = 177
    REG_XMM40 = 178
    REG_XMM41 = 179
    REG_XMM42 = 180
    REG_XMM43 = 181
    REG_XMM50 = 182
    REG_XMM51 = 183
    REG_XMM52 = 184
    REG_XMM53 = 185
    REG_XMM60 = 186
    REG_XMM61 = 187
    REG_XMM62 = 188
    REG_XMM63 = 189
    REG_XMM70 = 190
    REG_XMM71 = 191
    REG_XMM72 = 192
    REG_XMM73 = 193
    REG_XMM0L = 194
    REG_XMM1L = 195
    REG_XMM2L = 196
    REG_XMM3L = 197
    REG_XMM4L = 198
    REG_XMM5L = 199
    REG_XMM6L = 200
    REG_XMM7L = 201
    REG_XMM0H = 202
    REG_XMM1H = 203
    REG_XMM2H = 204
    REG_XMM3H = 205
    REG_XMM4H = 206
    REG_XMM5H = 207
    REG_XMM6H = 208
    REG_XMM7H = 209
    REG_MXCSR = 211
    REG_EDXEAX = 212
    REG_EMM0L = 220
    REG_EMM1L = 221
    REG_EMM2L = 222
    REG_EMM3L = 223
    REG_EMM4L = 224
    REG_EMM5L = 225
    REG_EMM6L = 226
    REG_EMM7L = 227
    REG_EMM0H = 228
    REG_EMM1H = 229
    REG_EMM2H = 230
    REG_EMM3H = 231
    REG_EMM4H = 232
    REG_EMM5H = 233
    REG_EMM6H = 234
    REG_EMM7H = 235
    REG_MM00 = 236
    REG_MM01 = 237
    REG_MM10 = 238
    REG_MM11 = 239
    REG_MM20 = 240
    REG_MM21 = 241
    REG_MM30 = 242
    REG_MM31 = 243
    REG_MM40 = 244
    REG_MM41 = 245
    REG_MM50 = 246
    REG_MM51 = 247
    REG_MM60 = 248
    REG_MM61 = 249
    REG_MM70 = 250
    REG_MM71 = 251
    REG_YMM0 = 252
    REG_YMM1 = 253
    REG_YMM2 = 254
    REG_YMM3 = 255
    REG_YMM4 = 256
    REG_YMM5 = 257
    REG_YMM6 = 258
    REG_YMM7 = 259
    REG_YMM0H = 260
    REG_YMM1H = 261
    REG_YMM2H = 262
    REG_YMM3H = 263
    REG_YMM4H = 264
    REG_YMM5H = 265
    REG_YMM6H = 266
    REG_YMM7H = 267
    REG_YMM0I0 = 268
    REG_YMM0I1 = 269
    REG_YMM0I2 = 270
    REG_YMM0I3 = 271
    REG_YMM1I0 = 272
    REG_YMM1I1 = 273
    REG_YMM1I2 = 274
    REG_YMM1I3 = 275
    REG_YMM2I0 = 276
    REG_YMM2I1 = 277
    REG_YMM2I2 = 278
    REG_YMM2I3 = 279
    REG_YMM3I0 = 280
    REG_YMM3I1 = 281
    REG_YMM3I2 = 282
    REG_YMM3I3 = 283
    REG_YMM4I0 = 284
    REG_YMM4I1 = 285
    REG_YMM4I2 = 286
    REG_YMM4I3 = 287
    REG_YMM5I0 = 288
    REG_YMM5I1 = 289
    REG_YMM5I2 = 290
    REG_YMM5I3 = 291
    REG_YMM6I0 = 292
    REG_YMM6I1 = 293
    REG_YMM6I2 = 294
    REG_YMM6I3 = 295
    REG_YMM7I0 = 296
    REG_YMM7I1 = 297
    REG_YMM7I2 = 298
    REG_YMM7I3 = 299
    REG_YMM0F0 = 300
    REG_YMM0F1 = 301
    REG_YMM0F2 = 302
    REG_YMM0F3 = 303
    REG_YMM0F4 = 304
    REG_YMM0F5 = 305
    REG_YMM0F6 = 306
    REG_YMM0F7 = 307
    REG_YMM1F0 = 308
    REG_YMM1F1 = 309
    REG_YMM1F2 = 310
    REG_YMM1F3 = 311
    REG_YMM1F4 = 312
    REG_YMM1F5 = 313
    REG_YMM1F6 = 314
    REG_YMM1F7 = 315
    REG_YMM2F0 = 316
    REG_YMM2F1 = 317
    REG_YMM2F2 = 318
    REG_YMM2F3 = 319
    REG_YMM2F4 = 320
    REG_YMM2F5 = 321
    REG_YMM2F6 = 322
    REG_YMM2F7 = 323
    REG_YMM3F0 = 324
    REG_YMM3F1 = 325
    REG_YMM3F2 = 326
    REG_YMM3F3 = 327
    REG_YMM3F4 = 328
    REG_YMM3F5 = 329
    REG_YMM3F6 = 330
    REG_YMM3F7 = 331
    REG_YMM4F0 = 332
    REG_YMM4F1 = 333
    REG_YMM4F2 = 334
    REG_YMM4F3 = 335
    REG_YMM4F4 = 336
    REG_YMM4F5 = 337
    REG_YMM4F6 = 338
    REG_YMM4F7 = 339
    REG_YMM5F0 = 340
    REG_YMM5F1 = 341
    REG_YMM5F2 = 342
    REG_YMM5F3 = 343
    REG_YMM5F4 = 344
    REG_YMM5F5 = 345
    REG_YMM5F6 = 346
    REG_YMM5F7 = 347
    REG_YMM6F0 = 348
    REG_YMM6F1 = 349
    REG_YMM6F2 = 350
    REG_YMM6F3 = 351
    REG_YMM6F4 = 352
    REG_YMM6F5 = 353
    REG_YMM6F6 = 354
    REG_YMM6F7 = 355
    REG_YMM7F0 = 356
    REG_YMM7F1 = 357
    REG_YMM7F2 = 358
    REG_YMM7F3 = 359
    REG_YMM7F4 = 360
    REG_YMM7F5 = 361
    REG_YMM7F6 = 362
    REG_YMM7F7 = 363
    REG_YMM0D0 = 364
    REG_YMM0D1 = 365
    REG_YMM0D2 = 366
    REG_YMM0D3 = 367
    REG_YMM1D0 = 368
    REG_YMM1D1 = 369
    REG_YMM1D2 = 370
    REG_YMM1D3 = 371
    REG_YMM2D0 = 372
    REG_YMM2D1 = 373
    REG_YMM2D2 = 374
    REG_YMM2D3 = 375
    REG_YMM3D0 = 376
    REG_YMM3D1 = 377
    REG_YMM3D2 = 378
    REG_YMM3D3 = 379
    REG_YMM4D0 = 380
    REG_YMM4D1 = 381
    REG_YMM4D2 = 382
    REG_YMM4D3 = 383
    REG_YMM5D0 = 384
    REG_YMM5D1 = 385
    REG_YMM5D2 = 386
    REG_YMM5D3 = 387
    REG_YMM6D0 = 388
    REG_YMM6D1 = 389
    REG_YMM6D2 = 390
    REG_YMM6D3 = 391
    REG_YMM7D0 = 392
    REG_YMM7D1 = 393
    REG_YMM7D2 = 394
    REG_YMM7D3 = 395
    REG_BND0 = 396
    REG_BND1 = 397
    REG_BND2 = 398
    REG_BND3 = 399
    REG_BNDCFGU = 400
    REG_BNDSTATUS = 401
    REG_ZMM0 = 402
    REG_ZMM1 = 403
    REG_ZMM2 = 404
    REG_ZMM3 = 405
    REG_ZMM4 = 406
    REG_ZMM5 = 407
    REG_ZMM6 = 408
    REG_ZMM7 = 409
    REG_ZMM0H = 410
    REG_ZMM1H = 411
    REG_ZMM2H = 412
    REG_ZMM3H = 413
    REG_ZMM4H = 414
    REG_ZMM5H = 415
    REG_ZMM6H = 416
    REG_ZMM7H = 417
    REG_K0 = 418
    REG_K1 = 419
    REG_K2 = 420
    REG_K3 = 421
    REG_K4 = 422
    REG_K5 = 423
    REG_K6 = 424
    REG_K7 = 425
    REG_SSP = 426
    R68_D0 = 0
    R68_D1 = 1
    R68_D2 = 2
    R68_D3 = 3
    R68_D4 = 4
    R68_D5 = 5
    R68_D6 = 6
    R68_D7 = 7
    R68_A0 = 8
    R68_A1 = 9
    R68_A2 = 10
    R68_A3 = 11
    R68_A4 = 12
    R68_A5 = 13
    R68_A6 = 14
    R68_A7 = 15
    R68_CCR = 16
    R68_SR = 17
    R68_USP = 18
    R68_MSP = 19
    R68_SFC = 20
    R68_DFC = 21
    R68_CACR = 22
    R68_VBR = 23
    R68_CAAR = 24
    R68_ISP = 25
    R68_PC = 26
    R68_FPCR = 28
    R68_FPSR = 29
    R68_FPIAR = 30
    R68_FP0 = 32
    R68_FP1 = 33
    R68_FP2 = 34
    R68_FP3 = 35
    R68_FP4 = 36
    R68_FP5 = 37
    R68_FP6 = 38
    R68_FP7 = 39
    R68_MMUSR030 = 41
    R68_MMUSR = 42
    R68_URP = 43
    R68_DTT0 = 44
    R68_DTT1 = 45
    R68_ITT0 = 46
    R68_ITT1 = 47
    R68_PSR = 51
    R68_PCSR = 52
    R68_VAL = 53
    R68_CRP = 54
    R68_SRP = 55
    R68_DRP = 56
    R68_TC = 57
    R68_AC = 58
    R68_SCC = 59
    R68_CAL = 60
    R68_TT0 = 61
    R68_TT1 = 62
    R68_BAD0 = 64
    R68_BAD1 = 65
    R68_BAD2 = 66
    R68_BAD3 = 67
    R68_BAD4 = 68
    R68_BAD5 = 69
    R68_BAD6 = 70
    R68_BAD7 = 71
    R68_BAC0 = 72
    R68_BAC1 = 73
    R68_BAC2 = 74
    R68_BAC3 = 75
    R68_BAC4 = 76
    R68_BAC5 = 77
    R68_BAC6 = 78
    R68_BAC7 = 79
    M4_NOREG = REG_NONE
    M4_IntZERO = 10
    M4_IntAT = 11
    M4_IntV0 = 12
    M4_IntV1 = 13
    M4_IntA0 = 14
    M4_IntA1 = 15
    M4_IntA2 = 16
    M4_IntA3 = 17
    M4_IntT0 = 18
    M4_IntT1 = 19
    M4_IntT2 = 20
    M4_IntT3 = 21
    M4_IntT4 = 22
    M4_IntT5 = 23
    M4_IntT6 = 24
    M4_IntT7 = 25
    M4_IntS0 = 26
    M4_IntS1 = 27
    M4_IntS2 = 28
    M4_IntS3 = 29
    M4_IntS4 = 30
    M4_IntS5 = 31
    M4_IntS6 = 32
    M4_IntS7 = 33
    M4_IntT8 = 34
    M4_IntT9 = 35
    M4_IntKT0 = 36
    M4_IntKT1 = 37
    M4_IntGP = 38
    M4_IntSP = 39
    M4_IntS8 = 40
    M4_IntRA = 41
    M4_IntLO = 42
    M4_IntHI = 43
    M4_Fir = 50
    M4_Psr = 51
    M4_FltF0 = 60
    M4_FltF1 = 61
    M4_FltF2 = 62
    M4_FltF3 = 63
    M4_FltF4 = 64
    M4_FltF5 = 65
    M4_FltF6 = 66
    M4_FltF7 = 67
    M4_FltF8 = 68
    M4_FltF9 = 69
    M4_FltF10 = 70
    M4_FltF11 = 71
    M4_FltF12 = 72
    M4_FltF13 = 73
    M4_FltF14 = 74
    M4_FltF15 = 75
    M4_FltF16 = 76
    M4_FltF17 = 77
    M4_FltF18 = 78
    M4_FltF19 = 79
    M4_FltF20 = 80
    M4_FltF21 = 81
    M4_FltF22 = 82
    M4_FltF23 = 83
    M4_FltF24 = 84
    M4_FltF25 = 85
    M4_FltF26 = 86
    M4_FltF27 = 87
    M4_FltF28 = 88
    M4_FltF29 = 89
    M4_FltF30 = 90
    M4_FltF31 = 91
    M4_FltFsr = 92
    ALPHA_NOREG = REG_NONE
    ALPHA_FltF0 = 10
    ALPHA_FltF1 = 11
    ALPHA_FltF2 = 12
    ALPHA_FltF3 = 13
    ALPHA_FltF4 = 14
    ALPHA_FltF5 = 15
    ALPHA_FltF6 = 16
    ALPHA_FltF7 = 17
    ALPHA_FltF8 = 18
    ALPHA_FltF9 = 19
    ALPHA_FltF10 = 20
    ALPHA_FltF11 = 21
    ALPHA_FltF12 = 22
    ALPHA_FltF13 = 23
    ALPHA_FltF14 = 24
    ALPHA_FltF15 = 25
    ALPHA_FltF16 = 26
    ALPHA_FltF17 = 27
    ALPHA_FltF18 = 28
    ALPHA_FltF19 = 29
    ALPHA_FltF20 = 30
    ALPHA_FltF21 = 31
    ALPHA_FltF22 = 32
    ALPHA_FltF23 = 33
    ALPHA_FltF24 = 34
    ALPHA_FltF25 = 35
    ALPHA_FltF26 = 36
    ALPHA_FltF27 = 37
    ALPHA_FltF28 = 38
    ALPHA_FltF29 = 39
    ALPHA_FltF30 = 40
    ALPHA_FltF31 = 41
    ALPHA_IntV0 = 42
    ALPHA_IntT0 = 43
    ALPHA_IntT1 = 44
    ALPHA_IntT2 = 45
    ALPHA_IntT3 = 46
    ALPHA_IntT4 = 47
    ALPHA_IntT5 = 48
    ALPHA_IntT6 = 49
    ALPHA_IntT7 = 50
    ALPHA_IntS0 = 51
    ALPHA_IntS1 = 52
    ALPHA_IntS2 = 53
    ALPHA_IntS3 = 54
    ALPHA_IntS4 = 55
    ALPHA_IntS5 = 56
    ALPHA_IntFP = 57
    ALPHA_IntA0 = 58
    ALPHA_IntA1 = 59
    ALPHA_IntA2 = 60
    ALPHA_IntA3 = 61
    ALPHA_IntA4 = 62
    ALPHA_IntA5 = 63
    ALPHA_IntT8 = 64
    ALPHA_IntT9 = 65
    ALPHA_IntT10 = 66
    ALPHA_IntT11 = 67
    ALPHA_IntRA = 68
    ALPHA_IntT12 = 69
    ALPHA_IntAT = 70
    ALPHA_IntGP = 71
    ALPHA_IntSP = 72
    ALPHA_IntZERO = 73
    ALPHA_Fpcr = 74
    ALPHA_Fir = 75
    ALPHA_Psr = 76
    ALPHA_FltFsr = 77
    ALPHA_SoftFpcr = 78
    PPC_GPR0 = 1
    PPC_GPR1 = 2
    PPC_GPR2 = 3
    PPC_GPR3 = 4
    PPC_GPR4 = 5
    PPC_GPR5 = 6
    PPC_GPR6 = 7
    PPC_GPR7 = 8
    PPC_GPR8 = 9
    PPC_GPR9 = 10
    PPC_GPR10 = 11
    PPC_GPR11 = 12
    PPC_GPR12 = 13
    PPC_GPR13 = 14
    PPC_GPR14 = 15
    PPC_GPR15 = 16
    PPC_GPR16 = 17
    PPC_GPR17 = 18
    PPC_GPR18 = 19
    PPC_GPR19 = 20
    PPC_GPR20 = 21
    PPC_GPR21 = 22
    PPC_GPR22 = 23
    PPC_GPR23 = 24
    PPC_GPR24 = 25
    PPC_GPR25 = 26
    PPC_GPR26 = 27
    PPC_GPR27 = 28
    PPC_GPR28 = 29
    PPC_GPR29 = 30
    PPC_GPR30 = 31
    PPC_GPR31 = 32
    PPC_CR = 33
    PPC_CR0 = 34
    PPC_CR1 = 35
    PPC_CR2 = 36
    PPC_CR3 = 37
    PPC_CR4 = 38
    PPC_CR5 = 39
    PPC_CR6 = 40
    PPC_CR7 = 41
    PPC_FPR0 = 42
    PPC_FPR1 = 43
    PPC_FPR2 = 44
    PPC_FPR3 = 45
    PPC_FPR4 = 46
    PPC_FPR5 = 47
    PPC_FPR6 = 48
    PPC_FPR7 = 49
    PPC_FPR8 = 50
    PPC_FPR9 = 51
    PPC_FPR10 = 52
    PPC_FPR11 = 53
    PPC_FPR12 = 54
    PPC_FPR13 = 55
    PPC_FPR14 = 56
    PPC_FPR15 = 57
    PPC_FPR16 = 58
    PPC_FPR17 = 59
    PPC_FPR18 = 60
    PPC_FPR19 = 61
    PPC_FPR20 = 62
    PPC_FPR21 = 63
    PPC_FPR22 = 64
    PPC_FPR23 = 65
    PPC_FPR24 = 66
    PPC_FPR25 = 67
    PPC_FPR26 = 68
    PPC_FPR27 = 69
    PPC_FPR28 = 70
    PPC_FPR29 = 71
    PPC_FPR30 = 72
    PPC_FPR31 = 73
    PPC_FPSCR = 74
    PPC_MSR = 75
    PPC_SR0 = 76
    PPC_SR1 = 77
    PPC_SR2 = 78
    PPC_SR3 = 79
    PPC_SR4 = 80
    PPC_SR5 = 81
    PPC_SR6 = 82
    PPC_SR7 = 83
    PPC_SR8 = 84
    PPC_SR9 = 85
    PPC_SR10 = 86
    PPC_SR11 = 87
    PPC_SR12 = 88
    PPC_SR13 = 89
    PPC_SR14 = 90
    PPC_SR15 = 91
    PPC_PC = 99
    PPC_MQ = 100
    PPC_XER = 101
    PPC_RTCU = 104
    PPC_RTCL = 105
    PPC_LR = 108
    PPC_CTR = 109
    PPC_COMPARE = 110
    PPC_COUNT = 111
    PPC_DSISR = 118
    PPC_DAR = 119
    PPC_DEC = 122
    PPC_SDR1 = 125
    PPC_SRR0 = 126
    PPC_SRR1 = 127
    PPC_SPRG0 = 372
    PPC_SPRG1 = 373
    PPC_SPRG2 = 374
    PPC_SPRG3 = 375
    PPC_ASR = 280
    PPC_EAR = 382
    PPC_PVR = 287
    PPC_BAT0U = 628
    PPC_BAT0L = 629
    PPC_BAT1U = 630
    PPC_BAT1L = 631
    PPC_BAT2U = 632
    PPC_BAT2L = 633
    PPC_BAT3U = 634
    PPC_BAT3L = 635
    PPC_DBAT0U = 636
    PPC_DBAT0L = 637
    PPC_DBAT1U = 638
    PPC_DBAT1L = 639
    PPC_DBAT2U = 640
    PPC_DBAT2L = 641
    PPC_DBAT3U = 642
    PPC_DBAT3L = 643
    PPC_PMR0 = 1044
    PPC_PMR1 = 1045
    PPC_PMR2 = 1046
    PPC_PMR3 = 1047
    PPC_PMR4 = 1048
    PPC_PMR5 = 1049
    PPC_PMR6 = 1050
    PPC_PMR7 = 1051
    PPC_PMR8 = 1052
    PPC_PMR9 = 1053
    PPC_PMR10 = 1054
    PPC_PMR11 = 1055
    PPC_PMR12 = 1056
    PPC_PMR13 = 1057
    PPC_PMR14 = 1058
    PPC_PMR15 = 1059
    PPC_DMISS = 1076
    PPC_DCMP = 1077
    PPC_HASH1 = 1078
    PPC_HASH2 = 1079
    PPC_IMISS = 1080
    PPC_ICMP = 1081
    PPC_RPA = 1082
    PPC_HID0 = 1108
    PPC_HID1 = 1109
    PPC_HID2 = 1110
    PPC_HID3 = 1111
    PPC_HID4 = 1112
    PPC_HID5 = 1113
    PPC_HID6 = 1114
    PPC_HID7 = 1115
    PPC_HID8 = 1116
    PPC_HID9 = 1117
    PPC_HID10 = 1118
    PPC_HID11 = 1119
    PPC_HID12 = 1120
    PPC_HID13 = 1121
    PPC_HID14 = 1122
    PPC_HID15 = 1123
    JAVA_PC = 1
    SH3_NOREG = REG_NONE
    SH3_IntR0 = 10
    SH3_IntR1 = 11
    SH3_IntR2 = 12
    SH3_IntR3 = 13
    SH3_IntR4 = 14
    SH3_IntR5 = 15
    SH3_IntR6 = 16
    SH3_IntR7 = 17
    SH3_IntR8 = 18
    SH3_IntR9 = 19
    SH3_IntR10 = 20
    SH3_IntR11 = 21
    SH3_IntR12 = 22
    SH3_IntR13 = 23
    SH3_IntFp = 24
    SH3_IntSp = 25
    SH3_Gbr = 38
    SH3_Pr = 39
    SH3_Mach = 40
    SH3_Macl = 41
    SH3_Pc = 50
    SH3_Sr = 51
    SH3_BarA = 60
    SH3_BasrA = 61
    SH3_BamrA = 62
    SH3_BbrA = 63
    SH3_BarB = 64
    SH3_BasrB = 65
    SH3_BamrB = 66
    SH3_BbrB = 67
    SH3_BdrB = 68
    SH3_BdmrB = 69
    SH3_Brcr = 70
    SH_Fpscr = 75
    SH_Fpul = 76
    SH_FpR0 = 80
    SH_FpR1 = 81
    SH_FpR2 = 82
    SH_FpR3 = 83
    SH_FpR4 = 84
    SH_FpR5 = 85
    SH_FpR6 = 86
    SH_FpR7 = 87
    SH_FpR8 = 88
    SH_FpR9 = 89
    SH_FpR10 = 90
    SH_FpR11 = 91
    SH_FpR12 = 92
    SH_FpR13 = 93
    SH_FpR14 = 94
    SH_FpR15 = 95
    SH_XFpR0 = 96
    SH_XFpR1 = 97
    SH_XFpR2 = 98
    SH_XFpR3 = 99
    SH_XFpR4 = 100
    SH_XFpR5 = 101
    SH_XFpR6 = 102
    SH_XFpR7 = 103
    SH_XFpR8 = 104
    SH_XFpR9 = 105
    SH_XFpR10 = 106
    SH_XFpR11 = 107
    SH_XFpR12 = 108
    SH_XFpR13 = 109
    SH_XFpR14 = 110
    SH_XFpR15 = 111
    ARM_NOREG = REG_NONE
    ARM_R0 = 10
    ARM_R1 = 11
    ARM_R2 = 12
    ARM_R3 = 13
    ARM_R4 = 14
    ARM_R5 = 15
    ARM_R6 = 16
    ARM_R7 = 17
    ARM_R8 = 18
    ARM_R9 = 19
    ARM_R10 = 20
    ARM_R11 = 21
    ARM_R12 = 22
    ARM_SP = 23
    ARM_LR = 24
    ARM_PC = 25
    ARM_CPSR = 26
    ARM_ACC0 = 27
    ARM_FPSCR = 40
    ARM_FPEXC = 41
    ARM_FS0 = 50
    ARM_FS1 = 51
    ARM_FS2 = 52
    ARM_FS3 = 53
    ARM_FS4 = 54
    ARM_FS5 = 55
    ARM_FS6 = 56
    ARM_FS7 = 57
    ARM_FS8 = 58
    ARM_FS9 = 59
    ARM_FS10 = 60
    ARM_FS11 = 61
    ARM_FS12 = 62
    ARM_FS13 = 63
    ARM_FS14 = 64
    ARM_FS15 = 65
    ARM_FS16 = 66
    ARM_FS17 = 67
    ARM_FS18 = 68
    ARM_FS19 = 69
    ARM_FS20 = 70
    ARM_FS21 = 71
    ARM_FS22 = 72
    ARM_FS23 = 73
    ARM_FS24 = 74
    ARM_FS25 = 75
    ARM_FS26 = 76
    ARM_FS27 = 77
    ARM_FS28 = 78
    ARM_FS29 = 79
    ARM_FS30 = 80
    ARM_FS31 = 81
    ARM_FPEXTRA0 = 90
    ARM_FPEXTRA1 = 91
    ARM_FPEXTRA2 = 92
    ARM_FPEXTRA3 = 93
    ARM_FPEXTRA4 = 94
    ARM_FPEXTRA5 = 95
    ARM_FPEXTRA6 = 96
    ARM_FPEXTRA7 = 97
    ARM_WR0 = 128
    ARM_WR1 = 129
    ARM_WR2 = 130
    ARM_WR3 = 131
    ARM_WR4 = 132
    ARM_WR5 = 133
    ARM_WR6 = 134
    ARM_WR7 = 135
    ARM_WR8 = 136
    ARM_WR9 = 137
    ARM_WR10 = 138
    ARM_WR11 = 139
    ARM_WR12 = 140
    ARM_WR13 = 141
    ARM_WR14 = 142
    ARM_WR15 = 143
    ARM_WCID = 144
    ARM_WCON = 145
    ARM_WCSSF = 146
    ARM_WCASF = 147
    ARM_WC4 = 148
    ARM_WC5 = 149
    ARM_WC6 = 150
    ARM_WC7 = 151
    ARM_WCGR0 = 152
    ARM_WCGR1 = 153
    ARM_WCGR2 = 154
    ARM_WCGR3 = 155
    ARM_WC12 = 156
    ARM_WC13 = 157
    ARM_WC14 = 158
    ARM_WC15 = 159
    ARM_FS32 = 200
    ARM_FS33 = 201
    ARM_FS34 = 202
    ARM_FS35 = 203
    ARM_FS36 = 204
    ARM_FS37 = 205
    ARM_FS38 = 206
    ARM_FS39 = 207
    ARM_FS40 = 208
    ARM_FS41 = 209
    ARM_FS42 = 210
    ARM_FS43 = 211
    ARM_FS44 = 212
    ARM_FS45 = 213
    ARM_FS46 = 214
    ARM_FS47 = 215
    ARM_FS48 = 216
    ARM_FS49 = 217
    ARM_FS50 = 218
    ARM_FS51 = 219
    ARM_FS52 = 220
    ARM_FS53 = 221
    ARM_FS54 = 222
    ARM_FS55 = 223
    ARM_FS56 = 224
    ARM_FS57 = 225
    ARM_FS58 = 226
    ARM_FS59 = 227
    ARM_FS60 = 228
    ARM_FS61 = 229
    ARM_FS62 = 230
    ARM_FS63 = 231
    ARM_ND0 = 300
    ARM_ND1 = 301
    ARM_ND2 = 302
    ARM_ND3 = 303
    ARM_ND4 = 304
    ARM_ND5 = 305
    ARM_ND6 = 306
    ARM_ND7 = 307
    ARM_ND8 = 308
    ARM_ND9 = 309
    ARM_ND10 = 310
    ARM_ND11 = 311
    ARM_ND12 = 312
    ARM_ND13 = 313
    ARM_ND14 = 314
    ARM_ND15 = 315
    ARM_ND16 = 316
    ARM_ND17 = 317
    ARM_ND18 = 318
    ARM_ND19 = 319
    ARM_ND20 = 320
    ARM_ND21 = 321
    ARM_ND22 = 322
    ARM_ND23 = 323
    ARM_ND24 = 324
    ARM_ND25 = 325
    ARM_ND26 = 326
    ARM_ND27 = 327
    ARM_ND28 = 328
    ARM_ND29 = 329
    ARM_ND30 = 330
    ARM_ND31 = 331
    ARM_NQ0 = 400
    ARM_NQ1 = 401
    ARM_NQ2 = 402
    ARM_NQ3 = 403
    ARM_NQ4 = 404
    ARM_NQ5 = 405
    ARM_NQ6 = 406
    ARM_NQ7 = 407
    ARM_NQ8 = 408
    ARM_NQ9 = 409
    ARM_NQ10 = 410
    ARM_NQ11 = 411
    ARM_NQ12 = 412
    ARM_NQ13 = 413
    ARM_NQ14 = 414
    ARM_NQ15 = 415
    ARM64_NOREG = REG_NONE
    ARM64_W0 = 10
    ARM64_W1 = 11
    ARM64_W2 = 12
    ARM64_W3 = 13
    ARM64_W4 = 14
    ARM64_W5 = 15
    ARM64_W6 = 16
    ARM64_W7 = 17
    ARM64_W8 = 18
    ARM64_W9 = 19
    ARM64_W10 = 20
    ARM64_W11 = 21
    ARM64_W12 = 22
    ARM64_W13 = 23
    ARM64_W14 = 24
    ARM64_W15 = 25
    ARM64_W16 = 26
    ARM64_W17 = 27
    ARM64_W18 = 28
    ARM64_W19 = 29
    ARM64_W20 = 30
    ARM64_W21 = 31
    ARM64_W22 = 32
    ARM64_W23 = 33
    ARM64_W24 = 34
    ARM64_W25 = 35
    ARM64_W26 = 36
    ARM64_W27 = 37
    ARM64_W28 = 38
    ARM64_W29 = 39
    ARM64_W30 = 40
    ARM64_WZR = 41
    ARM64_X0 = 50
    ARM64_X1 = 51
    ARM64_X2 = 52
    ARM64_X3 = 53
    ARM64_X4 = 54
    ARM64_X5 = 55
    ARM64_X6 = 56
    ARM64_X7 = 57
    ARM64_X8 = 58
    ARM64_X9 = 59
    ARM64_X10 = 60
    ARM64_X11 = 61
    ARM64_X12 = 62
    ARM64_X13 = 63
    ARM64_X14 = 64
    ARM64_X15 = 65
    ARM64_IP0 = 66
    ARM64_IP1 = 67
    ARM64_X18 = 68
    ARM64_X19 = 69
    ARM64_X20 = 70
    ARM64_X21 = 71
    ARM64_X22 = 72
    ARM64_X23 = 73
    ARM64_X24 = 74
    ARM64_X25 = 75
    ARM64_X26 = 76
    ARM64_X27 = 77
    ARM64_X28 = 78
    ARM64_FP = 79
    ARM64_LR = 80
    ARM64_SP = 81
    ARM64_ZR = 82
    ARM64_PC = 83
    ARM64_NZCV = 90
    ARM64_CPSR = 91
    ARM64_S0 = 100
    ARM64_S1 = 101
    ARM64_S2 = 102
    ARM64_S3 = 103
    ARM64_S4 = 104
    ARM64_S5 = 105
    ARM64_S6 = 106
    ARM64_S7 = 107
    ARM64_S8 = 108
    ARM64_S9 = 109
    ARM64_S10 = 110
    ARM64_S11 = 111
    ARM64_S12 = 112
    ARM64_S13 = 113
    ARM64_S14 = 114
    ARM64_S15 = 115
    ARM64_S16 = 116
    ARM64_S17 = 117
    ARM64_S18 = 118
    ARM64_S19 = 119
    ARM64_S20 = 120
    ARM64_S21 = 121
    ARM64_S22 = 122
    ARM64_S23 = 123
    ARM64_S24 = 124
    ARM64_S25 = 125
    ARM64_S26 = 126
    ARM64_S27 = 127
    ARM64_S28 = 128
    ARM64_S29 = 129
    ARM64_S30 = 130
    ARM64_S31 = 131
    ARM64_D0 = 140
    ARM64_D1 = 141
    ARM64_D2 = 142
    ARM64_D3 = 143
    ARM64_D4 = 144
    ARM64_D5 = 145
    ARM64_D6 = 146
    ARM64_D7 = 147
    ARM64_D8 = 148
    ARM64_D9 = 149
    ARM64_D10 = 150
    ARM64_D11 = 151
    ARM64_D12 = 152
    ARM64_D13 = 153
    ARM64_D14 = 154
    ARM64_D15 = 155
    ARM64_D16 = 156
    ARM64_D17 = 157
    ARM64_D18 = 158
    ARM64_D19 = 159
    ARM64_D20 = 160
    ARM64_D21 = 161
    ARM64_D22 = 162
    ARM64_D23 = 163
    ARM64_D24 = 164
    ARM64_D25 = 165
    ARM64_D26 = 166
    ARM64_D27 = 167
    ARM64_D28 = 168
    ARM64_D29 = 169
    ARM64_D30 = 170
    ARM64_D31 = 171
    ARM64_Q0 = 180
    ARM64_Q1 = 181
    ARM64_Q2 = 182
    ARM64_Q3 = 183
    ARM64_Q4 = 184
    ARM64_Q5 = 185
    ARM64_Q6 = 186
    ARM64_Q7 = 187
    ARM64_Q8 = 188
    ARM64_Q9 = 189
    ARM64_Q10 = 190
    ARM64_Q11 = 191
    ARM64_Q12 = 192
    ARM64_Q13 = 193
    ARM64_Q14 = 194
    ARM64_Q15 = 195
    ARM64_Q16 = 196
    ARM64_Q17 = 197
    ARM64_Q18 = 198
    ARM64_Q19 = 199
    ARM64_Q20 = 200
    ARM64_Q21 = 201
    ARM64_Q22 = 202
    ARM64_Q23 = 203
    ARM64_Q24 = 204
    ARM64_Q25 = 205
    ARM64_Q26 = 206
    ARM64_Q27 = 207
    ARM64_Q28 = 208
    ARM64_Q29 = 209
    ARM64_Q30 = 210
    ARM64_Q31 = 211
    ARM64_FPSR = 220
    ARM64_FPCR = 221
    ARM64_B0 = 230
    ARM64_B1 = 231
    ARM64_B2 = 232
    ARM64_B3 = 233
    ARM64_B4 = 234
    ARM64_B5 = 235
    ARM64_B6 = 236
    ARM64_B7 = 237
    ARM64_B8 = 238
    ARM64_B9 = 239
    ARM64_B10 = 240
    ARM64_B11 = 241
    ARM64_B12 = 242
    ARM64_B13 = 243
    ARM64_B14 = 244
    ARM64_B15 = 245
    ARM64_B16 = 246
    ARM64_B17 = 247
    ARM64_B18 = 248
    ARM64_B19 = 249
    ARM64_B20 = 250
    ARM64_B21 = 251
    ARM64_B22 = 252
    ARM64_B23 = 253
    ARM64_B24 = 254
    ARM64_B25 = 255
    ARM64_B26 = 256
    ARM64_B27 = 257
    ARM64_B28 = 258
    ARM64_B29 = 259
    ARM64_B30 = 260
    ARM64_B31 = 261
    ARM64_H0 = 270
    ARM64_H1 = 271
    ARM64_H2 = 272
    ARM64_H3 = 273
    ARM64_H4 = 274
    ARM64_H5 = 275
    ARM64_H6 = 276
    ARM64_H7 = 277
    ARM64_H8 = 278
    ARM64_H9 = 279
    ARM64_H10 = 280
    ARM64_H11 = 281
    ARM64_H12 = 282
    ARM64_H13 = 283
    ARM64_H14 = 284
    ARM64_H15 = 285
    ARM64_H16 = 286
    ARM64_H17 = 287
    ARM64_H18 = 288
    ARM64_H19 = 289
    ARM64_H20 = 290
    ARM64_H21 = 291
    ARM64_H22 = 292
    ARM64_H23 = 293
    ARM64_H24 = 294
    ARM64_H25 = 295
    ARM64_H26 = 296
    ARM64_H27 = 297
    ARM64_H28 = 298
    ARM64_H29 = 299
    ARM64_H30 = 300
    ARM64_H31 = 301
    ARM64_V0 = 310
    ARM64_V1 = 311
    ARM64_V2 = 312
    ARM64_V3 = 313
    ARM64_V4 = 314
    ARM64_V5 = 315
    ARM64_V6 = 316
    ARM64_V7 = 317
    ARM64_V8 = 318
    ARM64_V9 = 319
    ARM64_V10 = 320
    ARM64_V11 = 321
    ARM64_V12 = 322
    ARM64_V13 = 323
    ARM64_V14 = 324
    ARM64_V15 = 325
    ARM64_V16 = 326
    ARM64_V17 = 327
    ARM64_V18 = 328
    ARM64_V19 = 329
    ARM64_V20 = 330
    ARM64_V21 = 331
    ARM64_V22 = 332
    ARM64_V23 = 333
    ARM64_V24 = 334
    ARM64_V25 = 335
    ARM64_V26 = 336
    ARM64_V27 = 337
    ARM64_V28 = 338
    ARM64_V29 = 339
    ARM64_V30 = 340
    ARM64_V31 = 341
    ARM64_Q0H = 350
    ARM64_Q1H = 351
    ARM64_Q2H = 352
    ARM64_Q3H = 353
    ARM64_Q4H = 354
    ARM64_Q5H = 355
    ARM64_Q6H = 356
    ARM64_Q7H = 357
    ARM64_Q8H = 358
    ARM64_Q9H = 359
    ARM64_Q10H = 360
    ARM64_Q11H = 361
    ARM64_Q12H = 362
    ARM64_Q13H = 363
    ARM64_Q14H = 364
    ARM64_Q15H = 365
    ARM64_Q16H = 366
    ARM64_Q17H = 367
    ARM64_Q18H = 368
    ARM64_Q19H = 369
    ARM64_Q20H = 370
    ARM64_Q21H = 371
    ARM64_Q22H = 372
    ARM64_Q23H = 373
    ARM64_Q24H = 374
    ARM64_Q25H = 375
    ARM64_Q26H = 376
    ARM64_Q27H = 377
    ARM64_Q28H = 378
    ARM64_Q29H = 379
    ARM64_Q30H = 380
    ARM64_Q31H = 381
    IA64_NOREG = REG_NONE
    IA64_Br0 = 512
    IA64_Br1 = 513
    IA64_Br2 = 514
    IA64_Br3 = 515
    IA64_Br4 = 516
    IA64_Br5 = 517
    IA64_Br6 = 518
    IA64_Br7 = 519
    IA64_P0 = 704
    IA64_P1 = 705
    IA64_P2 = 706
    IA64_P3 = 707
    IA64_P4 = 708
    IA64_P5 = 709
    IA64_P6 = 710
    IA64_P7 = 711
    IA64_P8 = 712
    IA64_P9 = 713
    IA64_P10 = 714
    IA64_P11 = 715
    IA64_P12 = 716
    IA64_P13 = 717
    IA64_P14 = 718
    IA64_P15 = 719
    IA64_P16 = 720
    IA64_P17 = 721
    IA64_P18 = 722
    IA64_P19 = 723
    IA64_P20 = 724
    IA64_P21 = 725
    IA64_P22 = 726
    IA64_P23 = 727
    IA64_P24 = 728
    IA64_P25 = 729
    IA64_P26 = 730
    IA64_P27 = 731
    IA64_P28 = 732
    IA64_P29 = 733
    IA64_P30 = 734
    IA64_P31 = 735
    IA64_P32 = 736
    IA64_P33 = 737
    IA64_P34 = 738
    IA64_P35 = 739
    IA64_P36 = 740
    IA64_P37 = 741
    IA64_P38 = 742
    IA64_P39 = 743
    IA64_P40 = 744
    IA64_P41 = 745
    IA64_P42 = 746
    IA64_P43 = 747
    IA64_P44 = 748
    IA64_P45 = 749
    IA64_P46 = 750
    IA64_P47 = 751
    IA64_P48 = 752
    IA64_P49 = 753
    IA64_P50 = 754
    IA64_P51 = 755
    IA64_P52 = 756
    IA64_P53 = 757
    IA64_P54 = 758
    IA64_P55 = 759
    IA64_P56 = 760
    IA64_P57 = 761
    IA64_P58 = 762
    IA64_P59 = 763
    IA64_P60 = 764
    IA64_P61 = 765
    IA64_P62 = 766
    IA64_P63 = 767
    IA64_Preds = 768
    IA64_IntH0 = 832
    IA64_IntH1 = 833
    IA64_IntH2 = 834
    IA64_IntH3 = 835
    IA64_IntH4 = 836
    IA64_IntH5 = 837
    IA64_IntH6 = 838
    IA64_IntH7 = 839
    IA64_IntH8 = 840
    IA64_IntH9 = 841
    IA64_IntH10 = 842
    IA64_IntH11 = 843
    IA64_IntH12 = 844
    IA64_IntH13 = 845
    IA64_IntH14 = 846
    IA64_IntH15 = 847
    IA64_Ip = 1016
    IA64_Umask = 1017
    IA64_Cfm = 1018
    IA64_Psr = 1019
    IA64_Nats = 1020
    IA64_Nats2 = 1021
    IA64_Nats3 = 1022
    IA64_IntR0 = 1024
    IA64_IntR1 = 1025
    IA64_IntR2 = 1026
    IA64_IntR3 = 1027
    IA64_IntR4 = 1028
    IA64_IntR5 = 1029
    IA64_IntR6 = 1030
    IA64_IntR7 = 1031
    IA64_IntR8 = 1032
    IA64_IntR9 = 1033
    IA64_IntR10 = 1034
    IA64_IntR11 = 1035
    IA64_IntR12 = 1036
    IA64_IntR13 = 1037
    IA64_IntR14 = 1038
    IA64_IntR15 = 1039
    IA64_IntR16 = 1040
    IA64_IntR17 = 1041
    IA64_IntR18 = 1042
    IA64_IntR19 = 1043
    IA64_IntR20 = 1044
    IA64_IntR21 = 1045
    IA64_IntR22 = 1046
    IA64_IntR23 = 1047
    IA64_IntR24 = 1048
    IA64_IntR25 = 1049
    IA64_IntR26 = 1050
    IA64_IntR27 = 1051
    IA64_IntR28 = 1052
    IA64_IntR29 = 1053
    IA64_IntR30 = 1054
    IA64_IntR31 = 1055
    IA64_IntR32 = 1056
    IA64_IntR33 = 1057
    IA64_IntR34 = 1058
    IA64_IntR35 = 1059
    IA64_IntR36 = 1060
    IA64_IntR37 = 1061
    IA64_IntR38 = 1062
    IA64_IntR39 = 1063
    IA64_IntR40 = 1064
    IA64_IntR41 = 1065
    IA64_IntR42 = 1066
    IA64_IntR43 = 1067
    IA64_IntR44 = 1068
    IA64_IntR45 = 1069
    IA64_IntR46 = 1070
    IA64_IntR47 = 1071
    IA64_IntR48 = 1072
    IA64_IntR49 = 1073
    IA64_IntR50 = 1074
    IA64_IntR51 = 1075
    IA64_IntR52 = 1076
    IA64_IntR53 = 1077
    IA64_IntR54 = 1078
    IA64_IntR55 = 1079
    IA64_IntR56 = 1080
    IA64_IntR57 = 1081
    IA64_IntR58 = 1082
    IA64_IntR59 = 1083
    IA64_IntR60 = 1084
    IA64_IntR61 = 1085
    IA64_IntR62 = 1086
    IA64_IntR63 = 1087
    IA64_IntR64 = 1088
    IA64_IntR65 = 1089
    IA64_IntR66 = 1090
    IA64_IntR67 = 1091
    IA64_IntR68 = 1092
    IA64_IntR69 = 1093
    IA64_IntR70 = 1094
    IA64_IntR71 = 1095
    IA64_IntR72 = 1096
    IA64_IntR73 = 1097
    IA64_IntR74 = 1098
    IA64_IntR75 = 1099
    IA64_IntR76 = 1100
    IA64_IntR77 = 1101
    IA64_IntR78 = 1102
    IA64_IntR79 = 1103
    IA64_IntR80 = 1104
    IA64_IntR81 = 1105
    IA64_IntR82 = 1106
    IA64_IntR83 = 1107
    IA64_IntR84 = 1108
    IA64_IntR85 = 1109
    IA64_IntR86 = 1110
    IA64_IntR87 = 1111
    IA64_IntR88 = 1112
    IA64_IntR89 = 1113
    IA64_IntR90 = 1114
    IA64_IntR91 = 1115
    IA64_IntR92 = 1116
    IA64_IntR93 = 1117
    IA64_IntR94 = 1118
    IA64_IntR95 = 1119
    IA64_IntR96 = 1120
    IA64_IntR97 = 1121
    IA64_IntR98 = 1122
    IA64_IntR99 = 1123
    IA64_IntR100 = 1124
    IA64_IntR101 = 1125
    IA64_IntR102 = 1126
    IA64_IntR103 = 1127
    IA64_IntR104 = 1128
    IA64_IntR105 = 1129
    IA64_IntR106 = 1130
    IA64_IntR107 = 1131
    IA64_IntR108 = 1132
    IA64_IntR109 = 1133
    IA64_IntR110 = 1134
    IA64_IntR111 = 1135
    IA64_IntR112 = 1136
    IA64_IntR113 = 1137
    IA64_IntR114 = 1138
    IA64_IntR115 = 1139
    IA64_IntR116 = 1140
    IA64_IntR117 = 1141
    IA64_IntR118 = 1142
    IA64_IntR119 = 1143
    IA64_IntR120 = 1144
    IA64_IntR121 = 1145
    IA64_IntR122 = 1146
    IA64_IntR123 = 1147
    IA64_IntR124 = 1148
    IA64_IntR125 = 1149
    IA64_IntR126 = 1150
    IA64_IntR127 = 1151
    IA64_FltF0 = 2048
    IA64_FltF1 = 2049
    IA64_FltF2 = 2050
    IA64_FltF3 = 2051
    IA64_FltF4 = 2052
    IA64_FltF5 = 2053
    IA64_FltF6 = 2054
    IA64_FltF7 = 2055
    IA64_FltF8 = 2056
    IA64_FltF9 = 2057
    IA64_FltF10 = 2058
    IA64_FltF11 = 2059
    IA64_FltF12 = 2060
    IA64_FltF13 = 2061
    IA64_FltF14 = 2062
    IA64_FltF15 = 2063
    IA64_FltF16 = 2064
    IA64_FltF17 = 2065
    IA64_FltF18 = 2066
    IA64_FltF19 = 2067
    IA64_FltF20 = 2068
    IA64_FltF21 = 2069
    IA64_FltF22 = 2070
    IA64_FltF23 = 2071
    IA64_FltF24 = 2072
    IA64_FltF25 = 2073
    IA64_FltF26 = 2074
    IA64_FltF27 = 2075
    IA64_FltF28 = 2076
    IA64_FltF29 = 2077
    IA64_FltF30 = 2078
    IA64_FltF31 = 2079
    IA64_FltF32 = 2080
    IA64_FltF33 = 2081
    IA64_FltF34 = 2082
    IA64_FltF35 = 2083
    IA64_FltF36 = 2084
    IA64_FltF37 = 2085
    IA64_FltF38 = 2086
    IA64_FltF39 = 2087
    IA64_FltF40 = 2088
    IA64_FltF41 = 2089
    IA64_FltF42 = 2090
    IA64_FltF43 = 2091
    IA64_FltF44 = 2092
    IA64_FltF45 = 2093
    IA64_FltF46 = 2094
    IA64_FltF47 = 2095
    IA64_FltF48 = 2096
    IA64_FltF49 = 2097
    IA64_FltF50 = 2098
    IA64_FltF51 = 2099
    IA64_FltF52 = 2100
    IA64_FltF53 = 2101
    IA64_FltF54 = 2102
    IA64_FltF55 = 2103
    IA64_FltF56 = 2104
    IA64_FltF57 = 2105
    IA64_FltF58 = 2106
    IA64_FltF59 = 2107
    IA64_FltF60 = 2108
    IA64_FltF61 = 2109
    IA64_FltF62 = 2110
    IA64_FltF63 = 2111
    IA64_FltF64 = 2112
    IA64_FltF65 = 2113
    IA64_FltF66 = 2114
    IA64_FltF67 = 2115
    IA64_FltF68 = 2116
    IA64_FltF69 = 2117
    IA64_FltF70 = 2118
    IA64_FltF71 = 2119
    IA64_FltF72 = 2120
    IA64_FltF73 = 2121
    IA64_FltF74 = 2122
    IA64_FltF75 = 2123
    IA64_FltF76 = 2124
    IA64_FltF77 = 2125
    IA64_FltF78 = 2126
    IA64_FltF79 = 2127
    IA64_FltF80 = 2128
    IA64_FltF81 = 2129
    IA64_FltF82 = 2130
    IA64_FltF83 = 2131
    IA64_FltF84 = 2132
    IA64_FltF85 = 2133
    IA64_FltF86 = 2134
    IA64_FltF87 = 2135
    IA64_FltF88 = 2136
    IA64_FltF89 = 2137
    IA64_FltF90 = 2138
    IA64_FltF91 = 2139
    IA64_FltF92 = 2140
    IA64_FltF93 = 2141
    IA64_FltF94 = 2142
    IA64_FltF95 = 2143
    IA64_FltF96 = 2144
    IA64_FltF97 = 2145
    IA64_FltF98 = 2146
    IA64_FltF99 = 2147
    IA64_FltF100 = 2148
    IA64_FltF101 = 2149
    IA64_FltF102 = 2150
    IA64_FltF103 = 2151
    IA64_FltF104 = 2152
    IA64_FltF105 = 2153
    IA64_FltF106 = 2154
    IA64_FltF107 = 2155
    IA64_FltF108 = 2156
    IA64_FltF109 = 2157
    IA64_FltF110 = 2158
    IA64_FltF111 = 2159
    IA64_FltF112 = 2160
    IA64_FltF113 = 2161
    IA64_FltF114 = 2162
    IA64_FltF115 = 2163
    IA64_FltF116 = 2164
    IA64_FltF117 = 2165
    IA64_FltF118 = 2166
    IA64_FltF119 = 2167
    IA64_FltF120 = 2168
    IA64_FltF121 = 2169
    IA64_FltF122 = 2170
    IA64_FltF123 = 2171
    IA64_FltF124 = 2172
    IA64_FltF125 = 2173
    IA64_FltF126 = 2174
    IA64_FltF127 = 2175
    IA64_ApKR0 = 3072
    IA64_ApKR1 = 3073
    IA64_ApKR2 = 3074
    IA64_ApKR3 = 3075
    IA64_ApKR4 = 3076
    IA64_ApKR5 = 3077
    IA64_ApKR6 = 3078
    IA64_ApKR7 = 3079
    IA64_AR8 = 3080
    IA64_AR9 = 3081
    IA64_AR10 = 3082
    IA64_AR11 = 3083
    IA64_AR12 = 3084
    IA64_AR13 = 3085
    IA64_AR14 = 3086
    IA64_AR15 = 3087
    IA64_RsRSC = 3088
    IA64_RsBSP = 3089
    IA64_RsBSPSTORE = 3090
    IA64_RsRNAT = 3091
    IA64_AR20 = 3092
    IA64_StFCR = 3093
    IA64_AR22 = 3094
    IA64_AR23 = 3095
    IA64_EFLAG = 3096
    IA64_CSD = 3097
    IA64_SSD = 3098
    IA64_CFLG = 3099
    IA64_StFSR = 3100
    IA64_StFIR = 3101
    IA64_StFDR = 3102
    IA64_AR31 = 3103
    IA64_ApCCV = 3104
    IA64_AR33 = 3105
    IA64_AR34 = 3106
    IA64_AR35 = 3107
    IA64_ApUNAT = 3108
    IA64_AR37 = 3109
    IA64_AR38 = 3110
    IA64_AR39 = 3111
    IA64_StFPSR = 3112
    IA64_AR41 = 3113
    IA64_AR42 = 3114
    IA64_AR43 = 3115
    IA64_ApITC = 3116
    IA64_AR45 = 3117
    IA64_AR46 = 3118
    IA64_AR47 = 3119
    IA64_AR48 = 3120
    IA64_AR49 = 3121
    IA64_AR50 = 3122
    IA64_AR51 = 3123
    IA64_AR52 = 3124
    IA64_AR53 = 3125
    IA64_AR54 = 3126
    IA64_AR55 = 3127
    IA64_AR56 = 3128
    IA64_AR57 = 3129
    IA64_AR58 = 3130
    IA64_AR59 = 3131
    IA64_AR60 = 3132
    IA64_AR61 = 3133
    IA64_AR62 = 3134
    IA64_AR63 = 3135
    IA64_RsPFS = 3136
    IA64_ApLC = 3137
    IA64_ApEC = 3138
    IA64_AR67 = 3139
    IA64_AR68 = 3140
    IA64_AR69 = 3141
    IA64_AR70 = 3142
    IA64_AR71 = 3143
    IA64_AR72 = 3144
    IA64_AR73 = 3145
    IA64_AR74 = 3146
    IA64_AR75 = 3147
    IA64_AR76 = 3148
    IA64_AR77 = 3149
    IA64_AR78 = 3150
    IA64_AR79 = 3151
    IA64_AR80 = 3152
    IA64_AR81 = 3153
    IA64_AR82 = 3154
    IA64_AR83 = 3155
    IA64_AR84 = 3156
    IA64_AR85 = 3157
    IA64_AR86 = 3158
    IA64_AR87 = 3159
    IA64_AR88 = 3160
    IA64_AR89 = 3161
    IA64_AR90 = 3162
    IA64_AR91 = 3163
    IA64_AR92 = 3164
    IA64_AR93 = 3165
    IA64_AR94 = 3166
    IA64_AR95 = 3167
    IA64_AR96 = 3168
    IA64_AR97 = 3169
    IA64_AR98 = 3170
    IA64_AR99 = 3171
    IA64_AR100 = 3172
    IA64_AR101 = 3173
    IA64_AR102 = 3174
    IA64_AR103 = 3175
    IA64_AR104 = 3176
    IA64_AR105 = 3177
    IA64_AR106 = 3178
    IA64_AR107 = 3179
    IA64_AR108 = 3180
    IA64_AR109 = 3181
    IA64_AR110 = 3182
    IA64_AR111 = 3183
    IA64_AR112 = 3184
    IA64_AR113 = 3185
    IA64_AR114 = 3186
    IA64_AR115 = 3187
    IA64_AR116 = 3188
    IA64_AR117 = 3189
    IA64_AR118 = 3190
    IA64_AR119 = 3191
    IA64_AR120 = 3192
    IA64_AR121 = 3193
    IA64_AR122 = 3194
    IA64_AR123 = 3195
    IA64_AR124 = 3196
    IA64_AR125 = 3197
    IA64_AR126 = 3198
    IA64_AR127 = 3199
    IA64_CPUID0 = 3328
    IA64_CPUID1 = 3329
    IA64_CPUID2 = 3330
    IA64_CPUID3 = 3331
    IA64_CPUID4 = 3332
    IA64_ApDCR = 4096
    IA64_ApITM = 4097
    IA64_ApIVA = 4098
    IA64_CR3 = 4099
    IA64_CR4 = 4100
    IA64_CR5 = 4101
    IA64_CR6 = 4102
    IA64_CR7 = 4103
    IA64_ApPTA = 4104
    IA64_ApGPTA = 4105
    IA64_CR10 = 4106
    IA64_CR11 = 4107
    IA64_CR12 = 4108
    IA64_CR13 = 4109
    IA64_CR14 = 4110
    IA64_CR15 = 4111
    IA64_StIPSR = 4112
    IA64_StISR = 4113
    IA64_CR18 = 4114
    IA64_StIIP = 4115
    IA64_StIFA = 4116
    IA64_StITIR = 4117
    IA64_StIIPA = 4118
    IA64_StIFS = 4119
    IA64_StIIM = 4120
    IA64_StIHA = 4121
    IA64_CR26 = 4122
    IA64_CR27 = 4123
    IA64_CR28 = 4124
    IA64_CR29 = 4125
    IA64_CR30 = 4126
    IA64_CR31 = 4127
    IA64_CR32 = 4128
    IA64_CR33 = 4129
    IA64_CR34 = 4130
    IA64_CR35 = 4131
    IA64_CR36 = 4132
    IA64_CR37 = 4133
    IA64_CR38 = 4134
    IA64_CR39 = 4135
    IA64_CR40 = 4136
    IA64_CR41 = 4137
    IA64_CR42 = 4138
    IA64_CR43 = 4139
    IA64_CR44 = 4140
    IA64_CR45 = 4141
    IA64_CR46 = 4142
    IA64_CR47 = 4143
    IA64_CR48 = 4144
    IA64_CR49 = 4145
    IA64_CR50 = 4146
    IA64_CR51 = 4147
    IA64_CR52 = 4148
    IA64_CR53 = 4149
    IA64_CR54 = 4150
    IA64_CR55 = 4151
    IA64_CR56 = 4152
    IA64_CR57 = 4153
    IA64_CR58 = 4154
    IA64_CR59 = 4155
    IA64_CR60 = 4156
    IA64_CR61 = 4157
    IA64_CR62 = 4158
    IA64_CR63 = 4159
    IA64_SaLID = 4160
    IA64_SaIVR = 4161
    IA64_SaTPR = 4162
    IA64_SaEOI = 4163
    IA64_SaIRR0 = 4164
    IA64_SaIRR1 = 4165
    IA64_SaIRR2 = 4166
    IA64_SaIRR3 = 4167
    IA64_SaITV = 4168
    IA64_SaPMV = 4169
    IA64_SaCMCV = 4170
    IA64_CR75 = 4171
    IA64_CR76 = 4172
    IA64_CR77 = 4173
    IA64_CR78 = 4174
    IA64_CR79 = 4175
    IA64_SaLRR0 = 4176
    IA64_SaLRR1 = 4177
    IA64_CR82 = 4178
    IA64_CR83 = 4179
    IA64_CR84 = 4180
    IA64_CR85 = 4181
    IA64_CR86 = 4182
    IA64_CR87 = 4183
    IA64_CR88 = 4184
    IA64_CR89 = 4185
    IA64_CR90 = 4186
    IA64_CR91 = 4187
    IA64_CR92 = 4188
    IA64_CR93 = 4189
    IA64_CR94 = 4190
    IA64_CR95 = 4191
    IA64_CR96 = 4192
    IA64_CR97 = 4193
    IA64_CR98 = 4194
    IA64_CR99 = 4195
    IA64_CR100 = 4196
    IA64_CR101 = 4197
    IA64_CR102 = 4198
    IA64_CR103 = 4199
    IA64_CR104 = 4200
    IA64_CR105 = 4201
    IA64_CR106 = 4202
    IA64_CR107 = 4203
    IA64_CR108 = 4204
    IA64_CR109 = 4205
    IA64_CR110 = 4206
    IA64_CR111 = 4207
    IA64_CR112 = 4208
    IA64_CR113 = 4209
    IA64_CR114 = 4210
    IA64_CR115 = 4211
    IA64_CR116 = 4212
    IA64_CR117 = 4213
    IA64_CR118 = 4214
    IA64_CR119 = 4215
    IA64_CR120 = 4216
    IA64_CR121 = 4217
    IA64_CR122 = 4218
    IA64_CR123 = 4219
    IA64_CR124 = 4220
    IA64_CR125 = 4221
    IA64_CR126 = 4222
    IA64_CR127 = 4223
    IA64_Pkr0 = 5120
    IA64_Pkr1 = 5121
    IA64_Pkr2 = 5122
    IA64_Pkr3 = 5123
    IA64_Pkr4 = 5124
    IA64_Pkr5 = 5125
    IA64_Pkr6 = 5126
    IA64_Pkr7 = 5127
    IA64_Pkr8 = 5128
    IA64_Pkr9 = 5129
    IA64_Pkr10 = 5130
    IA64_Pkr11 = 5131
    IA64_Pkr12 = 5132
    IA64_Pkr13 = 5133
    IA64_Pkr14 = 5134
    IA64_Pkr15 = 5135
    IA64_Rr0 = 6144
    IA64_Rr1 = 6145
    IA64_Rr2 = 6146
    IA64_Rr3 = 6147
    IA64_Rr4 = 6148
    IA64_Rr5 = 6149
    IA64_Rr6 = 6150
    IA64_Rr7 = 6151
    IA64_PFD0 = 7168
    IA64_PFD1 = 7169
    IA64_PFD2 = 7170
    IA64_PFD3 = 7171
    IA64_PFD4 = 7172
    IA64_PFD5 = 7173
    IA64_PFD6 = 7174
    IA64_PFD7 = 7175
    IA64_PFD8 = 7176
    IA64_PFD9 = 7177
    IA64_PFD10 = 7178
    IA64_PFD11 = 7179
    IA64_PFD12 = 7180
    IA64_PFD13 = 7181
    IA64_PFD14 = 7182
    IA64_PFD15 = 7183
    IA64_PFD16 = 7184
    IA64_PFD17 = 7185
    IA64_PFC0 = 7424
    IA64_PFC1 = 7425
    IA64_PFC2 = 7426
    IA64_PFC3 = 7427
    IA64_PFC4 = 7428
    IA64_PFC5 = 7429
    IA64_PFC6 = 7430
    IA64_PFC7 = 7431
    IA64_PFC8 = 7432
    IA64_PFC9 = 7433
    IA64_PFC10 = 7434
    IA64_PFC11 = 7435
    IA64_PFC12 = 7436
    IA64_PFC13 = 7437
    IA64_PFC14 = 7438
    IA64_PFC15 = 7439
    IA64_TrI0 = 8192
    IA64_TrI1 = 8193
    IA64_TrI2 = 8194
    IA64_TrI3 = 8195
    IA64_TrI4 = 8196
    IA64_TrI5 = 8197
    IA64_TrI6 = 8198
    IA64_TrI7 = 8199
    IA64_TrD0 = 8320
    IA64_TrD1 = 8321
    IA64_TrD2 = 8322
    IA64_TrD3 = 8323
    IA64_TrD4 = 8324
    IA64_TrD5 = 8325
    IA64_TrD6 = 8326
    IA64_TrD7 = 8327
    IA64_DbI0 = 8448
    IA64_DbI1 = 8449
    IA64_DbI2 = 8450
    IA64_DbI3 = 8451
    IA64_DbI4 = 8452
    IA64_DbI5 = 8453
    IA64_DbI6 = 8454
    IA64_DbI7 = 8455
    IA64_DbD0 = 8576
    IA64_DbD1 = 8577
    IA64_DbD2 = 8578
    IA64_DbD3 = 8579
    IA64_DbD4 = 8580
    IA64_DbD5 = 8581
    IA64_DbD6 = 8582
    IA64_DbD7 = 8583
    TRI_NOREG = REG_NONE
    TRI_D0 = 10
    TRI_D1 = 11
    TRI_D2 = 12
    TRI_D3 = 13
    TRI_D4 = 14
    TRI_D5 = 15
    TRI_D6 = 16
    TRI_D7 = 17
    TRI_D8 = 18
    TRI_D9 = 19
    TRI_D10 = 20
    TRI_D11 = 21
    TRI_D12 = 22
    TRI_D13 = 23
    TRI_D14 = 24
    TRI_D15 = 25
    TRI_A0 = 26
    TRI_A1 = 27
    TRI_A2 = 28
    TRI_A3 = 29
    TRI_A4 = 30
    TRI_A5 = 31
    TRI_A6 = 32
    TRI_A7 = 33
    TRI_A8 = 34
    TRI_A9 = 35
    TRI_A10 = 36
    TRI_A11 = 37
    TRI_A12 = 38
    TRI_A13 = 39
    TRI_A14 = 40
    TRI_A15 = 41
    TRI_E0 = 42
    TRI_E2 = 43
    TRI_E4 = 44
    TRI_E6 = 45
    TRI_E8 = 46
    TRI_E10 = 47
    TRI_E12 = 48
    TRI_E14 = 49
    TRI_EA0 = 50
    TRI_EA2 = 51
    TRI_EA4 = 52
    TRI_EA6 = 53
    TRI_EA8 = 54
    TRI_EA10 = 55
    TRI_EA12 = 56
    TRI_EA14 = 57
    TRI_PSW = 58
    TRI_PCXI = 59
    TRI_PC = 60
    TRI_FCX = 61
    TRI_LCX = 62
    TRI_ISP = 63
    TRI_ICR = 64
    TRI_BIV = 65
    TRI_BTV = 66
    TRI_SYSCON = 67
    TRI_DPRx_0 = 68
    TRI_DPRx_1 = 69
    TRI_DPRx_2 = 70
    TRI_DPRx_3 = 71
    TRI_CPRx_0 = 68
    TRI_CPRx_1 = 69
    TRI_CPRx_2 = 70
    TRI_CPRx_3 = 71
    TRI_DPMx_0 = 68
    TRI_DPMx_1 = 69
    TRI_DPMx_2 = 70
    TRI_DPMx_3 = 71
    TRI_CPMx_0 = 68
    TRI_CPMx_1 = 69
    TRI_CPMx_2 = 70
    TRI_CPMx_3 = 71
    TRI_DBGSSR = 72
    TRI_EXEVT = 73
    TRI_SWEVT = 74
    TRI_CREVT = 75
    TRI_TRnEVT = 76
    TRI_MMUCON = 77
    TRI_ASI = 78
    TRI_TVA = 79
    TRI_TPA = 80
    TRI_TPX = 81
    TRI_TFA = 82
    AM33_NOREG = REG_NONE
    AM33_E0 = 10
    AM33_E1 = 11
    AM33_E2 = 12
    AM33_E3 = 13
    AM33_E4 = 14
    AM33_E5 = 15
    AM33_E6 = 16
    AM33_E7 = 17
    AM33_A0 = 20
    AM33_A1 = 21
    AM33_A2 = 22
    AM33_A3 = 23
    AM33_D0 = 30
    AM33_D1 = 31
    AM33_D2 = 32
    AM33_D3 = 33
    AM33_FS0 = 40
    AM33_FS1 = 41
    AM33_FS2 = 42
    AM33_FS3 = 43
    AM33_FS4 = 44
    AM33_FS5 = 45
    AM33_FS6 = 46
    AM33_FS7 = 47
    AM33_FS8 = 48
    AM33_FS9 = 49
    AM33_FS10 = 50
    AM33_FS11 = 51
    AM33_FS12 = 52
    AM33_FS13 = 53
    AM33_FS14 = 54
    AM33_FS15 = 55
    AM33_FS16 = 56
    AM33_FS17 = 57
    AM33_FS18 = 58
    AM33_FS19 = 59
    AM33_FS20 = 60
    AM33_FS21 = 61
    AM33_FS22 = 62
    AM33_FS23 = 63
    AM33_FS24 = 64
    AM33_FS25 = 65
    AM33_FS26 = 66
    AM33_FS27 = 67
    AM33_FS28 = 68
    AM33_FS29 = 69
    AM33_FS30 = 70
    AM33_FS31 = 71
    AM33_SP = 80
    AM33_PC = 81
    AM33_MDR = 82
    AM33_MDRQ = 83
    AM33_MCRH = 84
    AM33_MCRL = 85
    AM33_MCVF = 86
    AM33_EPSW = 87
    AM33_FPCR = 88
    AM33_LIR = 89
    AM33_LAR = 90
    M32R_NOREG = REG_NONE
    M32R_R0 = 10
    M32R_R1 = 11
    M32R_R2 = 12
    M32R_R3 = 13
    M32R_R4 = 14
    M32R_R5 = 15
    M32R_R6 = 16
    M32R_R7 = 17
    M32R_R8 = 18
    M32R_R9 = 19
    M32R_R10 = 20
    M32R_R11 = 21
    M32R_R12 = 22
    M32R_R13 = 23
    M32R_R14 = 24
    M32R_R15 = 25
    M32R_PSW = 26
    M32R_CBR = 27
    M32R_SPI = 28
    M32R_SPU = 29
    M32R_SPO = 30
    M32R_BPC = 31
    M32R_ACHI = 32
    M32R_ACLO = 33
    M32R_PC = 34
    SHMEDIA_NOREG = REG_NONE
    SHMEDIA_R0 = 10
    SHMEDIA_R1 = 11
    SHMEDIA_R2 = 12
    SHMEDIA_R3 = 13
    SHMEDIA_R4 = 14
    SHMEDIA_R5 = 15
    SHMEDIA_R6 = 16
    SHMEDIA_R7 = 17
    SHMEDIA_R8 = 18
    SHMEDIA_R9 = 19
    SHMEDIA_R10 = 20
    SHMEDIA_R11 = 21
    SHMEDIA_R12 = 22
    SHMEDIA_R13 = 23
    SHMEDIA_R14 = 24
    SHMEDIA_R15 = 25
    SHMEDIA_R16 = 26
    SHMEDIA_R17 = 27
    SHMEDIA_R18 = 28
    SHMEDIA_R19 = 29
    SHMEDIA_R20 = 30
    SHMEDIA_R21 = 31
    SHMEDIA_R22 = 32
    SHMEDIA_R23 = 33
    SHMEDIA_R24 = 34
    SHMEDIA_R25 = 35
    SHMEDIA_R26 = 36
    SHMEDIA_R27 = 37
    SHMEDIA_R28 = 38
    SHMEDIA_R29 = 39
    SHMEDIA_R30 = 40
    SHMEDIA_R31 = 41
    SHMEDIA_R32 = 42
    SHMEDIA_R33 = 43
    SHMEDIA_R34 = 44
    SHMEDIA_R35 = 45
    SHMEDIA_R36 = 46
    SHMEDIA_R37 = 47
    SHMEDIA_R38 = 48
    SHMEDIA_R39 = 49
    SHMEDIA_R40 = 50
    SHMEDIA_R41 = 51
    SHMEDIA_R42 = 52
    SHMEDIA_R43 = 53
    SHMEDIA_R44 = 54
    SHMEDIA_R45 = 55
    SHMEDIA_R46 = 56
    SHMEDIA_R47 = 57
    SHMEDIA_R48 = 58
    SHMEDIA_R49 = 59
    SHMEDIA_R50 = 60
    SHMEDIA_R51 = 61
    SHMEDIA_R52 = 62
    SHMEDIA_R53 = 63
    SHMEDIA_R54 = 64
    SHMEDIA_R55 = 65
    SHMEDIA_R56 = 66
    SHMEDIA_R57 = 67
    SHMEDIA_R58 = 68
    SHMEDIA_R59 = 69
    SHMEDIA_R60 = 70
    SHMEDIA_R61 = 71
    SHMEDIA_R62 = 72
    SHMEDIA_R63 = 73
    SHMEDIA_TR0 = 74
    SHMEDIA_TR1 = 75
    SHMEDIA_TR2 = 76
    SHMEDIA_TR3 = 77
    SHMEDIA_TR4 = 78
    SHMEDIA_TR5 = 79
    SHMEDIA_TR6 = 80
    SHMEDIA_TR7 = 81
    SHMEDIA_TR8 = 82
    SHMEDIA_TR9 = 83
    SHMEDIA_TR10 = 84
    SHMEDIA_TR11 = 85
    SHMEDIA_TR12 = 86
    SHMEDIA_TR13 = 87
    SHMEDIA_TR14 = 88
    SHMEDIA_TR15 = 89
    SHMEDIA_FR0 = 128
    SHMEDIA_FR1 = 129
    SHMEDIA_FR2 = 130
    SHMEDIA_FR3 = 131
    SHMEDIA_FR4 = 132
    SHMEDIA_FR5 = 133
    SHMEDIA_FR6 = 134
    SHMEDIA_FR7 = 135
    SHMEDIA_FR8 = 136
    SHMEDIA_FR9 = 137
    SHMEDIA_FR10 = 138
    SHMEDIA_FR11 = 139
    SHMEDIA_FR12 = 140
    SHMEDIA_FR13 = 141
    SHMEDIA_FR14 = 142
    SHMEDIA_FR15 = 143
    SHMEDIA_FR16 = 144
    SHMEDIA_FR17 = 145
    SHMEDIA_FR18 = 146
    SHMEDIA_FR19 = 147
    SHMEDIA_FR20 = 148
    SHMEDIA_FR21 = 149
    SHMEDIA_FR22 = 150
    SHMEDIA_FR23 = 151
    SHMEDIA_FR24 = 152
    SHMEDIA_FR25 = 153
    SHMEDIA_FR26 = 154
    SHMEDIA_FR27 = 155
    SHMEDIA_FR28 = 156
    SHMEDIA_FR29 = 157
    SHMEDIA_FR30 = 158
    SHMEDIA_FR31 = 159
    SHMEDIA_FR32 = 160
    SHMEDIA_FR33 = 161
    SHMEDIA_FR34 = 162
    SHMEDIA_FR35 = 163
    SHMEDIA_FR36 = 164
    SHMEDIA_FR37 = 165
    SHMEDIA_FR38 = 166
    SHMEDIA_FR39 = 167
    SHMEDIA_FR40 = 168
    SHMEDIA_FR41 = 169
    SHMEDIA_FR42 = 170
    SHMEDIA_FR43 = 171
    SHMEDIA_FR44 = 172
    SHMEDIA_FR45 = 173
    SHMEDIA_FR46 = 174
    SHMEDIA_FR47 = 175
    SHMEDIA_FR48 = 176
    SHMEDIA_FR49 = 177
    SHMEDIA_FR50 = 178
    SHMEDIA_FR51 = 179
    SHMEDIA_FR52 = 180
    SHMEDIA_FR53 = 181
    SHMEDIA_FR54 = 182
    SHMEDIA_FR55 = 183
    SHMEDIA_FR56 = 184
    SHMEDIA_FR57 = 185
    SHMEDIA_FR58 = 186
    SHMEDIA_FR59 = 187
    SHMEDIA_FR60 = 188
    SHMEDIA_FR61 = 189
    SHMEDIA_FR62 = 190
    SHMEDIA_FR63 = 191
    SHMEDIA_DR0 = 256
    SHMEDIA_DR2 = 258
    SHMEDIA_DR4 = 260
    SHMEDIA_DR6 = 262
    SHMEDIA_DR8 = 264
    SHMEDIA_DR10 = 266
    SHMEDIA_DR12 = 268
    SHMEDIA_DR14 = 270
    SHMEDIA_DR16 = 272
    SHMEDIA_DR18 = 274
    SHMEDIA_DR20 = 276
    SHMEDIA_DR22 = 278
    SHMEDIA_DR24 = 280
    SHMEDIA_DR26 = 282
    SHMEDIA_DR28 = 284
    SHMEDIA_DR30 = 286
    SHMEDIA_DR32 = 288
    SHMEDIA_DR34 = 290
    SHMEDIA_DR36 = 292
    SHMEDIA_DR38 = 294
    SHMEDIA_DR40 = 296
    SHMEDIA_DR42 = 298
    SHMEDIA_DR44 = 300
    SHMEDIA_DR46 = 302
    SHMEDIA_DR48 = 304
    SHMEDIA_DR50 = 306
    SHMEDIA_DR52 = 308
    SHMEDIA_DR54 = 310
    SHMEDIA_DR56 = 312
    SHMEDIA_DR58 = 314
    SHMEDIA_DR60 = 316
    SHMEDIA_DR62 = 318
    SHMEDIA_FV0 = 512
    SHMEDIA_FV4 = 516
    SHMEDIA_FV8 = 520
    SHMEDIA_FV12 = 524
    SHMEDIA_FV16 = 528
    SHMEDIA_FV20 = 532
    SHMEDIA_FV24 = 536
    SHMEDIA_FV28 = 540
    SHMEDIA_FV32 = 544
    SHMEDIA_FV36 = 548
    SHMEDIA_FV40 = 552
    SHMEDIA_FV44 = 556
    SHMEDIA_FV48 = 560
    SHMEDIA_FV52 = 564
    SHMEDIA_FV56 = 568
    SHMEDIA_FV60 = 572
    SHMEDIA_MTRX0 = 1024
    SHMEDIA_MTRX16 = 1040
    SHMEDIA_MTRX32 = 1056
    SHMEDIA_MTRX48 = 1072
    SHMEDIA_CR0 = 2000
    SHMEDIA_CR1 = 2001
    SHMEDIA_CR2 = 2002
    SHMEDIA_CR3 = 2003
    SHMEDIA_CR4 = 2004
    SHMEDIA_CR5 = 2005
    SHMEDIA_CR6 = 2006
    SHMEDIA_CR7 = 2007
    SHMEDIA_CR8 = 2008
    SHMEDIA_CR9 = 2009
    SHMEDIA_CR10 = 2010
    SHMEDIA_CR11 = 2011
    SHMEDIA_CR12 = 2012
    SHMEDIA_CR13 = 2013
    SHMEDIA_CR14 = 2014
    SHMEDIA_CR15 = 2015
    SHMEDIA_CR16 = 2016
    SHMEDIA_CR17 = 2017
    SHMEDIA_CR18 = 2018
    SHMEDIA_CR19 = 2019
    SHMEDIA_CR20 = 2020
    SHMEDIA_CR21 = 2021
    SHMEDIA_CR22 = 2022
    SHMEDIA_CR23 = 2023
    SHMEDIA_CR24 = 2024
    SHMEDIA_CR25 = 2025
    SHMEDIA_CR26 = 2026
    SHMEDIA_CR27 = 2027
    SHMEDIA_CR28 = 2028
    SHMEDIA_CR29 = 2029
    SHMEDIA_CR30 = 2030
    SHMEDIA_CR31 = 2031
    SHMEDIA_CR32 = 2032
    SHMEDIA_CR33 = 2033
    SHMEDIA_CR34 = 2034
    SHMEDIA_CR35 = 2035
    SHMEDIA_CR36 = 2036
    SHMEDIA_CR37 = 2037
    SHMEDIA_CR38 = 2038
    SHMEDIA_CR39 = 2039
    SHMEDIA_CR40 = 2040
    SHMEDIA_CR41 = 2041
    SHMEDIA_CR42 = 2042
    SHMEDIA_CR43 = 2043
    SHMEDIA_CR44 = 2044
    SHMEDIA_CR45 = 2045
    SHMEDIA_CR46 = 2046
    SHMEDIA_CR47 = 2047
    SHMEDIA_CR48 = 2048
    SHMEDIA_CR49 = 2049
    SHMEDIA_CR50 = 2050
    SHMEDIA_CR51 = 2051
    SHMEDIA_CR52 = 2052
    SHMEDIA_CR53 = 2053
    SHMEDIA_CR54 = 2054
    SHMEDIA_CR55 = 2055
    SHMEDIA_CR56 = 2056
    SHMEDIA_CR57 = 2057
    SHMEDIA_CR58 = 2058
    SHMEDIA_CR59 = 2059
    SHMEDIA_CR60 = 2060
    SHMEDIA_CR61 = 2061
    SHMEDIA_CR62 = 2062
    SHMEDIA_CR63 = 2063
    SHMEDIA_FPSCR = 2064
    SHMEDIA_GBR = SHMEDIA_R16
    SHMEDIA_MACL = 90
    SHMEDIA_MACH = 91
    SHMEDIA_PR = SHMEDIA_R18
    SHMEDIA_T = 92
    SHMEDIA_FPUL = SHMEDIA_FR32
    SHMEDIA_PC = 93
    SHMEDIA_SR = SHMEDIA_CR0
    AMD64_AL = 1
    AMD64_CL = 2
    AMD64_DL = 3
    AMD64_BL = 4
    AMD64_AH = 5
    AMD64_CH = 6
    AMD64_DH = 7
    AMD64_BH = 8
    AMD64_AX = 9
    AMD64_CX = 10
    AMD64_DX = 11
    AMD64_BX = 12
    AMD64_SP = 13
    AMD64_BP = 14
    AMD64_SI = 15
    AMD64_DI = 16
    AMD64_EAX = 17
    AMD64_ECX = 18
    AMD64_EDX = 19
    AMD64_EBX = 20
    AMD64_ESP = 21
    AMD64_EBP = 22
    AMD64_ESI = 23
    AMD64_EDI = 24
    AMD64_ES = 25
    AMD64_CS = 26
    AMD64_SS = 27
    AMD64_DS = 28
    AMD64_FS = 29
    AMD64_GS = 30
    AMD64_FLAGS = 32
    AMD64_RIP = 33
    AMD64_EFLAGS = 34
    AMD64_CR0 = 80
    AMD64_CR1 = 81
    AMD64_CR2 = 82
    AMD64_CR3 = 83
    AMD64_CR4 = 84
    AMD64_CR8 = 88
    AMD64_DR0 = 90
    AMD64_DR1 = 91
    AMD64_DR2 = 92
    AMD64_DR3 = 93
    AMD64_DR4 = 94
    AMD64_DR5 = 95
    AMD64_DR6 = 96
    AMD64_DR7 = 97
    AMD64_DR8 = 98
    AMD64_DR9 = 99
    AMD64_DR10 = 100
    AMD64_DR11 = 101
    AMD64_DR12 = 102
    AMD64_DR13 = 103
    AMD64_DR14 = 104
    AMD64_DR15 = 105
    AMD64_GDTR = 110
    AMD64_GDTL = 111
    AMD64_IDTR = 112
    AMD64_IDTL = 113
    AMD64_LDTR = 114
    AMD64_TR = 115
    AMD64_ST0 = 128
    AMD64_ST1 = 129
    AMD64_ST2 = 130
    AMD64_ST3 = 131
    AMD64_ST4 = 132
    AMD64_ST5 = 133
    AMD64_ST6 = 134
    AMD64_ST7 = 135
    AMD64_CTRL = 136
    AMD64_STAT = 137
    AMD64_TAG = 138
    AMD64_FPIP = 139
    AMD64_FPCS = 140
    AMD64_FPDO = 141
    AMD64_FPDS = 142
    AMD64_ISEM = 143
    AMD64_FPEIP = 144
    AMD64_FPEDO = 145
    AMD64_MM0 = 146
    AMD64_MM1 = 147
    AMD64_MM2 = 148
    AMD64_MM3 = 149
    AMD64_MM4 = 150
    AMD64_MM5 = 151
    AMD64_MM6 = 152
    AMD64_MM7 = 153
    AMD64_XMM0 = 154
    AMD64_XMM1 = 155
    AMD64_XMM2 = 156
    AMD64_XMM3 = 157
    AMD64_XMM4 = 158
    AMD64_XMM5 = 159
    AMD64_XMM6 = 160
    AMD64_XMM7 = 161
    AMD64_XMM0_0 = 162
    AMD64_XMM0_1 = 163
    AMD64_XMM0_2 = 164
    AMD64_XMM0_3 = 165
    AMD64_XMM1_0 = 166
    AMD64_XMM1_1 = 167
    AMD64_XMM1_2 = 168
    AMD64_XMM1_3 = 169
    AMD64_XMM2_0 = 170
    AMD64_XMM2_1 = 171
    AMD64_XMM2_2 = 172
    AMD64_XMM2_3 = 173
    AMD64_XMM3_0 = 174
    AMD64_XMM3_1 = 175
    AMD64_XMM3_2 = 176
    AMD64_XMM3_3 = 177
    AMD64_XMM4_0 = 178
    AMD64_XMM4_1 = 179
    AMD64_XMM4_2 = 180
    AMD64_XMM4_3 = 181
    AMD64_XMM5_0 = 182
    AMD64_XMM5_1 = 183
    AMD64_XMM5_2 = 184
    AMD64_XMM5_3 = 185
    AMD64_XMM6_0 = 186
    AMD64_XMM6_1 = 187
    AMD64_XMM6_2 = 188
    AMD64_XMM6_3 = 189
    AMD64_XMM7_0 = 190
    AMD64_XMM7_1 = 191
    AMD64_XMM7_2 = 192
    AMD64_XMM7_3 = 193
    AMD64_XMM0L = 194
    AMD64_XMM1L = 195
    AMD64_XMM2L = 196
    AMD64_XMM3L = 197
    AMD64_XMM4L = 198
    AMD64_XMM5L = 199
    AMD64_XMM6L = 200
    AMD64_XMM7L = 201
    AMD64_XMM0H = 202
    AMD64_XMM1H = 203
    AMD64_XMM2H = 204
    AMD64_XMM3H = 205
    AMD64_XMM4H = 206
    AMD64_XMM5H = 207
    AMD64_XMM6H = 208
    AMD64_XMM7H = 209
    AMD64_MXCSR = 211
    AMD64_EMM0L = 220
    AMD64_EMM1L = 221
    AMD64_EMM2L = 222
    AMD64_EMM3L = 223
    AMD64_EMM4L = 224
    AMD64_EMM5L = 225
    AMD64_EMM6L = 226
    AMD64_EMM7L = 227
    AMD64_EMM0H = 228
    AMD64_EMM1H = 229
    AMD64_EMM2H = 230
    AMD64_EMM3H = 231
    AMD64_EMM4H = 232
    AMD64_EMM5H = 233
    AMD64_EMM6H = 234
    AMD64_EMM7H = 235
    AMD64_MM00 = 236
    AMD64_MM01 = 237
    AMD64_MM10 = 238
    AMD64_MM11 = 239
    AMD64_MM20 = 240
    AMD64_MM21 = 241
    AMD64_MM30 = 242
    AMD64_MM31 = 243
    AMD64_MM40 = 244
    AMD64_MM41 = 245
    AMD64_MM50 = 246
    AMD64_MM51 = 247
    AMD64_MM60 = 248
    AMD64_MM61 = 249
    AMD64_MM70 = 250
    AMD64_MM71 = 251
    AMD64_XMM8 = 252
    AMD64_XMM9 = 253
    AMD64_XMM10 = 254
    AMD64_XMM11 = 255
    AMD64_XMM12 = 256
    AMD64_XMM13 = 257
    AMD64_XMM14 = 258
    AMD64_XMM15 = 259
    AMD64_XMM8_0 = 260
    AMD64_XMM8_1 = 261
    AMD64_XMM8_2 = 262
    AMD64_XMM8_3 = 263
    AMD64_XMM9_0 = 264
    AMD64_XMM9_1 = 265
    AMD64_XMM9_2 = 266
    AMD64_XMM9_3 = 267
    AMD64_XMM10_0 = 268
    AMD64_XMM10_1 = 269
    AMD64_XMM10_2 = 270
    AMD64_XMM10_3 = 271
    AMD64_XMM11_0 = 272
    AMD64_XMM11_1 = 273
    AMD64_XMM11_2 = 274
    AMD64_XMM11_3 = 275
    AMD64_XMM12_0 = 276
    AMD64_XMM12_1 = 277
    AMD64_XMM12_2 = 278
    AMD64_XMM12_3 = 279
    AMD64_XMM13_0 = 280
    AMD64_XMM13_1 = 281
    AMD64_XMM13_2 = 282
    AMD64_XMM13_3 = 283
    AMD64_XMM14_0 = 284
    AMD64_XMM14_1 = 285
    AMD64_XMM14_2 = 286
    AMD64_XMM14_3 = 287
    AMD64_XMM15_0 = 288
    AMD64_XMM15_1 = 289
    AMD64_XMM15_2 = 290
    AMD64_XMM15_3 = 291
    AMD64_XMM8L = 292
    AMD64_XMM9L = 293
    AMD64_XMM10L = 294
    AMD64_XMM11L = 295
    AMD64_XMM12L = 296
    AMD64_XMM13L = 297
    AMD64_XMM14L = 298
    AMD64_XMM15L = 299
    AMD64_XMM8H = 300
    AMD64_XMM9H = 301
    AMD64_XMM10H = 302
    AMD64_XMM11H = 303
    AMD64_XMM12H = 304
    AMD64_XMM13H = 305
    AMD64_XMM14H = 306
    AMD64_XMM15H = 307
    AMD64_EMM8L = 308
    AMD64_EMM9L = 309
    AMD64_EMM10L = 310
    AMD64_EMM11L = 311
    AMD64_EMM12L = 312
    AMD64_EMM13L = 313
    AMD64_EMM14L = 314
    AMD64_EMM15L = 315
    AMD64_EMM8H = 316
    AMD64_EMM9H = 317
    AMD64_EMM10H = 318
    AMD64_EMM11H = 319
    AMD64_EMM12H = 320
    AMD64_EMM13H = 321
    AMD64_EMM14H = 322
    AMD64_EMM15H = 323
    AMD64_SIL = 324
    AMD64_DIL = 325
    AMD64_BPL = 326
    AMD64_SPL = 327
    AMD64_RAX = 328
    AMD64_RBX = 329
    AMD64_RCX = 330
    AMD64_RDX = 331
    AMD64_RSI = 332
    AMD64_RDI = 333
    AMD64_RBP = 334
    AMD64_RSP = 335
    AMD64_R8 = 336
    AMD64_R9 = 337
    AMD64_R10 = 338
    AMD64_R11 = 339
    AMD64_R12 = 340
    AMD64_R13 = 341
    AMD64_R14 = 342
    AMD64_R15 = 343
    AMD64_R8B = 344
    AMD64_R9B = 345
    AMD64_R10B = 346
    AMD64_R11B = 347
    AMD64_R12B = 348
    AMD64_R13B = 349
    AMD64_R14B = 350
    AMD64_R15B = 351
    AMD64_R8W = 352
    AMD64_R9W = 353
    AMD64_R10W = 354
    AMD64_R11W = 355
    AMD64_R12W = 356
    AMD64_R13W = 357
    AMD64_R14W = 358
    AMD64_R15W = 359
    AMD64_R8D = 360
    AMD64_R9D = 361
    AMD64_R10D = 362
    AMD64_R11D = 363
    AMD64_R12D = 364
    AMD64_R13D = 365
    AMD64_R14D = 366
    AMD64_R15D = 367
    AMD64_YMM0 = 368
    AMD64_YMM1 = 369
    AMD64_YMM2 = 370
    AMD64_YMM3 = 371
    AMD64_YMM4 = 372
    AMD64_YMM5 = 373
    AMD64_YMM6 = 374
    AMD64_YMM7 = 375
    AMD64_YMM8 = 376
    AMD64_YMM9 = 377
    AMD64_YMM10 = 378
    AMD64_YMM11 = 379
    AMD64_YMM12 = 380
    AMD64_YMM13 = 381
    AMD64_YMM14 = 382
    AMD64_YMM15 = 383
    AMD64_YMM0H = 384
    AMD64_YMM1H = 385
    AMD64_YMM2H = 386
    AMD64_YMM3H = 387
    AMD64_YMM4H = 388
    AMD64_YMM5H = 389
    AMD64_YMM6H = 390
    AMD64_YMM7H = 391
    AMD64_YMM8H = 392
    AMD64_YMM9H = 393
    AMD64_YMM10H = 394
    AMD64_YMM11H = 395
    AMD64_YMM12H = 396
    AMD64_YMM13H = 397
    AMD64_YMM14H = 398
    AMD64_YMM15H = 399
    AMD64_XMM0IL = 400
    AMD64_XMM1IL = 401
    AMD64_XMM2IL = 402
    AMD64_XMM3IL = 403
    AMD64_XMM4IL = 404
    AMD64_XMM5IL = 405
    AMD64_XMM6IL = 406
    AMD64_XMM7IL = 407
    AMD64_XMM8IL = 408
    AMD64_XMM9IL = 409
    AMD64_XMM10IL = 410
    AMD64_XMM11IL = 411
    AMD64_XMM12IL = 412
    AMD64_XMM13IL = 413
    AMD64_XMM14IL = 414
    AMD64_XMM15IL = 415
    AMD64_XMM0IH = 416
    AMD64_XMM1IH = 417
    AMD64_XMM2IH = 418
    AMD64_XMM3IH = 419
    AMD64_XMM4IH = 420
    AMD64_XMM5IH = 421
    AMD64_XMM6IH = 422
    AMD64_XMM7IH = 423
    AMD64_XMM8IH = 424
    AMD64_XMM9IH = 425
    AMD64_XMM10IH = 426
    AMD64_XMM11IH = 427
    AMD64_XMM12IH = 428
    AMD64_XMM13IH = 429
    AMD64_XMM14IH = 430
    AMD64_XMM15IH = 431
    AMD64_YMM0I0 = 432
    AMD64_YMM0I1 = 433
    AMD64_YMM0I2 = 434
    AMD64_YMM0I3 = 435
    AMD64_YMM1I0 = 436
    AMD64_YMM1I1 = 437
    AMD64_YMM1I2 = 438
    AMD64_YMM1I3 = 439
    AMD64_YMM2I0 = 440
    AMD64_YMM2I1 = 441
    AMD64_YMM2I2 = 442
    AMD64_YMM2I3 = 443
    AMD64_YMM3I0 = 444
    AMD64_YMM3I1 = 445
    AMD64_YMM3I2 = 446
    AMD64_YMM3I3 = 447
    AMD64_YMM4I0 = 448
    AMD64_YMM4I1 = 449
    AMD64_YMM4I2 = 450
    AMD64_YMM4I3 = 451
    AMD64_YMM5I0 = 452
    AMD64_YMM5I1 = 453
    AMD64_YMM5I2 = 454
    AMD64_YMM5I3 = 455
    AMD64_YMM6I0 = 456
    AMD64_YMM6I1 = 457
    AMD64_YMM6I2 = 458
    AMD64_YMM6I3 = 459
    AMD64_YMM7I0 = 460
    AMD64_YMM7I1 = 461
    AMD64_YMM7I2 = 462
    AMD64_YMM7I3 = 463
    AMD64_YMM8I0 = 464
    AMD64_YMM8I1 = 465
    AMD64_YMM8I2 = 466
    AMD64_YMM8I3 = 467
    AMD64_YMM9I0 = 468
    AMD64_YMM9I1 = 469
    AMD64_YMM9I2 = 470
    AMD64_YMM9I3 = 471
    AMD64_YMM10I0 = 472
    AMD64_YMM10I1 = 473
    AMD64_YMM10I2 = 474
    AMD64_YMM10I3 = 475
    AMD64_YMM11I0 = 476
    AMD64_YMM11I1 = 477
    AMD64_YMM11I2 = 478
    AMD64_YMM11I3 = 479
    AMD64_YMM12I0 = 480
    AMD64_YMM12I1 = 481
    AMD64_YMM12I2 = 482
    AMD64_YMM12I3 = 483
    AMD64_YMM13I0 = 484
    AMD64_YMM13I1 = 485
    AMD64_YMM13I2 = 486
    AMD64_YMM13I3 = 487
    AMD64_YMM14I0 = 488
    AMD64_YMM14I1 = 489
    AMD64_YMM14I2 = 490
    AMD64_YMM14I3 = 491
    AMD64_YMM15I0 = 492
    AMD64_YMM15I1 = 493
    AMD64_YMM15I2 = 494
    AMD64_YMM15I3 = 495
    AMD64_YMM0F0 = 496
    AMD64_YMM0F1 = 497
    AMD64_YMM0F2 = 498
    AMD64_YMM0F3 = 499
    AMD64_YMM0F4 = 500
    AMD64_YMM0F5 = 501
    AMD64_YMM0F6 = 502
    AMD64_YMM0F7 = 503
    AMD64_YMM1F0 = 504
    AMD64_YMM1F1 = 505
    AMD64_YMM1F2 = 506
    AMD64_YMM1F3 = 507
    AMD64_YMM1F4 = 508
    AMD64_YMM1F5 = 509
    AMD64_YMM1F6 = 510
    AMD64_YMM1F7 = 511
    AMD64_YMM2F0 = 512
    AMD64_YMM2F1 = 513
    AMD64_YMM2F2 = 514
    AMD64_YMM2F3 = 515
    AMD64_YMM2F4 = 516
    AMD64_YMM2F5 = 517
    AMD64_YMM2F6 = 518
    AMD64_YMM2F7 = 519
    AMD64_YMM3F0 = 520
    AMD64_YMM3F1 = 521
    AMD64_YMM3F2 = 522
    AMD64_YMM3F3 = 523
    AMD64_YMM3F4 = 524
    AMD64_YMM3F5 = 525
    AMD64_YMM3F6 = 526
    AMD64_YMM3F7 = 527
    AMD64_YMM4F0 = 528
    AMD64_YMM4F1 = 529
    AMD64_YMM4F2 = 530
    AMD64_YMM4F3 = 531
    AMD64_YMM4F4 = 532
    AMD64_YMM4F5 = 533
    AMD64_YMM4F6 = 534
    AMD64_YMM4F7 = 535
    AMD64_YMM5F0 = 536
    AMD64_YMM5F1 = 537
    AMD64_YMM5F2 = 538
    AMD64_YMM5F3 = 539
    AMD64_YMM5F4 = 540
    AMD64_YMM5F5 = 541
    AMD64_YMM5F6 = 542
    AMD64_YMM5F7 = 543
    AMD64_YMM6F0 = 544
    AMD64_YMM6F1 = 545
    AMD64_YMM6F2 = 546
    AMD64_YMM6F3 = 547
    AMD64_YMM6F4 = 548
    AMD64_YMM6F5 = 549
    AMD64_YMM6F6 = 550
    AMD64_YMM6F7 = 551
    AMD64_YMM7F0 = 552
    AMD64_YMM7F1 = 553
    AMD64_YMM7F2 = 554
    AMD64_YMM7F3 = 555
    AMD64_YMM7F4 = 556
    AMD64_YMM7F5 = 557
    AMD64_YMM7F6 = 558
    AMD64_YMM7F7 = 559
    AMD64_YMM8F0 = 560
    AMD64_YMM8F1 = 561
    AMD64_YMM8F2 = 562
    AMD64_YMM8F3 = 563
    AMD64_YMM8F4 = 564
    AMD64_YMM8F5 = 565
    AMD64_YMM8F6 = 566
    AMD64_YMM8F7 = 567
    AMD64_YMM9F0 = 568
    AMD64_YMM9F1 = 569
    AMD64_YMM9F2 = 570
    AMD64_YMM9F3 = 571
    AMD64_YMM9F4 = 572
    AMD64_YMM9F5 = 573
    AMD64_YMM9F6 = 574
    AMD64_YMM9F7 = 575
    AMD64_YMM10F0 = 576
    AMD64_YMM10F1 = 577
    AMD64_YMM10F2 = 578
    AMD64_YMM10F3 = 579
    AMD64_YMM10F4 = 580
    AMD64_YMM10F5 = 581
    AMD64_YMM10F6 = 582
    AMD64_YMM10F7 = 583
    AMD64_YMM11F0 = 584
    AMD64_YMM11F1 = 585
    AMD64_YMM11F2 = 586
    AMD64_YMM11F3 = 587
    AMD64_YMM11F4 = 588
    AMD64_YMM11F5 = 589
    AMD64_YMM11F6 = 590
    AMD64_YMM11F7 = 591
    AMD64_YMM12F0 = 592
    AMD64_YMM12F1 = 593
    AMD64_YMM12F2 = 594
    AMD64_YMM12F3 = 595
    AMD64_YMM12F4 = 596
    AMD64_YMM12F5 = 597
    AMD64_YMM12F6 = 598
    AMD64_YMM12F7 = 599
    AMD64_YMM13F0 = 600
    AMD64_YMM13F1 = 601
    AMD64_YMM13F2 = 602
    AMD64_YMM13F3 = 603
    AMD64_YMM13F4 = 604
    AMD64_YMM13F5 = 605
    AMD64_YMM13F6 = 606
    AMD64_YMM13F7 = 607
    AMD64_YMM14F0 = 608
    AMD64_YMM14F1 = 609
    AMD64_YMM14F2 = 610
    AMD64_YMM14F3 = 611
    AMD64_YMM14F4 = 612
    AMD64_YMM14F5 = 613
    AMD64_YMM14F6 = 614
    AMD64_YMM14F7 = 615
    AMD64_YMM15F0 = 616
    AMD64_YMM15F1 = 617
    AMD64_YMM15F2 = 618
    AMD64_YMM15F3 = 619
    AMD64_YMM15F4 = 620
    AMD64_YMM15F5 = 621
    AMD64_YMM15F6 = 622
    AMD64_YMM15F7 = 623
    AMD64_YMM0D0 = 624
    AMD64_YMM0D1 = 625
    AMD64_YMM0D2 = 626
    AMD64_YMM0D3 = 627
    AMD64_YMM1D0 = 628
    AMD64_YMM1D1 = 629
    AMD64_YMM1D2 = 630
    AMD64_YMM1D3 = 631
    AMD64_YMM2D0 = 632
    AMD64_YMM2D1 = 633
    AMD64_YMM2D2 = 634
    AMD64_YMM2D3 = 635
    AMD64_YMM3D0 = 636
    AMD64_YMM3D1 = 637
    AMD64_YMM3D2 = 638
    AMD64_YMM3D3 = 639
    AMD64_YMM4D0 = 640
    AMD64_YMM4D1 = 641
    AMD64_YMM4D2 = 642
    AMD64_YMM4D3 = 643
    AMD64_YMM5D0 = 644
    AMD64_YMM5D1 = 645
    AMD64_YMM5D2 = 646
    AMD64_YMM5D3 = 647
    AMD64_YMM6D0 = 648
    AMD64_YMM6D1 = 649
    AMD64_YMM6D2 = 650
    AMD64_YMM6D3 = 651
    AMD64_YMM7D0 = 652
    AMD64_YMM7D1 = 653
    AMD64_YMM7D2 = 654
    AMD64_YMM7D3 = 655
    AMD64_YMM8D0 = 656
    AMD64_YMM8D1 = 657
    AMD64_YMM8D2 = 658
    AMD64_YMM8D3 = 659
    AMD64_YMM9D0 = 660
    AMD64_YMM9D1 = 661
    AMD64_YMM9D2 = 662
    AMD64_YMM9D3 = 663
    AMD64_YMM10D0 = 664
    AMD64_YMM10D1 = 665
    AMD64_YMM10D2 = 666
    AMD64_YMM10D3 = 667
    AMD64_YMM11D0 = 668
    AMD64_YMM11D1 = 669
    AMD64_YMM11D2 = 670
    AMD64_YMM11D3 = 671
    AMD64_YMM12D0 = 672
    AMD64_YMM12D1 = 673
    AMD64_YMM12D2 = 674
    AMD64_YMM12D3 = 675
    AMD64_YMM13D0 = 676
    AMD64_YMM13D1 = 677
    AMD64_YMM13D2 = 678
    AMD64_YMM13D3 = 679
    AMD64_YMM14D0 = 680
    AMD64_YMM14D1 = 681
    AMD64_YMM14D2 = 682
    AMD64_YMM14D3 = 683
    AMD64_YMM15D0 = 684
    AMD64_YMM15D1 = 685
    AMD64_YMM15D2 = 686
    AMD64_YMM15D3 = 687
    AMD64_BND0 = 688
    AMD64_BND1 = 689
    AMD64_BND2 = 690
    AMD64_BND3 = 691
    AMD64_BNDCFGU = 692
    AMD64_BNDSTATUS = 693
    AMD64_XMM16 = 694
    AMD64_XMM17 = 695
    AMD64_XMM18 = 696
    AMD64_XMM19 = 697
    AMD64_XMM20 = 698
    AMD64_XMM21 = 699
    AMD64_XMM22 = 700
    AMD64_XMM23 = 701
    AMD64_XMM24 = 702
    AMD64_XMM25 = 703
    AMD64_XMM26 = 704
    AMD64_XMM27 = 705
    AMD64_XMM28 = 706
    AMD64_XMM29 = 707
    AMD64_XMM30 = 708
    AMD64_XMM31 = 709
    AMD64_YMM16 = 710
    AMD64_YMM17 = 711
    AMD64_YMM18 = 712
    AMD64_YMM19 = 713
    AMD64_YMM20 = 714
    AMD64_YMM21 = 715
    AMD64_YMM22 = 716
    AMD64_YMM23 = 717
    AMD64_YMM24 = 718
    AMD64_YMM25 = 719
    AMD64_YMM26 = 720
    AMD64_YMM27 = 721
    AMD64_YMM28 = 722
    AMD64_YMM29 = 723
    AMD64_YMM30 = 724
    AMD64_YMM31 = 725
    AMD64_ZMM0 = 726
    AMD64_ZMM1 = 727
    AMD64_ZMM2 = 728
    AMD64_ZMM3 = 729
    AMD64_ZMM4 = 730
    AMD64_ZMM5 = 731
    AMD64_ZMM6 = 732
    AMD64_ZMM7 = 733
    AMD64_ZMM8 = 734
    AMD64_ZMM9 = 735
    AMD64_ZMM10 = 736
    AMD64_ZMM11 = 737
    AMD64_ZMM12 = 738
    AMD64_ZMM13 = 739
    AMD64_ZMM14 = 740
    AMD64_ZMM15 = 741
    AMD64_ZMM16 = 742
    AMD64_ZMM17 = 743
    AMD64_ZMM18 = 744
    AMD64_ZMM19 = 745
    AMD64_ZMM20 = 746
    AMD64_ZMM21 = 747
    AMD64_ZMM22 = 748
    AMD64_ZMM23 = 749
    AMD64_ZMM24 = 750
    AMD64_ZMM25 = 751
    AMD64_ZMM26 = 752
    AMD64_ZMM27 = 753
    AMD64_ZMM28 = 754
    AMD64_ZMM29 = 755
    AMD64_ZMM30 = 756
    AMD64_ZMM31 = 757
    AMD64_K0 = 758
    AMD64_K1 = 759
    AMD64_K2 = 760
    AMD64_K3 = 761
    AMD64_K4 = 762
    AMD64_K5 = 763
    AMD64_K6 = 764
    AMD64_K7 = 765
    AMD64_ZMM0H = 766
    AMD64_ZMM1H = 767
    AMD64_ZMM2H = 768
    AMD64_ZMM3H = 769
    AMD64_ZMM4H = 770
    AMD64_ZMM5H = 771
    AMD64_ZMM6H = 772
    AMD64_ZMM7H = 773
    AMD64_ZMM8H = 774
    AMD64_ZMM9H = 775
    AMD64_ZMM10H = 776
    AMD64_ZMM11H = 777
    AMD64_ZMM12H = 778
    AMD64_ZMM13H = 779
    AMD64_ZMM14H = 780
    AMD64_ZMM15H = 781
    AMD64_XMM16L = 782
    AMD64_XMM17L = 783
    AMD64_XMM18L = 784
    AMD64_XMM19L = 785
    AMD64_XMM20L = 786
    AMD64_XMM21L = 787
    AMD64_XMM22L = 788
    AMD64_XMM23L = 789
    AMD64_XMM24L = 790
    AMD64_XMM25L = 791
    AMD64_XMM26L = 792
    AMD64_XMM27L = 793
    AMD64_XMM28L = 794
    AMD64_XMM29L = 795
    AMD64_XMM30L = 796
    AMD64_XMM31L = 797
    AMD64_XMM16_0 = 798
    AMD64_XMM17_0 = 799
    AMD64_XMM18_0 = 800
    AMD64_XMM19_0 = 801
    AMD64_XMM20_0 = 802
    AMD64_XMM21_0 = 803
    AMD64_XMM22_0 = 804
    AMD64_XMM23_0 = 805
    AMD64_XMM24_0 = 806
    AMD64_XMM25_0 = 807
    AMD64_XMM26_0 = 808
    AMD64_XMM27_0 = 809
    AMD64_XMM28_0 = 810
    AMD64_XMM29_0 = 811
    AMD64_XMM30_0 = 812
    AMD64_XMM31_0 = 813
    AMD64_XMM16H = 814
    AMD64_XMM17H = 815
    AMD64_XMM18H = 816
    AMD64_XMM19H = 817
    AMD64_XMM20H = 818
    AMD64_XMM21H = 819
    AMD64_XMM22H = 820
    AMD64_XMM23H = 821
    AMD64_XMM24H = 822
    AMD64_XMM25H = 823
    AMD64_XMM26H = 824
    AMD64_XMM27H = 825
    AMD64_XMM28H = 826
    AMD64_XMM29H = 827
    AMD64_XMM30H = 828
    AMD64_XMM31H = 829
    AMD64_EMM16H = 830
    AMD64_EMM17H = 831
    AMD64_EMM18H = 832
    AMD64_EMM19H = 833
    AMD64_EMM20H = 834
    AMD64_EMM21H = 835
    AMD64_EMM22H = 836
    AMD64_EMM23H = 837
    AMD64_EMM24H = 838
    AMD64_EMM25H = 839
    AMD64_EMM26H = 840
    AMD64_EMM27H = 841
    AMD64_EMM28H = 842
    AMD64_EMM29H = 843
    AMD64_EMM30H = 844
    AMD64_EMM31H = 845
    AMD64_SSP = 846
    AMD64_TMM0 = 847
    AMD64_TMM1 = 848
    AMD64_TMM2 = 849
    AMD64_TMM3 = 850
    AMD64_TMM4 = 851
    AMD64_TMM5 = 852
    AMD64_TMM6 = 853
    AMD64_TMM7 = 854


class HLSLREG(IntEnum):
    HLSLREG_TEMP = 0
    HLSLREG_INPUT = 1
    HLSLREG_OUTPUT = 2
    HLSLREG_INDEXABLE_TEMP = 3
    HLSLREG_IMMEDIATE32 = 4
    HLSLREG_IMMEDIATE64 = 5
    HLSLREG_SAMPLER = 6
    HLSLREG_RESOURCE = 7
    HLSLREG_CONSTANT_BUFFER = 8
    HLSLREG_IMMEDIATE_CONSTANT_BUFFER = 9
    HLSLREG_LABEL = 10
    HLSLREG_INPUT_PRIMITIVEID = 11
    HLSLREG_OUTPUT_DEPTH = 12
    HLSLREG_NULL = 13
    HLSLREG_RASTERIZER = 14
    HLSLREG_OUTPUT_COVERAGE_MASK = 15
    HLSLREG_STREAM = 16
    HLSLREG_FUNCTION_BODY = 17
    HLSLREG_FUNCTION_TABLE = 18
    HLSLREG_INTERFACE = 19
    HLSLREG_FUNCTION_INPUT = 20
    HLSLREG_FUNCTION_OUTPUT = 21
    HLSLREG_OUTPUT_CONTROL_POINT_ID = 22
    HLSLREG_INPUT_FORK_INSTANCE_ID = 23
    HLSLREG_INPUT_JOIN_INSTANCE_ID = 24
    HLSLREG_INPUT_CONTROL_POINT = 25
    HLSLREG_OUTPUT_CONTROL_POINT = 26
    HLSLREG_INPUT_PATCH_CONSTANT = 27
    HLSLREG_INPUT_DOMAIN_POINT = 28
    HLSLREG_THIS_POINTER = 29
    HLSLREG_UNORDERED_ACCESS_VIEW = 30
    HLSLREG_THREAD_GROUP_SHARED_MEMORY = 31
    HLSLREG_INPUT_THREAD_ID = 32
    HLSLREG_INPUT_THREAD_GROUP_ID = 33
    HLSLREG_INPUT_THREAD_ID_IN_GROUP = 34
    HLSLREG_INPUT_COVERAGE_MASK = 35
    HLSLREG_INPUT_THREAD_ID_IN_GROUP_FLATTENED = 36
    HLSLREG_INPUT_GS_INSTANCE_ID = 37
    HLSLREG_OUTPUT_DEPTH_GREATER_EQUAL = 38
    HLSLREG_OUTPUT_DEPTH_LESS_EQUAL = 39
    HLSLREG_CYCLE_COUNTER = 40


class StackFrameType(IntEnum):
    FPO = 0
    Trap = auto()
    TSS = auto()
    Standard = auto()
    FrameData = auto()
    Unknown = -1


class MemoryType(IntEnum):
    Code = 0
    Data = auto()
    Stack = auto()
    CodeOnHeap = auto()
    Any = -1


class HLSLMemorySpace(IntEnum):
    DATA = 0x00
    SAMPLER = 0x01
    RESOURCE = 0x02
    RWRESOURCE = 0x03
    MAX = 0x0F


class NameHashBuild(IntEnum):
    START = 0
    PAUSE = auto()
    RESUME = auto()
    COMPLETE = auto()
    ERROR = auto()
    OOM = ERROR
    FAIL_TO_OPEN_MOD = auto()


class CoroutineKind(IntEnum):
    NONE = 0
    PRIMARY = auto()
    INIT = auto()
    RESUME = auto()
    DESTROY = auto()


class AssociationKind(IntEnum):
    NONE = 0
    COROUTINE = auto()


