"""
Enrich2 configuration constants module
======================================

This module contains all the constants used as keys in configuration files.
"""


NAME = "name"
CONDITIONS = "conditions"
LIBRARIES = "libraries"
SELECTIONS = "selections"
TIMEPOINT = "timepoint"
OUTPUT_DIR = "output directory"
REPORT_FILTERED_READS = "report filtered reads"
STORE = "store"
OVERLAP = "overlap"

FASTQ = "fastq"
READS = "reads"
REVERSE = "reverse"
FILTERS = "filters"
FILTERS_MAX_N = "max N"
FILTERS_MIN_COUNT = "min count"
FILTERS_AVG_Q = "avg quality"
FILTERS_MIN_Q = "min quality"
FILTERS_CHASTITY = "chastity"
TRIM_START = "start"
TRIM_LENGTH = "length"
SCORER = "scorer"
SCORER_PATH = "scorer path"
SCORER_OPTIONS = "scorer options"


COUNTS_FILE = "counts file"
IDENTIFIERS = "identifiers"
IDENTIFIERS_MIN_COUNT = "min count"

VARIANTS = "variants"
VARIANTS_MIN_COUNT = "min count"
VARIANTS_MAX_MUTATIONS = "max mutations"
USE_ALIGNER = "use aligner"
WILDTYPE = "wild type"
CODING = "coding"
REF_OFFSET = "reference offset"
SEQUENCE = "sequence"

BARCODES = "barcodes"
BARCODE_MAP_FILE = "map file"
BARCODE_MIN_COUNT = "min count"

FORCE_RECALCULATE = "force_recalculate"
COMPONENT_OUTLIERS = "component_outliers"
TSV_REQUESTED = "tsv_requested"
OUTPUT_DIR_OVERRIDE = "output_dir_override"
