'''util.py: Contains utility functions used throughout the project.'''

###########################################################################################
# Copyright 2022 Garmin International, Inc.
# Licensed under the Flexible and Interoperable Data Transfer (FIT) Protocol License; you
# may not use this file except in compliance with the Flexible and Interoperable Data
# Transfer (FIT) Protocol License.
###########################################################################################
# ****WARNING****  This file is auto-generated!  Do NOT edit this file.
# Profile Version = 21.94Release
# Tag = production/akw/21.94.00-0-g0f668193
############################################################################################


from datetime import datetime, timezone

FIT_EPOCH_S = 631065600

def convert_timestamp_to_datetime(timestamp):
    '''Takes a FIT datetime timestamp and converts it to a python datetime in utc'''
    utc_datetime = datetime.utcfromtimestamp((timestamp if timestamp else 0) + FIT_EPOCH_S)
    return utc_datetime.replace(tzinfo=timezone.utc)

def _convert_string(string):
    '''Takes a string and converts it according to the fit protocol standard.'''
    string = string.decode("utf-8", errors="ignore")
    strings = string.split(sep='\0')

    while strings[len(strings) - 1] == '':
        strings.pop()
        if len(strings) == 0:
            return None

    if len(strings) == 1:
        return strings[0]
    else:
        return strings

def _only_invalid_values(raw_field_value, invalid_value):
    '''Returns whether the given value(s) consist of only invalid values.'''
    if isinstance(raw_field_value, list):
        for value in raw_field_value:
            if value != invalid_value:
                return False

        return True

    return raw_field_value == invalid_value
