# Loris
[![Travis](https://img.shields.io/travis/neuromorphic-paris/loris/master.svg?label=Travis%20CI)](https://www.travis-ci.org/neuromorphic-paris/loris)

With loris you can read and write different file formats from neuromorphic cameras such as **.aedat4**, **.dat**, [.es](https://github.com/neuromorphic-paris/event_stream) or **.csv**. Loris is also an [amazing animal](https://giphy.com/search/slow-loris)

### Supported formats
|           | version | read    | write   |
|-----------|--------:|:-------:|:-------:|
| .aedat4   | 4       | &#9745; | &#9744; |
| .dat      | 1/2     | &#9745; | &#9744; |
| .es       | 2.x     | &#9745; | &#9745; |
| .csv      | -       | &#9745; | &#9744; |

### Install
~~~python
pip install loris
~~~

### How to loris
##### Read a file, for example a .dat file and loop over all events
~~~python
import loris
my_file = loris.read_file("/path/to/my-file.dat")
events = my_file['events']

for event in events:
    print("ts:", event.t, "x:", event.x, "y:", event.y, "p:", event.p)
~~~

##### Write events from an array to an .es file
~~~python
ordering = "xytp"  # corresponds to the order in your array
loris.write_events_to_file(event_array, "/path/to/my-file.es", ordering)
~~~

##### Write structured events (with dtypes) to an .es file
~~~python
loris.write_events_to_file(structured_event_array, "/path/to/my-file.es")
~~~

### Windows test (for developers)

To make sure the library works on Windows (if you use macOS or Linux), follow these steps:

1. Download Vagrant (https://www.vagrantup.com/)
2. `cd windows`
3. `vagrant up` (this will download a virtual machine and build the package)
4. `vargrant ssh` (optional, to inspect the Windows VM)
5. `vagrant destroy -f` (cleanup)

![loris](loris.gif "The Loris Banner")
