(self["webpackChunkweb_js"] = self["webpackChunkweb_js"] || []).push([["node_modules_monaco-editor_esm_vs_basic-languages_rust_rust_js"],{

/***/ "./node_modules/monaco-editor/esm/vs/basic-languages/rust/rust.js":
/*!************************************************************************!*\
  !*** ./node_modules/monaco-editor/esm/vs/basic-languages/rust/rust.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "conf": () => (/* binding */ conf),
/* harmony export */   "language": () => (/* binding */ language)
/* harmony export */ });
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/

// src/basic-languages/rust/rust.ts
var conf = {
  comments: {
    lineComment: "//",
    blockComment: ["/*", "*/"]
  },
  brackets: [
    ["{", "}"],
    ["[", "]"],
    ["(", ")"]
  ],
  autoClosingPairs: [
    { open: "[", close: "]" },
    { open: "{", close: "}" },
    { open: "(", close: ")" },
    { open: '"', close: '"', notIn: ["string"] }
  ],
  surroundingPairs: [
    { open: "{", close: "}" },
    { open: "[", close: "]" },
    { open: "(", close: ")" },
    { open: '"', close: '"' },
    { open: "'", close: "'" }
  ],
  folding: {
    markers: {
      start: new RegExp("^\\s*#pragma\\s+region\\b"),
      end: new RegExp("^\\s*#pragma\\s+endregion\\b")
    }
  }
};
var language = {
  tokenPostfix: ".rust",
  defaultToken: "invalid",
  keywords: [
    "as",
    "async",
    "await",
    "box",
    "break",
    "const",
    "continue",
    "crate",
    "dyn",
    "else",
    "enum",
    "extern",
    "false",
    "fn",
    "for",
    "if",
    "impl",
    "in",
    "let",
    "loop",
    "match",
    "mod",
    "move",
    "mut",
    "pub",
    "ref",
    "return",
    "self",
    "static",
    "struct",
    "super",
    "trait",
    "true",
    "try",
    "type",
    "unsafe",
    "use",
    "where",
    "while",
    "catch",
    "default",
    "union",
    "static",
    "abstract",
    "alignof",
    "become",
    "do",
    "final",
    "macro",
    "offsetof",
    "override",
    "priv",
    "proc",
    "pure",
    "sizeof",
    "typeof",
    "unsized",
    "virtual",
    "yield"
  ],
  typeKeywords: [
    "Self",
    "m32",
    "m64",
    "m128",
    "f80",
    "f16",
    "f128",
    "int",
    "uint",
    "float",
    "char",
    "bool",
    "u8",
    "u16",
    "u32",
    "u64",
    "f32",
    "f64",
    "i8",
    "i16",
    "i32",
    "i64",
    "str",
    "Option",
    "Either",
    "c_float",
    "c_double",
    "c_void",
    "FILE",
    "fpos_t",
    "DIR",
    "dirent",
    "c_char",
    "c_schar",
    "c_uchar",
    "c_short",
    "c_ushort",
    "c_int",
    "c_uint",
    "c_long",
    "c_ulong",
    "size_t",
    "ptrdiff_t",
    "clock_t",
    "time_t",
    "c_longlong",
    "c_ulonglong",
    "intptr_t",
    "uintptr_t",
    "off_t",
    "dev_t",
    "ino_t",
    "pid_t",
    "mode_t",
    "ssize_t"
  ],
  constants: ["true", "false", "Some", "None", "Left", "Right", "Ok", "Err"],
  supportConstants: [
    "EXIT_FAILURE",
    "EXIT_SUCCESS",
    "RAND_MAX",
    "EOF",
    "SEEK_SET",
    "SEEK_CUR",
    "SEEK_END",
    "_IOFBF",
    "_IONBF",
    "_IOLBF",
    "BUFSIZ",
    "FOPEN_MAX",
    "FILENAME_MAX",
    "L_tmpnam",
    "TMP_MAX",
    "O_RDONLY",
    "O_WRONLY",
    "O_RDWR",
    "O_APPEND",
    "O_CREAT",
    "O_EXCL",
    "O_TRUNC",
    "S_IFIFO",
    "S_IFCHR",
    "S_IFBLK",
    "S_IFDIR",
    "S_IFREG",
    "S_IFMT",
    "S_IEXEC",
    "S_IWRITE",
    "S_IREAD",
    "S_IRWXU",
    "S_IXUSR",
    "S_IWUSR",
    "S_IRUSR",
    "F_OK",
    "R_OK",
    "W_OK",
    "X_OK",
    "STDIN_FILENO",
    "STDOUT_FILENO",
    "STDERR_FILENO"
  ],
  supportMacros: [
    "format!",
    "print!",
    "println!",
    "panic!",
    "format_args!",
    "unreachable!",
    "write!",
    "writeln!"
  ],
  operators: [
    "!",
    "!=",
    "%",
    "%=",
    "&",
    "&=",
    "&&",
    "*",
    "*=",
    "+",
    "+=",
    "-",
    "-=",
    "->",
    ".",
    "..",
    "...",
    "/",
    "/=",
    ":",
    ";",
    "<<",
    "<<=",
    "<",
    "<=",
    "=",
    "==",
    "=>",
    ">",
    ">=",
    ">>",
    ">>=",
    "@",
    "^",
    "^=",
    "|",
    "|=",
    "||",
    "_",
    "?",
    "#"
  ],
  escapes: /\\([nrt0\"''\\]|x\h{2}|u\{\h{1,6}\})/,
  delimiters: /[,]/,
  symbols: /[\#\!\%\&\*\+\-\.\/\:\;\<\=\>\@\^\|_\?]+/,
  intSuffixes: /[iu](8|16|32|64|128|size)/,
  floatSuffixes: /f(32|64)/,
  tokenizer: {
    root: [
      [/r(#*)"/, { token: "string.quote", bracket: "@open", next: "@stringraw.$1" }],
      [
        /[a-zA-Z][a-zA-Z0-9_]*!?|_[a-zA-Z0-9_]+/,
        {
          cases: {
            "@typeKeywords": "keyword.type",
            "@keywords": "keyword",
            "@supportConstants": "keyword",
            "@supportMacros": "keyword",
            "@constants": "keyword",
            "@default": "identifier"
          }
        }
      ],
      [/\$/, "identifier"],
      [/'[a-zA-Z_][a-zA-Z0-9_]*(?=[^\'])/, "identifier"],
      [/'(\S|@escapes)'/, "string.byteliteral"],
      [/"/, { token: "string.quote", bracket: "@open", next: "@string" }],
      { include: "@numbers" },
      { include: "@whitespace" },
      [
        /@delimiters/,
        {
          cases: {
            "@keywords": "keyword",
            "@default": "delimiter"
          }
        }
      ],
      [/[{}()\[\]<>]/, "@brackets"],
      [/@symbols/, { cases: { "@operators": "operator", "@default": "" } }]
    ],
    whitespace: [
      [/[ \t\r\n]+/, "white"],
      [/\/\*/, "comment", "@comment"],
      [/\/\/.*$/, "comment"]
    ],
    comment: [
      [/[^\/*]+/, "comment"],
      [/\/\*/, "comment", "@push"],
      ["\\*/", "comment", "@pop"],
      [/[\/*]/, "comment"]
    ],
    string: [
      [/[^\\"]+/, "string"],
      [/@escapes/, "string.escape"],
      [/\\./, "string.escape.invalid"],
      [/"/, { token: "string.quote", bracket: "@close", next: "@pop" }]
    ],
    stringraw: [
      [/[^"#]+/, { token: "string" }],
      [
        /"(#*)/,
        {
          cases: {
            "$1==$S2": { token: "string.quote", bracket: "@close", next: "@pop" },
            "@default": { token: "string" }
          }
        }
      ],
      [/["#]/, { token: "string" }]
    ],
    numbers: [
      [/(0o[0-7_]+)(@intSuffixes)?/, { token: "number" }],
      [/(0b[0-1_]+)(@intSuffixes)?/, { token: "number" }],
      [/[\d][\d_]*(\.[\d][\d_]*)?[eE][+-][\d_]+(@floatSuffixes)?/, { token: "number" }],
      [/\b(\d\.?[\d_]*)(@floatSuffixes)?\b/, { token: "number" }],
      [/(0x[\da-fA-F]+)_?(@intSuffixes)?/, { token: "number" }],
      [/[\d][\d_]*(@intSuffixes?)?/, { token: "number" }]
    ]
  }
};



/***/ })

}])
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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