"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DiskReplicaPairAddition = exports.DiskReplicaPairAdditionProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ebs_generated_1 = require("./ebs.generated");
Object.defineProperty(exports, "DiskReplicaPairAdditionProperty", { enumerable: true, get: function () { return ebs_generated_1.RosDiskReplicaPairAddition; } });
/**
 * A ROS resource type:  `ALIYUN::EBS::DiskReplicaPairAddition`
 */
class DiskReplicaPairAddition extends ros.Resource {
    /**
     * Create a new `ALIYUN::EBS::DiskReplicaPairAddition`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDiskReplicaPairAddition = new ebs_generated_1.RosDiskReplicaPairAddition(this, id, {
            replicaPairId: props.replicaPairId,
            replicaGroupId: props.replicaGroupId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDiskReplicaPairAddition;
        this.attrReplicaGroupId = rosDiskReplicaPairAddition.attrReplicaGroupId;
        this.attrReplicaPairId = rosDiskReplicaPairAddition.attrReplicaPairId;
    }
}
exports.DiskReplicaPairAddition = DiskReplicaPairAddition;
//# sourceMappingURL=data:application/json;base64,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