from .dataset_instance import DatasetInstance


class Dataset():
    '''

    '''

    def __init__(self, client, datasetId=None, name=None, sourceType=None, createdAt=None, latestDatasetInstance={}):
        self.client = client
        self.id = datasetId
        self.dataset_id = datasetId
        self.name = name
        self.source_type = sourceType
        self.created_at = createdAt
        self.latest_dataset_instance = client._build_class(
            DatasetInstance, latestDatasetInstance)

    def __repr__(self):
        return f"Dataset(dataset_id={repr(self.dataset_id)}, name={repr(self.name)}, source_type={repr(self.source_type)}, created_at={repr(self.created_at)}, latest_dataset_instance={repr(self.latest_dataset_instance)})"

    def __eq__(self, other):
        return self.__class__ == other.__class__ and self.id == other.id

    def to_dict(self):
        return {'dataset_id': self.dataset_id, 'name': self.name, 'source_type': self.source_type, 'created_at': self.created_at, 'latest_dataset_instance': self.latest_dataset_instance.to_dict() if self.latest_dataset_instance else None}

    def attach_to_project(self, project_id, dataset_type):
        return self.client.attach_dataset_to_project(self.dataset_id, project_id, dataset_type)

    def delete(self):
        return self.client.delete_dataset(self.dataset_id)

    def refresh(self):
        self = self.describe()
        return self

    def describe(self):
        return self.client.describe_dataset(self.dataset_id)

    def create_instance(self, location=None, file_format=None):
        return self.client.create_dataset_instance(self.dataset_id, location, file_format)

    def list_instances(self):
        return self.client.list_dataset_instances(self.dataset_id)

    def create_instance_from_local_file(self, file_format=None):
        return self.client.create_dataset_instance_from_local_file(self.dataset_id, file_format)

    def remove_from_project(self, project_id):
        return self.client.remove_dataset_from_project(self.dataset_id, project_id)

    def wait_for_import(self, timeout=900):
        return self.client._poll(self, {'PENDING', 'IMPORTING'}, timeout=timeout)

    def wait_for_inspection(self, timeout=900):
        return self.client._poll(self, {'PENDING', 'IMPORTING', 'INSPECTING'}, timeout=timeout)

    def get_status(self):
        return self.describe().latest_dataset_instance.status
