"""A Python package for interacting with VASP"""
from casm.vasp.error import \
    VaspError,\
    VaspWarning,\
    continue_job,\
    IbzkptError,\
    FEXCFError,\
    SubSpaceMatrixError,\
    InisymError,\
    SgrconError,\
    WavecarError,\
    NbandsError,\
    NoConvergeError,\
    FreezeError,\
    error_check,\
    crash_check
from casm.vasp.run import \
    complete_job,\
    run
from casm.vasp.relax import Relax
from casm.vasp.converge import Converge
__all__ = [
    'io', 'VaspError', 'VaspWarning', 'continue_job', 'IbzkptError',
    'FEXCFError', 'SubSpaceMatrixError', 'InisymError', 'SgrconError',
    'WavecarError', 'NbandsError', 'NoConvergeError', 'FreezeError',
    'error_check', 'crash_check', 'complete_job', 'run', 'Relax', 'Converge'
]
