import pandas as pd

import pystv
from pystv import RaceMetadata, RaceResult
from pystv import RoundResult as RR


def test_results_to_sankey():
    names = ["A", "B", "C"]
    race_result = RaceResult(
        RaceMetadata("race", 2, names),
        [
            RR([0, 2, 5, 3], [2], [], {2: {1: 1}}),
            RR([0, 3, 4, 3], [], [1], {1: {3: 3}}),
            RR([0, 0, 4, 6], [3], [], {}),
        ],
    )
    df_nodes, df_links = pystv.result_to_sankey_data(race_result)

    df_nodes_desired = pd.DataFrame(
        {
            "id": [0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3],
            "label": (["-- exhausted --"] + names) * 3,
        }
    )
    df_links_desired = pd.DataFrame(
        {
            "id": [1, 2, 2, 3, 1, 2, 3],
            "source": [1, 2, 2, 3, 5, 6, 7],
            "target": [5, 5, 6, 7, 11, 10, 11],
            "value": [2, 1, 4, 3, 3, 4, 3],
        }
    )

    pd.testing.assert_frame_equal(df_nodes, df_nodes_desired, check_like=True)
    pd.testing.assert_frame_equal(df_links, df_links_desired, check_like=True)

    # Just make sure this executes (not sure how to test figure generation)
    fig = pystv.create_sankey_fig(df_nodes, df_links)
    assert fig is not None
