# jquery-migrate: Migrate older jQuery code to jQuery 1.9+

This plugin can be used to detect and restore APIs or features that have been deprecated in jQuery and removed as of version 1.9.
See the [warnings page](https://github.com/jquery/jquery-migrate/blob/1.x-stable/warnings.md) for more information regarding messages the plugin generates.
For more information about the changes made in jQuery 1.9, see the [upgrade guide](http://jquery.com/upgrade-guide/1.9/) and [blog post](http://blog.jquery.com/2013/01/15/jquery-1-9-final-jquery-2-0-beta-migrate-final-released/).

In your web page, load this plugin *after* the script for jQuery:

```html
<script src="http://code.jquery.com/jquery-1.11.3.js"></script>
<script src="http://code.jquery.com/jquery-migrate-1.4.1.js"></script>
```

Note that jQuery 3.0 has a [separate version](https://github.com/jquery/jquery-migrate/) of jQuery Migrate. The two versions cannot be used simultaneously on a page, so you should fix any upgrade issues identified by Migrate 1.x before attempting an upgrade.

## Download

### Development vs. Production versions

To make it easier for jQuery developers to find and remove deprecated functionality, the development version of the plugin displays warnings on the browser's console. In browsers that don't support the console interface such as IE7, no messages are generated unless you include a debugging library such as [Firebug Lite](https://getfirebug.com/firebuglite) before including the jQuery Migrate plugin. Developers can also inspect the `jQuery.migrateWarnings` array to see what error messages have been generated.

All warnings generated by this plugin start with the string "JQMIGRATE". A list of the warnings you may see are in [warnings.md](https://github.com/jquery/jquery-migrate/blob/1.x-stable/warnings.md).

### Development version

This version provides console warning messages when deprecated and/or removed APIs are used. Use this version during development and debugging, and whenever you are reporting bugs to the jQuery team.

**Latest released development version:** This file is hosted on jQuery's CDN, and can be hotlinked if desired.
[http://code.jquery.com/jquery-migrate-1.4.1.js](http://code.jquery.com/jquery-migrate-1.4.1.js)

**Current work-in-progress build:** Although this file represents the most recent updates to the plugin, it may not have been thoroughly tested.
[http://code.jquery.com/jquery-migrate-git.js](http://code.jquery.com/jquery-migrate-git.js)

### Production version

The minified production file is compressed and does not generate console warnings.  Do not use this file for development or debugging, it will make your life miserable.

**Latest released production version:**
[http://code.jquery.com/jquery-migrate-1.4.1.min.js](http://code.jquery.com/jquery-migrate-1.4.1.min.js)
 This file is hosted on jQuery's CDN, and can be hotlinked if desired.

**Current work-in-progress build:** Although this file represents the most recent updates to the plugin, it may not have been thoroughly tested. We do not recommend using this file on production sites since it may be unstable; use the released production version above.
[http://code.jquery.com/jquery-migrate-git.min.js](http://code.jquery.com/jquery-migrate-git.min.js)

## Migrate Plugin API

This plugin adds some properties to the `jQuery` object that can be used to programmatically control and examine its behavior:

`jQuery.migrateWarnings`: This property is an array of string warning messages that have been generated by the code on the page, in the order they were generated. Messages appear in the array only once, even if the condition has occurred multiple times, unless `jQuery.migrateReset()` is called.

`jQuery.migrateMute`: Set this property to `true` to prevent console warnings from being generated in the debugging version. The `jQuery.migrateWarnings` array is still maintained when this property is set, which allows programmatic inspection without console output.

`jQuery.migrateTrace`: Set this property to `false` if you want warnings but do not want traces to appear on the console.

`jQuery.migrateReset()`: This method clears the `jQuery.migrateWarnings` array and "forgets" the list of messages that have been seen already.

`jQuery.migrateVersion`: This string property indicates the version of Migrate in use, it was added in version 1.3.0.

## Reporting problems

Bugs that only occur when the jQuery Migrate plugin is used should be reported in the [jQuery Migrate Issue Tracker](https://github.com/jquery/jquery-migrate/issues) and *must* be accompanied by an executable test case that demonstrates the bug. The easiest way to do this is via an online test tool such as [jsFiddle.net](http://jsFiddle.net/) or [jsbin.com](http://jsbin.com). You can use [this jsFiddle template](http://jsfiddle.net/4ZwWv/) or [this jsbin template](http://jsbin.com/emuwuy/4/show) as a starting point; they already contain links to the work-in-progress versions of both jQuery and the jQuery Migrate plugin. Add your code there and post a link to it with your bug report.

Bugs in jQuery itself should be reported on the [jQuery Core bug tracker](http://bugs.jquery.com/) and again should be accompanied by a test case from [jsFiddle.net](http://jsFiddle.net/) or [jsbin.com](http://jsbin.com) so that we can reproduce the issue.

For other questions about the plugin that aren't bugs, ask on the [jQuery Forum](http://forum.jquery.com).

How to run the tests:
====================================================
Clone this repo, install `grunt`:

```sh
git clone git://github.com/jquery/jquery-migrate.git
cd jquery-migrate
npm install
npm install -g grunt-cli
```

Run `grunt` to `jshint`, `qunit` and `uglify` release.

```sh
grunt
```
