# 带缓存的下载逻辑

首先给出 cache dir 参数，允许自定义缓存文件夹，默认为 `$HOME/.cache/omni_pathlib`

对每个 path，计算 path 的 md5 值，{md5}.bytes 作为缓存文件名

关键地方来了，对于 path 的下载逻辑：

1. 首先检查缓存文件是否存在，如果存在，则直接返回缓存文件
2. 如果缓存文件不存在，则下载文件，但是优先尝试流式下载
3. 若流式下载服务器支持断点续传，则缓存文件需要改名为 {md5}.bytes.part
4. 这样如果支持断点续传的流式下载中断，通过读取 {md5}.bytes.part 文件，可以获取已经下载的长度，继续下载，直到完成
5. 下载完成后，将 {md5}.bytes.part 改名为 {md5}.bytes
6. 如果流式下载不支持断点续传，则下载完成后，将文件保存到缓存文件
7. 如果不支持流式下载，则退回到普通下载，下载完成后，将文件保存到缓存文件
