# varsom-landslide-client
No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: v1.0.6
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import varsom_landslide_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import varsom_landslide_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import varsom_landslide_client
from varsom_landslide_client.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = varsom_landslide_client.CapApi(varsom_landslide_client.ApiClient(configuration))
startdate = '2013-10-20T19:20:30+01:00' # datetime | 
enddate = '2013-10-20T19:20:30+01:00' # datetime | 

try:
    api_response = api_instance.cap_feed(startdate, enddate)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CapApi->cap_feed: %s\n" % e)

# create an instance of the API class
api_instance = varsom_landslide_client.CapApi(varsom_landslide_client.ApiClient(configuration))
id = 'id_example' # str | 

try:
    api_response = api_instance.cap_id(id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CapApi->cap_id: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api01.nve.no/hydrology/forecast/landslide/v1.0.6*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CapApi* | [**cap_feed**](docs/CapApi.md#cap_feed) | **GET** /api/Cap/Feed/{startdate}/{enddate} | 
*CapApi* | [**cap_id**](docs/CapApi.md#cap_id) | **GET** /api/Cap/Id/{id} | 
*RegionApi* | [**region_get**](docs/RegionApi.md#region_get) | **GET** /api/Region/{countyId} | 
*WarningApi* | [**warning_all**](docs/WarningApi.md#warning_all) | **GET** /api/Warning/All/{langkey}/{startdate}/{enddate} | 
*WarningApi* | [**warning_county**](docs/WarningApi.md#warning_county) | **GET** /api/Warning/County/{county}/{langkey}/{startdate}/{enddate} | 
*WarningApi* | [**warning_get**](docs/WarningApi.md#warning_get) | **GET** /api/Warning/{langkey}/{startdate}/{enddate} | 
*WarningApi* | [**warning_municipality**](docs/WarningApi.md#warning_municipality) | **GET** /api/Warning/Municipality/{municipality}/{langkey}/{startdate}/{enddate} | 

## Documentation For Models

 - [Alert](docs/Alert.md)
 - [AlertInfo](docs/AlertInfo.md)
 - [AlertInfoArea](docs/AlertInfoArea.md)
 - [AlertInfoAreaGeocode](docs/AlertInfoAreaGeocode.md)
 - [AlertInfoEventCode](docs/AlertInfoEventCode.md)
 - [AlertInfoParameter](docs/AlertInfoParameter.md)
 - [AlertInfoResource](docs/AlertInfoResource.md)
 - [Cause](docs/Cause.md)
 - [CodePageDataItem](docs/CodePageDataItem.md)
 - [County](docs/County.md)
 - [DecoderFallback](docs/DecoderFallback.md)
 - [EncoderFallback](docs/EncoderFallback.md)
 - [Encoding](docs/Encoding.md)
 - [FormattedContentResultAlert](docs/FormattedContentResultAlert.md)
 - [FormattedContentResultListAlert](docs/FormattedContentResultListAlert.md)
 - [IRequiredMemberSelector](docs/IRequiredMemberSelector.md)
 - [MediaTypeFormatter](docs/MediaTypeFormatter.md)
 - [MediaTypeHeaderValue](docs/MediaTypeHeaderValue.md)
 - [MediaTypeMapping](docs/MediaTypeMapping.md)
 - [MicroBlogPost](docs/MicroBlogPost.md)
 - [Municipality](docs/Municipality.md)
 - [NameValueHeaderValue](docs/NameValueHeaderValue.md)
 - [Station](docs/Station.md)
 - [Warning](docs/Warning.md)

## Documentation For Authorization

 All endpoints do not require authorization.


## Author


