/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;

public class JenaRuntime {
    public static final String featureNoSecurity = "http://jena.hpl.hp.com/2004/07/feature/noSecurity";
    public static final String featureNoCharset = "http://jena.hpl.hp.com/2004/07/feature/noCharset";
    static Map<String, String> features = new HashMap<String, String>();
    static final String lineSeparator;

    public static void setFeature(String featureName) {
        features.put(featureName, "true");
    }

    public static boolean runUnder(String featureName) {
        return features.containsKey(featureName);
    }

    public static boolean runNotUnder(String featureName) {
        return !features.containsKey(featureName);
    }

    public static String getLineSeparator() {
        return lineSeparator;
    }

    public static String getSystemProperty(String propName) {
        return JenaRuntime.getSystemProperty(propName, null);
    }

    public static String getSystemProperty(final String propName, String defaultValue) {
        try {
            return System.getProperty(propName, defaultValue);
        }
        catch (SecurityException ex) {
            if (JenaRuntime.runUnder(featureNoSecurity)) {
                return defaultValue;
            }
            try {
                PrivilegedAction<String> a = new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty(propName);
                    }
                };
                return AccessController.doPrivileged(a);
            }
            catch (Exception ex2) {
                return defaultValue;
            }
        }
    }

    static {
        if (JenaRuntime.getSystemProperty(featureNoSecurity) != null) {
            JenaRuntime.setFeature(featureNoSecurity);
        }
        if (JenaRuntime.getSystemProperty(featureNoCharset) != null) {
            JenaRuntime.setFeature(featureNoCharset);
        }
        lineSeparator = JenaRuntime.getSystemProperty("line.separator", "\n");
    }
}

