from typing import Any, Dict, List, Optional, Set, Union

from java.lang import Number, Object, String, StringBuffer
from java.math import RoundingMode
from java.util import Calendar, Currency, Date, Locale, TimeZone

class CharacterIterator:
    DONE: str
    def clone(self) -> str: ...
    def current(self) -> str: ...
    def first(self) -> str: ...
    def getBeginIndex(self) -> int: ...
    def getEndIndex(self) -> int: ...
    def getIndex(self) -> int: ...
    def last(self) -> str: ...
    def next(self) -> str: ...
    def previous(self) -> str: ...
    def setIndex(self, position: int) -> str: ...

class AttributedCharacterIterator(CharacterIterator):
    def clone(self) -> str: ...
    def current(self) -> str: ...
    def first(self) -> str: ...
    def getAllAttributeKeys(self) -> Set[AttributedCharacterIterator.Attribute]: ...
    def getAttribute(
        self, attribute: AttributedCharacterIterator.Attribute
    ) -> Object: ...
    def getAttributes(self) -> Dict[AttributedCharacterIterator.Attribute, Object]: ...
    def getBeginIndex(self) -> int: ...
    def getEndIndex(self) -> int: ...
    def getIndex(self) -> int: ...
    def last(self) -> str: ...
    def next(self) -> str: ...
    def previous(self) -> str: ...
    def setIndex(self, position: int) -> str: ...

    class Attribute(Object):
        INPUT_METHOD_SEGMENT: AttributedCharacterIterator.Attribute
        LANGUAGE: AttributedCharacterIterator.Attribute
        READING: AttributedCharacterIterator.Attribute

class FieldPosition(Object):
    def __init__(self, *args: Any) -> None: ...
    def getBeginIndex(self) -> int: ...
    def getEndIndex(self) -> int: ...
    def getField(self) -> Any: ...
    def getFieldAttribute(self) -> Format.Field: ...
    def setBeginIndex(self, bi: int) -> None: ...
    def setEndIndex(self, ei: int) -> None: ...

class Format(Object):
    def clone(self) -> Object: ...
    def formatToCharacterIterator(self, obj: Object) -> AttributedCharacterIterator: ...
    def parseObject(
        self, source: String, pos: Optional[ParsePosition] = ...
    ) -> Object: ...

    class Field(AttributedCharacterIterator.Attribute): ...

class DateFormat(Format):
    AM_PM_FIELD: int
    DATE_FIELD: int
    DAY_OF_WEEK_FIELD: int
    DAY_OF_WEEK_IN_MONTH_FIELD: int
    DAY_OF_YEAR_FIELD: int
    DEFAULT: int
    ERA_FIELD: int
    FULL: int
    HOUR_OF_DAY0_FIELD: int
    HOUR_OF_DAY1_FIELD: int
    HOUR0_FIELD: int
    HOUR1_FIELD: int
    LONG: int
    MEDIUM: int
    MILLISECOND_FIELD: int
    MONTH_FIELD: int
    SECOND_FIELD: int
    SHORT: int
    TIMEZONE_FIELD: int
    WEEK_OF_MONTH_FIELD: int
    WEEK_OF_YEAR_FIELD: int
    YEAR_FIELD: int
    def format(
        self,
        date: Union[Date, Object],
        toAppendTo: Optional[StringBuffer] = ...,
        pos: Optional[FieldPosition] = ...,
    ) -> Union[String, StringBuffer]: ...
    @staticmethod
    def getAvailableLocales() -> List[Locale]: ...
    def getCalendar(self) -> Calendar: ...
    @staticmethod
    def getDateInstance(
        style: Optional[int] = ..., aLocale: Optional[Locale] = ...
    ) -> DateFormat: ...
    @staticmethod
    def getDateTimeInstance() -> DateFormat: ...
    @staticmethod
    def getInstance() -> DateFormat: ...
    def getNumberFormat(self) -> NumberFormat: ...
    @staticmethod
    def getTimeInstance(style: int, aLocale: Optional[Locale] = ...) -> DateFormat: ...
    def getTimeZone(self) -> TimeZone: ...
    def isLenient(self) -> bool: ...
    def parse(self, source: String) -> Date: ...
    def setCalendar(self, newCalendar: Calendar) -> None: ...
    def setLenient(self, lenient: bool) -> None: ...
    def setNumberFormat(self, newNumberFormat: NumberFormat) -> None: ...
    def setTimeZone(self, zone: TimeZone) -> None: ...

class DateFormatSymbols(Object):
    def __init__(self, locale: Optional[Locale] = ...) -> None: ...
    def clone(self) -> Object: ...
    def getAmPmStrings(self) -> List[String]: ...
    @staticmethod
    def getAvailableLocales() -> List[Locale]: ...
    def getEras(self) -> List[String]: ...
    @staticmethod
    def getInstance(locale: Optional[Locale] = ...) -> DateFormatSymbols: ...
    def getLocalPatternChars(self) -> String: ...
    def getMonths(self) -> List[String]: ...
    def getShortMonths(self) -> List[String]: ...
    def getShortWeekdays(self) -> List[String]: ...
    def getWeekdays(self) -> List[String]: ...
    def getZoneStrings(self) -> List[List[String]]: ...
    def setAmPmStrings(self, newAmpms: List[String]) -> None: ...
    def setEras(self, newEras: List[String]) -> None: ...
    def setLocalPatternChars(self, newLocalPatternChars: String) -> None: ...
    def setMonths(self, newMonths: List[String]) -> None: ...
    def setShortMonths(self, newShortMonths: List[String]) -> None: ...
    def setShortWeekdays(self, newShortWeekdays: List[String]) -> None: ...
    def setWeekdays(self, newWeekdays: List[String]) -> None: ...
    def setZoneStrings(self, newZoneStrings: List[List[String]]) -> None: ...

class NumberFormat(Format):
    FRACTION_FIELD: int
    INTEGER_FIELD: int
    def format(
        self,
        number: Union[float, long, Object],
        toAppendTo: Optional[StringBuffer] = ...,
        pos: Optional[FieldPosition] = ...,
    ) -> Union[String, StringBuffer]: ...
    @staticmethod
    def getAvailableLocales() -> List[Locale]: ...
    def getCurrency(self) -> Currency: ...
    @staticmethod
    def getCurrencyInstance(inLocale: Optional[Locale] = ...) -> NumberFormat: ...
    @staticmethod
    def getInstance(inLocale: Optional[Locale] = ...) -> NumberFormat: ...
    @staticmethod
    def getIntegerInstance(inLocale: Optional[Locale] = ...) -> NumberFormat: ...
    def getMaximumFractionDigits(self) -> int: ...
    def getMaximumIntegerDigits(self) -> int: ...
    def getMinimumFractionDigits(self) -> int: ...
    def getMinimumIntegerDigits(self) -> int: ...
    @staticmethod
    def getNumberInstance(inLocale: Optional[Locale] = ...) -> NumberFormat: ...
    @staticmethod
    def getPercentInstance(inLocale: Optional[Locale] = ...) -> NumberFormat: ...
    def getRoundingMode(self) -> RoundingMode: ...
    def isGroupingUsed(self) -> bool: ...
    def isParseIntegerOnly(self) -> bool: ...
    def parse(self, source: String) -> Number: ...
    def setCurrency(self, currency: Currency) -> None: ...
    def setGroupingUsed(self, newValue: bool) -> None: ...
    def setMaximumFractionDigits(self, newValue: int) -> None: ...
    def setMaximumIntegerDigits(self, newValue: int) -> None: ...
    def setMinimumFractionDigits(self, newValue: int) -> None: ...
    def setMinimumIntegerDigits(self, newValue: int) -> None: ...
    def setParseIntegerOnly(self, value: bool) -> None: ...
    def setRoundingMode(self, roundingMode: RoundingMode) -> None: ...

    class Field(Format.Field):
        CURRENCY: NumberFormat.Field
        DECIMAL_SEPARATOR: NumberFormat.Field
        EXPONENT: NumberFormat.Field
        EXPONENT_SIGN: NumberFormat.Field
        EXPONENT_SYMBOL: NumberFormat.Field
        FRACTION: NumberFormat.Field
        GROUPING_SEPARATOR: NumberFormat.Field
        INTEGER: NumberFormat.Field
        PERCENT: NumberFormat.Field
        PERMILLE: NumberFormat.Field
        SIGN: NumberFormat.Field

class ParsePosition(Object):
    def __init__(self, index: int) -> None: ...
    def getErrorIndex(self) -> int: ...
    def getIndex(self) -> int: ...
    def setErrorIndex(self, ei: int) -> None: ...
    def setIndex(self, index: int) -> None: ...

class SimpleDateFormat(DateFormat):
    def __init__(
        self,
        pattern: Optional[String] = ...,
        arg: Union[DateFormatSymbols, Locale, None] = ...,
    ) -> None: ...
    def applyLocalizedPattern(self, pattern: String) -> None: ...
    def applyPattern(self, pattern: String) -> None: ...
    def get2DigitYearStart(self) -> Date: ...
    def getDateFormatSymbols(self) -> DateFormatSymbols: ...
    def set2DigitYearStart(self, startDate: Date) -> None: ...
    def setDateFormatSymbols(self, newFormatSymbols: DateFormatSymbols) -> None: ...
    def toLocalizedPattern(self) -> String: ...
    def toPattern(self) -> String: ...
