from typing import Any, Dict, List, Optional, Tuple, Union

from com.inductiveautomation.ignition.common import BasicDataset, Dataset
from com.inductiveautomation.ignition.common.model.values import (
    QualifiedValue,
    QualityCode,
)
from com.inductiveautomation.ignition.common.opc import BrowseElementType
from com.inductiveautomation.ignition.common.script.abc import AbstractJythonSequence
from com.inductiveautomation.ignition.common.script.message import Request
from java.io import OutputStream, Writer
from java.lang import Class
from java.lang import Exception as JavaException
from java.lang import Object, String
from java.util import Locale
from org.json import JSONObject
from org.python.core import PyFunction, PyList, PyObject, PySequence
from org.slf4j import Logger

class AbstractOPCUtilities(Object):
    def browseServer(
        self, opcServer: String, nodeId: String
    ) -> List[AbstractOPCUtilities.PyOPCTag]: ...
    def getServers(self, *args: PyObject, **kwargs: String) -> List[String]: ...
    def getServerState(self, opcServer: String) -> String: ...
    def isServerEnabled(self, serverName: String) -> bool: ...
    def readValue(self, opcServer: String, itemPath: String) -> QualifiedValue: ...
    def readValues(
        self, opcServer: String, itemPaths: List[String]
    ) -> QualifiedValue: ...
    def setServerEnabled(self, serverName: String, enabled: bool) -> None: ...
    def writeValue(self, *args: PyObject, **kwargs: String) -> QualityCode: ...
    def writeValues(self, *args: PyObject, **kwargs: String) -> List[QualityCode]: ...

    class PyOPCTag(PyObject):
        displayName: String
        elementType: BrowseElementType
        nodeId: String
        serverName: String
        def __init__(
            self,
            serverName: String,
            nodeId: String,
            displayName: String,
            elementType: BrowseElementType,
        ) -> None: ...
        def __findattr_ex__(self, name: String) -> PyObject: ...
        def getDisplayName(self) -> String: ...
        def getElementType(self) -> BrowseElementType: ...
        def getNodeId(self) -> String: ...
        def getServerName(self) -> String: ...

class DatasetUtilities(Object):
    @staticmethod
    def addColumn(ds: Dataset, *args: Any) -> Dataset: ...
    @staticmethod
    def addRow(ds: Dataset, *args: Any) -> Dataset: ...
    @staticmethod
    def addRows(ds: Dataset, *args: Any) -> Dataset: ...
    @staticmethod
    def appendDataset(ds1: Dataset, ds2: Dataset) -> Dataset: ...
    @staticmethod
    def clearDataset(ds: Dataset) -> Dataset: ...
    @staticmethod
    def dataSetToExcel(headerRow: bool, datasets: List[Object]) -> String: ...
    @staticmethod
    def dataSetToExcelBytes(
        headerRow: bool,
        objects: List[Object],
        nullsEmpty: bool,
        sheetNames: List[String],
    ) -> bytearray: ...
    @staticmethod
    def dataSetToExcelStreaming(
        headerRow: bool, objects: List[Object], out: OutputStream, nullsEmpty: bool
    ) -> None: ...
    @staticmethod
    def dataSetToHTML(headerRow: bool, ds: Dataset, title: String) -> String: ...
    @staticmethod
    def dataSetToHTMLStreaming(
        headerRow: bool, ds: Dataset, title: String, fw: Writer
    ) -> None: ...
    @staticmethod
    def deleteRow(ds: Dataset, row: int) -> Dataset: ...
    @staticmethod
    def deleteRows(ds: Dataset, rows: List[int]) -> Dataset: ...
    @staticmethod
    def filterColumns(dataset: Dataset, columns: PySequence) -> Dataset: ...
    @staticmethod
    def formatDates(
        dataset: Dataset, format: String, locale: Locale = ...
    ) -> Dataset: ...
    @staticmethod
    def fromCSV(csv: String) -> Dataset: ...
    @staticmethod
    def fromCSVJava(csv: String) -> Dataset: ...
    @staticmethod
    def getColumnHeaders(ds: Dataset) -> PyList: ...
    @staticmethod
    def insertColumn(ds: Dataset, *args: Any) -> Dataset: ...
    @staticmethod
    def insertRow(ds: Dataset, *args: Any) -> Dataset: ...
    @staticmethod
    def setValue(
        ds: Dataset, row: int, col: Union[int, String], value: Union[Object, PyObject]
    ) -> Dataset: ...
    @staticmethod
    def sort(
        ds: Dataset,
        keyColumn: Union[int, String],
        ascending: Optional[bool] = ...,
        naturalOrdering: Optional[bool] = ...,
    ) -> BasicDataset: ...
    @staticmethod
    def toCSV(*args: PyObject, **kwargs: String) -> String: ...
    @staticmethod
    def toCSVJava(
        ds: Dataset, showHeaders: bool, forExport: bool, localized: bool = ...
    ) -> String: ...
    @staticmethod
    def toCSVJavaStreaming(
        ds: Dataset, showHeaders: bool, forExport: bool, sw: Writer, localized: bool
    ) -> None: ...
    @staticmethod
    def toDataSet(*args: Any) -> Dataset: ...
    @staticmethod
    def toExcel(*args: PyObject, **kwargs: String) -> bytearray: ...
    @staticmethod
    def toJSONObject(data: Dataset) -> JSONObject: ...
    @staticmethod
    def toPyDataSet(dataset: Dataset) -> PyDataSet: ...
    @staticmethod
    def updateRow(ds: Dataset, row: int, changes: Dict[String, Any]) -> Dataset: ...

    class PyDataSet(Dataset, AbstractJythonSequence):
        def __init__(self, ds: Optional[Dataset] = ...) -> None: ...
        def __add__(self, other: PyObject) -> PyObject: ...
        def getColumnCount(self) -> int: ...
        def getColumnIndex(self, colName: String) -> int: ...
        def getColumnName(self, col: int) -> String: ...
        def getColumnNames(self) -> List[String]: ...
        def getColumnType(self, col: int) -> Class: ...
        def getColumnTypes(self) -> List[Class]: ...
        def getPrimitiveValueAt(self, row: int, col: int) -> float: ...
        def getQualityAt(self, row: int, col: int) -> QualityCode: ...
        def getRowCount(self) -> int: ...
        def getValueAt(self, row: int, col: Union[int, String]) -> Any: ...
        def setData(self, data: Dataset) -> None: ...

class SProcCall(Object):
    callFinished: bool
    datasource: String
    params: Dict[SProcCall.SProcArgKey, SProcCall.SProcArg]
    procedureName: String
    resultset: Dataset
    returnParam: SProcCall.SProcArg
    skipAudit: bool
    txId: String
    updateCount: int
    def getDataSource(self) -> String: ...
    def getOutParamValue(self, param: Union[int, String]) -> Any: ...
    def getProcedureName(self) -> String: ...
    def getResultSet(self) -> BasicDataset: ...
    def getReturnValue(self) -> Any: ...
    def getTxId(self) -> String: ...
    def getUpdateCount(self) -> int: ...
    def isSkipAudit(self) -> bool: ...
    def registerInParam(
        self, param: Union[int, String], typeCode: int, value: Any
    ) -> None: ...
    def registerOutParam(self, param: Union[int, String], typeCode: int) -> None: ...
    def registerReturnParam(self, typeCode: int) -> None: ...
    def setSkipAudit(self, skipAudit: bool) -> None: ...
    def setTxId(self, txId: String) -> None: ...

    class SProcArg(Object):
        outParam: bool
        inParam: bool
        paramType: int
        value: Object
        def getParamType(self) -> int: ...
        def getValue(self) -> Any: ...
        def isInParam(self) -> bool: ...
        def isOutParam(self) -> bool: ...
        def setParamType(self, paramType: int) -> None: ...
        def setValue(self, value: Object) -> None: ...

    class SProcArgKey(Object):
        index: int
        name: String
        def getParamIndex(self) -> int: ...
        def getParamName(self) -> String: ...
        def isNamedParam(self) -> bool: ...

class SystemUtilities(Object):
    @staticmethod
    def logger(loggerName: String) -> Logger: ...
    @staticmethod
    def parseTranslateArguments(
        *args: PyObject, **kwargs: String
    ) -> Tuple[String, String, bool]: ...

    class RequestImpl(Object, Request):
        timeout: int
        def __init__(self, timeout: int) -> None: ...
        def cancel(self) -> None: ...
        def checkTimeout(self) -> None: ...
        def finishExceptionally(self, e: JavaException) -> None: ...
        def finishSuccessfully(self, value: Object) -> None: ...
        def get(self) -> Object: ...
        def getError(self) -> JavaException: ...
        def getLongId(self) -> long: ...
        def onError(self, func: PyFunction) -> None: ...
        def onSuccess(self, func: PyFunction) -> None: ...
