from typing import Any, List, Optional

from java.lang import Class, Enum, Object, String, StringBuilder

class OPCBrowseElement:
    def getDataType(self) -> Class: ...
    def getDescription(self) -> String: ...
    def getDisplayName(self) -> String: ...
    def getElementType(self) -> BrowseElementType: ...
    def getNodeId(self) -> String: ...
    def getServerNodeId(self) -> ServerNodeId: ...

class ServerNodeId:
    def getNodeId(self) -> String: ...
    def getServerName(self) -> String: ...

class BasicOPCBrowseElement(Object, OPCBrowseElement):
    def __init__(self, *args: Any) -> None: ...
    def getDataType(self) -> Class: ...
    def getDescription(self) -> String: ...
    def getDisplayName(self) -> String: ...
    def getElementType(self) -> BrowseElementType: ...
    def getNodeId(self) -> String: ...
    def getServerNodeId(self) -> ServerNodeId: ...

class BasicServerNodeId(Object, ServerNodeId):
    nodeId: String
    serverName: String
    def __init__(self, serverName: String, nodeId: String) -> None: ...
    def getNodeId(self) -> String: ...
    def getServerName(self) -> String: ...

class BrowseElement(Object):
    PROP_PROVIDER: int
    PROP_DRIVER: int
    def __init__(self, itemType: Optional[int] = ...) -> None: ...
    def addProperty(self, id_: int, name: String, value: String) -> None: ...
    def asServerNodeId(self) -> ServerNodeId: ...
    def createRequestElement(self, type_: int) -> BrowseElement: ...
    def fillInDetails(self, elm: BrowseElement) -> None: ...
    def getBrowsePath(self) -> String: ...
    def getItemId(self) -> String: ...
    def getItemName(self) -> String: ...
    def getItemType(self) -> Optional[int]: ...
    def getProperties(self) -> List[BrowseElement.PropertyElement]: ...
    def getProperty(self, id_: int) -> BrowseElement.PropertyElement: ...
    def getServer(self) -> String: ...
    def isComplete(self) -> bool: ...
    def setBrowsePath(self, browsePath: String) -> None: ...
    def setComplete(self, value: bool) -> None: ...
    def setItemId(self, itemId: String) -> None: ...
    def setItemName(self, itemName: String) -> None: ...
    def setItemType(self, itemType: int) -> None: ...
    def setServer(self, server: String) -> None: ...
    @staticmethod
    def toBrowseElement(opcElem: OPCBrowseElement) -> BrowseElement: ...
    @staticmethod
    def toBrowseElements(
        opcElements: List[OPCBrowseElement],
    ) -> List[BrowseElement]: ...
    @staticmethod
    def toServerNodeId(elem: BrowseElement) -> ServerNodeId: ...
    def toXML(
        self,
        out: StringBuilder,
        type_: Optional[int] = ...,
        includeProperties: Optional[bool] = ...,
    ) -> None: ...

    class PropertyElement(Object):
        id: int
        name: String
        value: String
        def __init__(self, id_: int, name: String, value: String) -> None: ...
        def getId(self) -> int: ...
        def getName(self) -> String: ...
        def getValue(self) -> String: ...

class BrowseElementType(Enum):
    DATAVARIABLE: BrowseElementType
    DEVICE: BrowseElementType
    FOLDER: BrowseElementType
    METHOD: BrowseElementType
    OBJECT: BrowseElementType
    PROPERTY: BrowseElementType
    SERVER: BrowseElementType
    VIEW: BrowseElementType
    def isSubscribable(self) -> bool: ...
    @staticmethod
    def values() -> List[BrowseElementType]: ...

class ServerBrowseElement(Object, OPCBrowseElement):
    nodeId: ServerNodeId
    def __init__(self, serverName: String) -> None: ...
    def getDataType(self) -> Class: ...
    def getDescription(self) -> String: ...
    def getDisplayName(self) -> String: ...
    def getElementType(self) -> BrowseElementType: ...
    def getNodeId(self) -> String: ...
    def getServerNodeId(self) -> ServerNodeId: ...
