from typing import Any, Dict, List, Optional, Type, Union

from com.inductiveautomation.ignition.common import Dataset
from com.inductiveautomation.ignition.common.script.builtin import DatasetUtilities
from dev.coatl.helper.types import AnyNum, AnyStr
from java.util import Date, Locale

ColType = Union[AnyNum, AnyStr, Date]

def addColumn(
    dataset: Dataset,
    colIndex: int,
    col: List[Any],
    colName: AnyStr,
    colType: Type[ColType],
) -> Dataset: ...
def addRow(dataset: Dataset, rowIndex: int, row: List[Any]) -> Dataset: ...
def addRows(dataset: Dataset, rowIndex: int, rows: List[List[Any]]) -> Dataset: ...
def appendDataset(dataset1: Dataset, dataset2: Dataset) -> Dataset: ...
def clearDataset(dataset: Dataset) -> Dataset: ...
def dataSetToHTML(showHeaders: bool, dataset: Dataset, title: AnyStr) -> AnyStr: ...
def deleteRow(dataset: Dataset, rowIndex: int) -> Dataset: ...
def deleteRows(dataset: Dataset, rowIndices: List[int]) -> Dataset: ...
def exportCSV(filename: AnyStr, showHeaders: bool, dataset: Dataset) -> AnyStr: ...
def exportExcel(
    filename: AnyStr,
    showHeaders: bool,
    dataset: Union[Dataset, List[Dataset]],
    nullsEmpty: bool = ...,
) -> AnyStr: ...
def exportHTML(
    filename: AnyStr, showHeaders: bool, dataset: Dataset, title: AnyStr
) -> AnyStr: ...
def filterColumns(
    dataset: Dataset, columns: Union[List[AnyStr], List[int]]
) -> Dataset: ...
def formatDates(
    dataset: Dataset, dateFormat: AnyStr, locale: Optional[Locale] = ...
) -> Dataset: ...
def fromCSV(csv: AnyStr) -> Dataset: ...
def getColumnHeaders(dataset: Dataset) -> List[AnyStr]: ...
def setValue(
    dataset: Dataset, rowIndex: int, columnNameOrIndex: Union[AnyStr, int], value: Any
) -> Dataset: ...
def sort(
    dataset: Dataset,
    keyColumn: Union[AnyStr, int],
    ascending: bool = ...,
    naturalOrdering: bool = ...,
) -> Dataset: ...
def toCSV(
    dataset: Dataset,
    showHeaders: bool = ...,
    forExport: bool = ...,
    localized: bool = ...,
) -> AnyStr: ...
def toDataSet(*args: Any) -> Dataset: ...
def toExcel(
    showHeaders: bool,
    dataset: List[Dataset],
    nullsEmpty: bool = ...,
    sheetNames: Optional[List[AnyStr]] = ...,
) -> Any: ...
def toPyDataSet(dataset: Dataset) -> DatasetUtilities.PyDataSet: ...
def updateRow(
    dataset: Dataset, rowIndex: int, changes: Dict[AnyStr, Any]
) -> Dataset: ...
