from typing import Any, Union

from dev.coatl.helper.types import AnyStr
from java.lang import Object
from java.math import BigDecimal
from java.nio import ByteBuffer
from java.util import Date
from org.bson import BSONObject, Document

class Binary(Object):
    def __init__(self, *args: Any) -> None: ...
    def getData(self) -> Any: ...
    def getType(self) -> Any: ...
    def length(self) -> int: ...

class BSONTimestamp(Object):
    def __init__(self, time: int = ..., increment: int = ...) -> None: ...
    def compareTo(self, ts: BSONTimestamp) -> int: ...
    def getInc(self) -> int: ...
    def getTime(self) -> int: ...

class Code(Object):
    def __init__(self, code: AnyStr) -> None: ...
    def getCode(self) -> AnyStr: ...

class CodeWScope(Code):
    def __init__(self, code: AnyStr, scope: BSONObject) -> None: ...
    def getScope(self) -> BSONObject: ...

class CodeWithScope(Code):
    def __init__(self, code: AnyStr, scope: Document) -> None: ...
    def getScope(self) -> Document: ...

class Decimal128(Object):
    Nan: Decimal128
    NEGATIVE_INFINITY: Decimal128
    NEGATIVE_NaN: Decimal128
    NEGATIVE_ZERO: Decimal128
    POSITIVE_INFINITY: Decimal128
    POSITIVE_ZERO: Decimal128
    def __init__(self, value: Union[BigDecimal, long]) -> None: ...
    def bigDecimalValue(self) -> BigDecimal: ...
    @staticmethod
    def fromIEEE754BIDEncoding(high: long, low: long) -> Decimal128: ...
    def getHigh(self) -> long: ...
    def getLow(self) -> long: ...
    def isFinite(self) -> bool: ...
    def isInfinite(self) -> bool: ...
    def isNaN(self) -> bool: ...
    def isNegative(self) -> bool: ...
    @staticmethod
    def parse(value: AnyStr) -> Decimal128: ...

class MaxKey(Object):
    def __init__(self) -> None: ...

class MinKey(Object):
    def __init__(self) -> None: ...

class ObjectId(Object):
    def __init__(self, *args: Any) -> None: ...
    @staticmethod
    def createFromLegacyFormat(time: int, machine: int, inc: int) -> ObjectId: ...
    def getCounter(self) -> int: ...
    def getDate(self) -> Date: ...
    @staticmethod
    def getGeneratedMachineIdentifier() -> int: ...
    @staticmethod
    def getGeneratedProcessIdentifier() -> int: ...
    def getMachineIdentifier(self) -> int: ...
    def getProcessIdentifier(self) -> int: ...
    def getTimestamp(self) -> int: ...
    @staticmethod
    def isValid(hexString: AnyStr) -> bool: ...
    def putToByteBuffer(self, buffer: ByteBuffer) -> None: ...
    def toHexString(self) -> AnyStr: ...

class Symbol(Object):
    def __init__(self, symbol: AnyStr) -> None: ...
    def getSymbol(self) -> AnyStr: ...
