from typing import Any, Iterable, Set

from java.lang import AutoCloseable, Enum, Runnable
from java.util import Iterator, Spliterator
from java.util.function import BiConsumer, BinaryOperator, Consumer, Function, Supplier

class BaseStream(AutoCloseable):
    def close(self) -> None: ...
    def isParallel(self) -> bool: ...
    def iterator(self) -> Iterator: ...
    def onClose(self, closeHandler: Runnable) -> Any: ...
    def parallel(self) -> Any: ...
    def sequential(self) -> Any: ...
    def spliterator(self) -> Spliterator: ...
    def unordered(self) -> Any: ...

class Collector:
    def accumulator(self) -> BiConsumer: ...
    def characteristic(self) -> Set[Collector.Characteristics]: ...
    def combiner(self) -> BinaryOperator: ...
    def finisher(self) -> Function: ...
    @staticmethod
    def of(*args: Any) -> Collector: ...
    def supplier(self) -> Supplier: ...

    class Characteristics(Enum):
        @staticmethod
        def values() -> Iterable[Collector.Characteristics]: ...

class Stream(BaseStream):
    @staticmethod
    def builder() -> Stream.Builder: ...
    def close(self) -> None: ...
    def isParallel(self) -> bool: ...
    def iterator(self) -> Iterator: ...
    def onClose(self, closeHandler: Runnable) -> Any: ...
    def parallel(self) -> Any: ...
    def sequential(self) -> Any: ...
    def spliterator(self) -> Spliterator: ...
    def unordered(self) -> Any: ...

    class Builder(Consumer):
        def accept(self, t: Any) -> None: ...
        def add(self, t: Any) -> Stream.Builder: ...
        def build(self) -> Stream: ...
