from typing import Dict, Optional, Set

from dev.coatl.helper.types import AnyStr
from java.lang import CharSequence, Object

class Clock(Object):
    @staticmethod
    def offset(baseClock: Instant, offsetDuration: ZoneId) -> Clock: ...
    @staticmethod
    def systemDefaultZone() -> Clock: ...
    @staticmethod
    def systemUTC() -> Clock: ...
    @staticmethod
    def tick(baseClock: Clock, tickDuration: Duration) -> Clock: ...
    @staticmethod
    def tickMillis(zone: ZoneId) -> Clock: ...
    @staticmethod
    def tickMinutes(zone: ZoneId) -> Clock: ...
    @staticmethod
    def tickSeconds(zone: ZoneId) -> Clock: ...

class Duration(Object):
    ZERO: Duration
    def toDays(self) -> long: ...
    def toDaysPart(self) -> long: ...
    def toHours(self) -> long: ...
    def toHoursPart(self) -> int: ...
    def toMillis(self) -> long: ...
    def toMillisPart(self) -> int: ...
    def toMinutes(self) -> long: ...
    def toMinutesPart(self) -> int: ...
    def toNanos(self) -> long: ...
    def toNanosPart(self) -> int: ...
    def toSeconds(self) -> long: ...
    def toSecondsPart(self) -> int: ...

class Instant(Object):
    EPOCH: Instant
    MAX: Instant
    MIN: Instant
    @staticmethod
    def now(clock: Optional[Clock] = ...) -> Instant: ...
    @staticmethod
    def ofEpochMilli(epochMilli: long) -> Instant: ...
    @staticmethod
    def ofEpochSecond(
        epochSecond: long, nanoAdjustment: Optional[long] = ...
    ) -> Instant: ...
    @staticmethod
    def parse(text: CharSequence) -> Instant: ...

class ZoneId(Object):
    SHORT_IDS: Dict[AnyStr, AnyStr]
    @staticmethod
    def getAvailableZoneIds() -> Set[AnyStr]: ...
    @staticmethod
    def of(
        zoneId: AnyStr, aliasMap: Optional[Dict[AnyStr, AnyStr]] = ...
    ) -> ZoneId: ...
    @staticmethod
    def ofOffset(prefix: AnyStr, offset: ZoneOffset) -> ZoneId: ...
    @staticmethod
    def systemDefault() -> ZoneId: ...

class ZoneOffset(Object):
    MAX: ZoneOffset
    MIN: ZoneOffset
    UTC: ZoneOffset
    @staticmethod
    def of(offsetId: AnyStr) -> ZoneOffset: ...
    @staticmethod
    def ofHours(hours: int) -> ZoneOffset: ...
    @staticmethod
    def ofHoursMinutes(hours: int, minutes: int) -> ZoneOffset: ...
    @staticmethod
    def ofHoursMinutesSeconds(hours: int, minutes: int, seconds: int) -> ZoneOffset: ...
    @staticmethod
    def ofTotalSeconds(totalSeconds: int) -> ZoneOffset: ...
