from typing import Any, Optional, Set, Union

from java.lang import AutoCloseable, Object
from java.nio import ByteBuffer, MappedByteBuffer
from java.util.function import Consumer

class Channel(AutoCloseable):
    def close(self) -> None: ...
    def isOpen(self) -> bool: ...

class ReadableByteChannel(Channel):
    def read(self, dst: ByteBuffer) -> int: ...

class WriteableByteChannel(Channel):
    def write(self, src: ByteBuffer) -> int: ...

class FileChannel(Object, Channel):
    def force(self, metaData: bool) -> None: ...
    def lock(self) -> FileLock: ...
    def map(
        self, mode: FileChannel.MapMode, position: long, size: long
    ) -> MappedByteBuffer: ...
    @staticmethod
    def open(*args: Any) -> FileChannel: ...
    def position(
        self, newPosition: Optional[long] = ...
    ) -> Union[FileChannel, long]: ...
    def read(self, *args: Any) -> Union[int, long]: ...
    def size(self) -> long: ...
    def transferFrom(
        self, src: ReadableByteChannel, position: long, count: long
    ) -> long: ...
    def transferTo(
        self, position: long, count: long, target: WriteableByteChannel
    ) -> long: ...
    def truncate(self, size: long) -> FileChannel: ...
    def tryLock(
        self,
        position: Optional[long] = ...,
        size: Optional[long] = ...,
        shared: Optional[bool] = ...,
    ) -> FileLock: ...
    def write(self, *args: Any) -> Union[int, long]: ...

    class MapMode(Object):
        PRIVATE: FileChannel.MapMode
        READ_ONLY: FileChannel.MapMode
        READ_WRITE: FileChannel.MapMode

class FileLock(Object, AutoCloseable):
    def acquiredBy(self) -> Channel: ...
    def channel(self) -> FileChannel: ...
    def close(self) -> None: ...
    def isShared(self) -> bool: ...
    def isValid(self) -> bool: ...
    def overlaps(self, position: long, size: long) -> bool: ...
    def position(self) -> long: ...
    def release(self) -> None: ...
    def size(self) -> long: ...

class SeekableByteChannel(ReadableByteChannel, WriteableByteChannel):
    def position(
        self, newPosition: Optional[long] = ...
    ) -> Union[long, SeekableByteChannel]: ...
    def size(self) -> long: ...
    def truncate(self, size: long) -> SeekableByteChannel: ...

class SelectableChannel(Object, AutoCloseable):
    def close(self) -> None: ...
    def blockingLock(self) -> Object: ...
    def configureBlocking(self) -> SelectableChannel: ...
    def isBlocking(self) -> bool: ...
    def isRegistered(self) -> bool: ...
    def keyFor(self, sel: Selector) -> SelectionKey: ...
    def provider(self) -> Object: ...
    def register(
        self, sel: Selector, ops: int, att: Optional[Object] = ...
    ) -> SelectionKey: ...
    def validOps(self) -> int: ...

class SelectionKey(Object):
    OP_ACCEPT: int
    OP_CONNECT: int
    OP_READ: int
    OP_WRITE: int
    def attach(self, ob: Object) -> Object: ...
    def attachment(self) -> Object: ...
    def cancel(self) -> None: ...
    def channel(self) -> SelectableChannel: ...
    def interestOps(self, ops: Optional[int] = ...) -> Union[int, SelectionKey]: ...
    def interestOpsAnd(self, ops: int) -> int: ...
    def interestOpsOr(self, ops: int) -> int: ...
    def isAcceptable(self) -> bool: ...
    def isConnectable(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isValid(self) -> bool: ...
    def isWriteable(self) -> bool: ...
    def readyOps(self) -> int: ...
    def selector(self) -> Selector: ...

class Selector(Object, AutoCloseable):
    def close(self) -> None: ...
    def isOpen(self) -> bool: ...
    def keys(self) -> Set[SelectionKey]: ...
    @staticmethod
    def open() -> Selector: ...
    def provider(self) -> Object: ...
    def select(self, *args: Any) -> int: ...
    def selectedKeys(self) -> Set[SelectionKey]: ...
    def selectNow(self, action: Optional[Consumer] = ...) -> int: ...
    def wakeup(self) -> Selector: ...

class SocketChannel(SelectableChannel):
    def bind(self, local: Any) -> SocketChannel: ...
    def connect(self, remote: Any) -> bool: ...
    def finishConnect(self) -> bool: ...
    def getLocalAddress(self) -> Any: ...
    def getRemoteAddress(self) -> Any: ...
    def isConnected(self) -> bool: ...
    def isConnectionPending(self) -> bool: ...
    def open(self, remote: Optional[Any] = ...) -> SocketChannel: ...
    def read(self, *args: Any) -> Union[int, long]: ...
    def setOption(self, name: Any, value: Any) -> SocketChannel: ...
    def shutdownInput(self) -> SocketChannel: ...
    def shutdownOutput(self) -> SocketChannel: ...
    def socket(self) -> Any: ...
    def write(self, *args: Any) -> Union[int, long]: ...
