from typing import Any, Iterator, List, Optional

from com.inductiveautomation.ignition.common.model.values import (
    QualifiedValue,
    QualityCode,
)
from com.inductiveautomation.ignition.common.sqltags.model.types import (
    DataType,
    DataTypeClass,
)
from dev.coatl.helper.types import AnyStr
from java.lang import Object

class AttributeInfo(Object):
    def __init__(self, *args: Any) -> None: ...
    def getDesc(self) -> AnyStr: ...
    def getId(self) -> int: ...
    def getName(self) -> AnyStr: ...
    def getType(self) -> DataType: ...
    def setType(self, type_: DataType) -> None: ...

class ReadResult(Object):
    def __init__(self, serviceResult: Optional[QualityCode] = ...) -> None: ...
    def getServiceResult(self) -> QualityCode: ...
    def getTypeClass(self) -> DataTypeClass: ...
    def getValues(self) -> List[QualifiedValue]: ...
    def iterator(self) -> Iterator[QualifiedValue]: ...
    def setServiceResult(self, serviceResult: QualityCode) -> None: ...
    def setTypeClass(self, typeClass: DataTypeClass) -> None: ...
    def setValues(self, values: List[QualifiedValue]) -> None: ...
    def size(self) -> int: ...
